/*----------------------------------------------------------------------------
 *
 * Filename: wt_44khz.c
 * Purpose: Wavetable sound libary
 *
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

/*----------------------------------------------------------------------------
 * Articulations
 *----------------------------------------------------------------------------
*/
static const S_ARTICULATION eas_articulations[] =
{
    { /* articulation 0 */
        { 32767, 31730, 0, 31730 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 1 */
        { 32767, 29669, 0, 29669 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 2 */
        { 32767, 31605, 0, 31701 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 3 */
        { 32767, 29434, 0, 29434 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 4 */
        { 32767, 0, 32767, 32742 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 5 */
        { 32767, 26439, 0, 26439 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 6 */
        { 32767, 32322, 0, 32350 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 7 */
        { 32767, 32715, 32767, 32715 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 8 */
        { 32767, 0, 32767, 0 },
        { 32767, 951, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 9 */
        { 32767, 32558, 0, 32558 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 10 */
        { 32767, 0, 32767, 23749 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -1
    },
    { /* articulation 11 */
        { 32767, 32245, 0, 32245 },
        { 32767, 380, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -44
    },
    { /* articulation 12 */
        { 32767, 27897, 0, 27897 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 56
    },
    { /* articulation 13 */
        { 32767, 32245, 0, 32245 },
        { 32767, 380, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -31
    },
    { /* articulation 14 */
        { 4755, 26439, 0, 26439 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 56
    },
    { /* articulation 15 */
        { 32767, 32187, 0, 32187 },
        { 32767, 380, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -6
    },
    { /* articulation 16 */
        { 32767, 32444, 0, 32480 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 56
    },
    { /* articulation 17 */
        { 32767, 32153, 0, 32153 },
        { 32767, 380, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 6
    },
    { /* articulation 18 */
        { 32767, 32072, 0, 32072 },
        { 32767, 476, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 31
    },
    { /* articulation 19 */
        { 32767, 32363, 0, 32363 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 25
    },
    { /* articulation 20 */
        { 32767, 31901, 0, 31901 },
        { 32767, 476, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 63
    },
    { /* articulation 21 */
        { 32767, 32528, 0, 32518 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -37
    },
    { /* articulation 22 */
        { 9511, 32322, 0, 32337 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -37
    },
    { /* articulation 23 */
        { 32767, 32376, 0, 32398 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -37
    },
    { /* articulation 24 */
        { 32767, 0, 32767, 32715 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 12
    },
    { /* articulation 25 */
        { 32767, 32052, 0, 32052 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -25
    },
    { /* articulation 26 */
        { 32767, 0, 32767, 32715 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 25
    },
    { /* articulation 27 */
        { 32767, 32289, 0, 32271 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -25
    },
    { /* articulation 28 */
        { 32767, 31730, 0, 31730 },
        { 32767, 48, 0, 0 },
        0, 0, 476, 240, 0, 0, 0, 0, -56
    },
    { /* articulation 29 */
        { 32767, 32498, 0, 32492 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -37
    },
    { /* articulation 30 */
        { 32767, 29434, 0, 29434 },
        { 32767, 1902, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 50
    },
    { /* articulation 31 */
        { 32767, 27897, 0, 27897 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -50
    },
    { /* articulation 32 */
        { 32767, 31056, 0, 31056 },
        { 32767, 1902, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -50
    },
    { /* articulation 33 */
        { 32767, 31479, 0, 31476 },
        { 32767, 1902, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -44
    },
    { /* articulation 34 */
        { 32767, 32663, 0, 32663 },
        { 32767, 127, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 25
    },
    { /* articulation 35 */
        { 32767, 0, 32767, 32715 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -63
    },
    { /* articulation 36 */
        { 1902, 27897, 0, 27897 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -63
    },
    { /* articulation 37 */
        { 32767, 27897, 0, 27897 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -59
    },
    { /* articulation 38 */
        { 32767, 31730, 0, 31730 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 50
    },
    { /* articulation 39 */
        { 32767, 30725, 0, 30725 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 44
    },
    { /* articulation 40 */
        { 951, 31730, 0, 31730 },
        { 32767, 190, 0, 0 },
        0, 0, 476, -100, 0, 0, 0, 0, 44
    },
    { /* articulation 41 */
        { 32767, 17213, 0, 17213 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 25
    },
    { /* articulation 42 */
        { 32767, 31295, 0, 31295 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 63
    },
    { /* articulation 43 */
        { 32767, 31479, 0, 31476 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 63
    },
    { /* articulation 44 */
        { 9511, 25581, 0, 25581 },
        { 476, 32767, 32767, 0 },
        0, 0, 476, 100, 0, 0, 0, 0, -25
    },
    { /* articulation 45 */
        { 1902, 23749, 0, 23749 },
        { 476, 32767, 32767, 0 },
        0, 0, 476, 500, 0, 0, 0, 0, -25
    },
    { /* articulation 46 */
        { 32767, 23749, 0, 23749 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -56
    },
    { /* articulation 47 */
        { 32767, 31730, 0, 31730 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -56
    },
    { /* articulation 48 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 49 */
        { 32767, 31964, 0, 31964 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 50 */
        { 9511, 32363, 0, 32418 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 51 */
        { 32767, 31180, 0, 31180 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 52 */
        { 32767, 32251, 0, 32052 },
        { 32767, 147, 0, 0 },
        0, 0, 476, 0, 10000, 7121, 0, 0, 0
    },
    { /* articulation 53 */
        { 32767, 0, 32767, 32072 },
        { 32767, 32767, 32767, 0 },
        0, 0, 778, 0, -2300, 11920, 0, 0, 0
    },
    { /* articulation 54 */
        { 587, 0, 32767, 32376 },
        { 32767, 63, 0, 0 },
        0, 0, 778, 0, 2000, 10721, 0, 8, 15
    },
    { /* articulation 55 */
        { 587, 0, 32767, 32376 },
        { 476, 63, 0, 0 },
        0, 0, 778, 0, 2000, 9023, 0, 5, 15
    },
    { /* articulation 56 */
        { 3804, 0, 32767, 31477 },
        { 32767, 34, 5898, 0 },
        0, 0, 778, 0, 6000, 9080, 0, 0, -2
    },
    { /* articulation 57 */
        { 32767, 0, 32767, 31005 },
        { 32767, 32767, 32767, 0 },
        0, 0, 778, 0, 0, 0, 0, 0, 1
    },
    { /* articulation 58 */
        { 2570, 0, 32767, 31455 },
        { 32767, 32767, 32767, 0 },
        0, 0, 778, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 59 */
        { 32767, 32663, 0, 29434 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 60 */
        { 32767, 32558, 0, 29434 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 61 */
        { 32767, 32418, 0, 32418 },
        { 32767, 48, 0, 0 },
        0, 69, 495, 0, 2400, 9521, 0, 0, 0
    },
    { /* articulation 62 */
        { 32767, 31476, 0, 31476 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 11738, 0, 16, 0
    },
    { /* articulation 63 */
        { 32767, 32558, 0, 31391 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 64 */
        { 32767, 32245, 0, 32115 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 65 */
        { 32767, 32593, 0, 28809 },
        { 32767, 48, 0, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 66 */
        { 32767, 32408, 0, 32363 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 67 */
        { 32767, 32350, 0, 32350 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 68 */
        { 4755, 32715, 18820, 27897 },
        { 951, 29, 13107, 0 },
        0, 0, 495, 0, 6000, 5535, 0, 4, 0
    },
    { /* articulation 69 */
        { 32767, 32257, 0, 32245 },
        { 32767, 951, 0, 0 },
        0, 103, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 70 */
        { 63, 32727, 3811, 32558 },
        { 48, 19, 32767, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 71 */
        { 2378, 32715, 3566, 30725 },
        { 1902, 32767, 32767, 0 },
        0, 0, 495, 100, 0, 11919, 0, 0, 0
    },
    { /* articulation 72 */
        { 32767, 32349, 0, 32349 },
        { 32767, 168, 0, 0 },
        0, 34, 495, 0, 7000, 9023, 0, 0, 0
    },
    { /* articulation 73 */
        { 32767, 32072, 0, 32072 },
        { 32767, 168, 0, 0 },
        0, 3, 476, 0, 7000, 9023, 0, 0, 0
    },
    { /* articulation 74 */
        { 32767, 32698, 6208, 32349 },
        { 190, 48, 0, 0 },
        0, 0, 495, 0, 3840, 8302, 0, 8, 0
    },
    { /* articulation 75 */
        { 32767, 32418, 0, 32468 },
        { 32767, 190, 0, 0 },
        0, 0, 495, 0, 5000, 8321, 0, 0, 0
    },
    { /* articulation 76 */
        { 32767, 32349, 0, 32349 },
        { 32767, 190, 0, 0 },
        0, 0, 476, 0, 5000, 7934, 0, 0, 0
    },
    { /* articulation 77 */
        { 32767, 32441, 0, 31709 },
        { 32767, 32, 0, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 78 */
        { 32767, 32505, 0, 27897 },
        { 32767, 951, 0, 0 },
        0, 345, 495, 0, 1000, 11107, 0, 0, 0
    },
    { /* articulation 79 */
        { 32767, 32715, 6208, 32349 },
        { 48, 48, 0, 0 },
        0, 69, 811, 0, 3560, 8834, 1, 8, 0
    },
    { /* articulation 80 */
        { 32767, 32564, 0, 29434 },
        { 32767, 95, 0, 0 },
        0, 34, 495, 0, 6000, 9907, 0, 0, 0
    },
    { /* articulation 81 */
        { 32767, 32505, 0, 27897 },
        { 32767, 32, 0, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 82 */
        { 32767, 32245, 18820, 17213 },
        { 32767, 32767, 32767, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 83 */
        { 32767, 32742, 128, 32466 },
        { 32767, 63, 0, 0 },
        0, 0, 495, 0, 0, 11920, 0, 8, 0
    },
    { /* articulation 84 */
        { 32767, 32418, 0, 32418 },
        { 32767, 33, 0, 0 },
        3, 0, 286, 0, 5000, 5535, 0, 0, 0
    },
    { /* articulation 85 */
        { 1902, 32715, 18820, 27897 },
        { 32767, 1012, 0, 0 },
        10, 69, 504, -30, 0, 0, 0, 0, 0
    },
    { /* articulation 86 */
        { 9511, 32715, 18820, 27897 },
        { 380, 48, 0, 0 },
        0, 69, 495, 0, 4473, 7131, 0, 8, 0
    },
    { /* articulation 87 */
        { 951, 32698, 6208, 32468 },
        { 317, 19, 16384, 0 },
        0, 0, 495, 0, 2987, 7877, 0, 12, 0
    },
    { /* articulation 88 */
        { 32767, 32680, 0, 32349 },
        { 32767, 48, 0, 0 },
        0, 0, 581, 0, 4053, 7930, 2, 12, 0
    },
    { /* articulation 89 */
        { 190, 32726, 6208, 32349 },
        { 32767, 56, 0, 0 },
        0, 0, 495, 0, 0, 8887, 0, 0, 0
    },
    { /* articulation 90 */
        { 9511, 32715, 18820, 27897 },
        { 634, 48, 0, 0 },
        0, 69, 495, 0, 5113, 7981, 0, 4, 0
    },
    { /* articulation 91 */
        { 951, 32715, 6208, 31730 },
        { 951, 63, 0, 0 },
        0, 69, 495, 0, 3500, 7877, 0, 5, 0
    },
    { /* articulation 92 */
        { 951, 32715, 6208, 31730 },
        { 634, 48, 0, 0 },
        0, 69, 476, 0, 4773, 8355, 0, 5, 0
    },
    { /* articulation 93 */
        { 238, 32715, 10809, 32349 },
        { 32767, 32767, 32767, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 94 */
        { 1902, 32715, 18820, 31476 },
        { 32767, 32767, 32767, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 95 */
        { 3804, 32715, 18820, 23749 },
        { 1268, 130, 0, 0 },
        0, 69, 495, 0, 1200, 11690, 0, 4, 0
    },
    { /* articulation 96 */
        { 19021, 32618, 15076, 31476 },
        { 32767, 32767, 32767, 0 },
        0, 72, 1091, 0, 0, 11919, 1, 0, 0
    },
    { /* articulation 97 */
        { 32767, 0, 32767, 32715 },
        { 190, 32767, 32767, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 98 */
        { 32767, 32072, 0, 32072 },
        { 32767, 317, 0, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 99 */
        { 32767, 32663, 0, 27897 },
        { 634, 95, 13107, 0 },
        0, 69, 495, 0, 3200, 8321, 0, 0, 0
    },
    { /* articulation 100 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 101 */
        { 32767, 32418, 0, 27897 },
        { 32767, 543, 0, 0 },
        0, 69, 495, 0, 8187, 5535, 0, 5, 0
    },
    { /* articulation 102 */
        { 19021, 32663, 0, 31056 },
        { 32767, 95, 7667, 0 },
        5, 0, 495, 0, 6053, 5535, 0, 5, 0
    },
    { /* articulation 103 */
        { 32767, 32715, 18820, 27897 },
        { 951, 48, 0, 0 },
        0, 0, 495, 0, 2700, 9852, 0, 0, 0
    },
    { /* articulation 104 */
        { 32767, 32715, 18820, 30234 },
        { 951, 48, 0, 0 },
        0, 0, 495, 0, 2700, 9852, 0, 0, 0
    },
    { /* articulation 105 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 634, 0, 0 },
        0, 103, 476, 0, 2500, 10490, 1, 8, 0
    },
    { /* articulation 106 */
        { 32767, 32715, 23493, 27897 },
        { 32767, 190, 0, 0 },
        0, 69, 494, 0, 4000, 10223, 1, 4, 0
    },
    { /* articulation 107 */
        { 32767, 32715, 18820, 30234 },
        { 32767, 63, 7667, 0 },
        0, 0, 495, 0, 1813, 9154, 0, 0, 0
    },
    { /* articulation 108 */
        { 19021, 32245, 0, 32245 },
        { 32767, 190, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 109 */
        { 32767, 31964, 0, 31605 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 11690, 0, 0, 0
    },
    { /* articulation 110 */
        { 32767, 31730, 0, 31730 },
        { 32767, 190, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 111 */
        { 32767, 32558, 18820, 30234 },
        { 32767, 48, 0, 0 },
        12, 69, 476, 0, 3000, 10223, 0, 0, 0
    },
    { /* articulation 112 */
        { 32767, 32558, 18820, 30234 },
        { 32767, 32, 0, 0 },
        12, 69, 476, 0, 1900, 10031, 0, 0, 0
    },
    { /* articulation 113 */
        { 32767, 32715, 18820, 29434 },
        { 32767, 32, 0, 0 },
        12, 69, 494, 0, 1000, 11107, 0, 0, 0
    },
    { /* articulation 114 */
        { 32767, 32715, 18820, 29434 },
        { 32767, 32, 0, 0 },
        12, 69, 494, 0, 2000, 11107, 0, 0, 0
    },
    { /* articulation 115 */
        { 32767, 32636, 0, 29434 },
        { 32767, 95, 0, 0 },
        0, 34, 495, 0, 4000, 8321, 0, 0, 0
    },
    { /* articulation 116 */
        { 32767, 32297, 19893, 17213 },
        { 32767, 238, 0, 0 },
        0, 69, 726, 0, 0, 11919, 0, 0, 0
    },
    { /* articulation 117 */
        { 9511, 32418, 23493, 17213 },
        { 32767, 32767, 32767, 0 },
        0, 69, 678, 0, 0, 11877, 1, 0, 0
    },
    { /* articulation 118 */
        { 32767, 32618, 0, 27897 },
        { 32767, 95, 0, 0 },
        0, 69, 495, 0, 3500, 9023, 0, 0, 0
    },
    { /* articulation 119 */
        { 32767, 23749, 23493, 0 },
        { 32767, 32767, 32767, 0 },
        0, 34, 761, 0, 0, 10925, 1, 0, 0
    },
    { /* articulation 120 */
        { 32767, 32636, 0, 29434 },
        { 32767, 95, 0, 0 },
        0, 103, 495, 0, 3200, 8721, 0, 4, 0
    },
    { /* articulation 121 */
        { 1902, 32715, 18820, 27897 },
        { 32767, 32767, 32767, 0 },
        0, 69, 495, 0, 0, 0, 1, 0, 0
    },
    { /* articulation 122 */
        { 4755, 32715, 18820, 28809 },
        { 32767, 32767, 32767, 0 },
        0, 69, 495, 0, 0, 11877, 0, 8, 0
    },
    { /* articulation 123 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 16, 0, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 124 */
        { 32767, 32663, 0, 27897 },
        { 32767, 190, 0, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 125 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 12, 0, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 126 */
        { 32767, 31730, 0, 31730 },
        { 32767, 380, 0, 0 },
        0, 0, 495, 0, 3000, 10223, 0, 8, 0
    },
    { /* articulation 127 */
        { 63, 0, 32767, 32558 },
        { 32767, 32767, 32767, 0 },
        0, 0, 761, 0, 0, 11423, 4, 0, 0
    },
    { /* articulation 128 */
        { 476, 32595, 0, 32577 },
        { 32767, 10, 0, 0 },
        0, 0, 495, 0, 0, 11423, 0, 0, 0
    },
    { /* articulation 129 */
        { 196, 0, 0, 31964 },
        { 95, 32767, 32767, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 130 */
        { 32767, 31730, 0, 31730 },
        { 32767, 380, 0, 0 },
        0, 0, 495, 1200, 0, 0, 0, 0, 0
    },
    { /* articulation 131 */
        { 32767, 32245, 0, 32349 },
        { 32767, 190, 0, 0 },
        0, 0, 495, 50, 0, 0, 0, 0, 0
    },
    { /* articulation 132 */
        { 32767, 32418, 0, 32418 },
        { 32767, 9511, 0, 0 },
        0, 0, 495, 0, 4700, 7769, 0, 0, 0
    },
    { /* articulation 133 */
        { 32767, 31391, 0, 31391 },
        { 32767, 19021, 0, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 134 */
        { 32767, 32663, 32767, 32663 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 135 */
        { 32767, 32715, 18820, 23749 },
        { 32767, 95, 0, 0 },
        10, 68, 476, 0, 2000, 10696, 0, 0, 0
    },
    { /* articulation 136 */
        { 32767, 32715, 10809, 23749 },
        { 32767, 95, 0, 0 },
        12, 69, 491, 0, 0, 10910, 0, 0, 0
    },
    { /* articulation 137 */
        { 32767, 32715, 18820, 23749 },
        { 32767, 95, 0, 0 },
        10, 69, 476, 0, 1200, 10218, 0, 0, 0
    },
    { /* articulation 138 */
        { 19021, 32715, 18820, 23749 },
        { 32767, 95, 0, 0 },
        10, 69, 476, 0, 1100, 9525, 0, 0, 0
    },
    { /* articulation 139 */
        { 9511, 32663, 18820, 27897 },
        { 32767, 10, 0, 0 },
        10, 69, 494, 0, 2000, 10962, 0, 0, 0
    },
    { /* articulation 140 */
        { 32767, 32558, 18820, 27897 },
        { 9511, 317, 0, 0 },
        10, 63, 504, 0, 1200, 10090, 0, 0, 0
    },
    { /* articulation 141 */
        { 1268, 0, 32767, 30234 },
        { 951, 190, 0, 0 },
        7, 69, 494, 0, 1620, 8933, 0, 0, 0
    },
    { /* articulation 142 */
        { 32767, 32558, 10809, 27897 },
        { 19021, 190, 0, 0 },
        7, 69, 494, 0, 2200, 8994, 0, 0, 0
    },
    { /* articulation 143 */
        { 32767, 32715, 15076, 27897 },
        { 32767, 951, 0, 0 },
        10, 69, 491, 0, 2500, 9525, 0, 0, 0
    },
    { /* articulation 144 */
        { 32767, 32715, 15076, 27897 },
        { 32767, 95, 0, 0 },
        10, 69, 476, 0, 1500, 11423, 0, 0, 0
    },
    { /* articulation 145 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 951, 0, 0 },
        9, 69, 491, 0, 1500, 9521, 0, 0, 0
    },
    { /* articulation 146 */
        { 1902, 0, 32767, 30725 },
        { 32767, 32767, 32767, 0 },
        0, 0, 761, 0, 0, 9521, 0, 0, 0
    },
    { /* articulation 147 */
        { 32767, 32663, 0, 27897 },
        { 32767, 9511, 0, 0 },
        0, 34, 495, 0, 5000, 10223, 0, 0, 0
    },
    { /* articulation 148 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 32, 0, 0 },
        10, 69, 476, 0, 1500, 9907, 0, 0, 0
    },
    { /* articulation 149 */
        { 32767, 32733, 11682, 27897 },
        { 32767, 951, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 150 */
        { 32767, 32418, 0, 32418 },
        { 32767, 190, 0, 0 },
        0, 34, 495, 0, 3440, 9260, 0, 0, 0
    },
    { /* articulation 151 */
        { 32767, 31476, 0, 31730 },
        { 32767, 951, 0, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 152 */
        { 32767, 32245, 0, 31730 },
        { 32767, 190, 0, 0 },
        0, 34, 495, 0, 4000, 7823, 0, 0, 0
    },
    { /* articulation 153 */
        { 32767, 32663, 3566, 27897 },
        { 391, 32767, 32767, 0 },
        100, 0, 761, 500, 0, 11877, 0, 0, 0
    },
    { /* articulation 154 */
        { 32767, 32715, 18820, 23749 },
        { 32767, 951, 0, 0 },
        8, 69, 495, -22, 0, 0, 0, 0, 0
    },
    { /* articulation 155 */
        { 9511, 30830, 6784, 27897 },
        { 32767, 951, 0, 0 },
        0, 69, 476, 0, 5000, 9521, 1, 0, 0
    },
    { /* articulation 156 */
        { 32767, 32663, 0, 32349 },
        { 951, 127, 16384, 0 },
        0, 103, 495, 0, 3627, 10547, 0, 5, 0
    },
    { /* articulation 157 */
        { 1902, 0, 32767, 27897 },
        { 951, 951, 0, 0 },
        0, 69, 495, 27, 0, 11919, 0, 0, 0
    },
    { /* articulation 158 */
        { 32767, 0, 32767, 32245 },
        { 38, 33, 10092, 0 },
        5, 0, 495, 0, 8007, 5535, 0, 8, 0
    },
    { /* articulation 159 */
        { 32767, 32618, 0, 31056 },
        { 32767, 63, 0, 0 },
        0, 103, 495, 0, 2500, 9032, 0, 0, 0
    },
    { /* articulation 160 */
        { 4755, 32715, 10809, 28809 },
        { 32767, 32767, 32767, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 161 */
        { 9511, 32663, 18820, 27897 },
        { 32767, 95, 0, 0 },
        10, 69, 494, 0, 2600, 9513, 0, 0, 0
    },
    { /* articulation 162 */
        { 32767, 32435, 9568, 27897 },
        { 1174, 196, 0, 0 },
        10, 103, 490, 0, 6500, 9023, 0, 0, 0
    },
    { /* articulation 163 */
        { 32767, 32663, 0, 29434 },
        { 32767, 32, 0, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 164 */
        { 32767, 32418, 15076, 23749 },
        { 32767, 634, 0, 0 },
        0, 0, 476, 0, 2000, 10223, 0, 0, 0
    },
    { /* articulation 165 */
        { 32767, 32663, 0, 27897 },
        { 32767, 190, 0, 0 },
        0, 69, 495, 0, 3000, 9366, 0, 0, 0
    },
    { /* articulation 166 */
        { 32767, 32715, 18820, 27897 },
        { 951, 64, 10879, 0 },
        0, 0, 495, 0, 6000, 7121, 0, 4, 0
    },
    { /* articulation 167 */
        { 32767, 32636, 0, 29434 },
        { 32767, 10, 0, 0 },
        0, 103, 495, 0, 3500, 6236, 0, 5, 0
    },
    { /* articulation 168 */
        { 32767, 32636, 0, 29434 },
        { 32767, 95, 0, 0 },
        0, 103, 495, 0, 2800, 7121, 0, 0, 0
    },
    { /* articulation 169 */
        { 32767, 32593, 0, 31056 },
        { 32767, 63, 0, 0 },
        0, 103, 495, 0, 2100, 9626, 0, 0, 0
    },
    { /* articulation 170 */
        { 32767, 32558, 0, 31476 },
        { 32767, 63, 0, 0 },
        0, 103, 495, 0, 3000, 9626, 0, 0, 0
    },
    { /* articulation 171 */
        { 32767, 32527, 0, 30506 },
        { 32767, 63, 0, 0 },
        0, 103, 495, 0, 1000, 9032, 0, 0, 0
    },
    { /* articulation 172 */
        { 32767, 32418, 0, 30725 },
        { 32767, 63, 0, 0 },
        0, 103, 495, 0, 1000, 9032, 0, 0, 0
    },
    { /* articulation 173 */
        { 1902, 32418, 15076, 23749 },
        { 32767, 634, 0, 0 },
        0, 103, 496, 0, 0, 11107, 0, 8, 0
    },
    { /* articulation 174 */
        { 32767, 32558, 15076, 27897 },
        { 3804, 73, 0, 0 },
        0, 0, 495, 0, 4500, 9521, 0, 8, 0
    },
    { /* articulation 175 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 48, 0, 0 },
        0, 0, 495, 0, 2000, 8321, 0, 8, 0
    },
    { /* articulation 176 */
        { 32767, 32742, 128, 31180 },
        { 32767, 865, 0, 0 },
        0, 0, 495, 0, 6000, 7823, 0, 8, 0
    },
    { /* articulation 177 */
        { 9511, 32608, 0, 32322 },
        { 32767, 48, 0, 0 },
        0, 0, 495, 0, 4500, 7121, 0, 8, 0
    },
    { /* articulation 178 */
        { 19021, 32664, 3646, 32436 },
        { 32767, 95, 0, 0 },
        0, 0, 495, 0, 4000, 8321, 0, 8, 0
    },
    { /* articulation 179 */
        { 32767, 32685, 13644, 29434 },
        { 32767, 32, 0, 0 },
        12, 69, 494, 0, 2000, 11107, 0, 0, 0
    },
    { /* articulation 180 */
        { 9511, 31605, 0, 27897 },
        { 32767, 951, 0, 0 },
        0, 0, 495, 0, 5000, 8321, 1, 0, 0
    },
    { /* articulation 181 */
        { 130, 32617, 0, 32350 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 182 */
        { 32767, 32593, 0, 32251 },
        { 1174, 20, 0, 0 },
        0, 69, 495, 0, 3600, 7121, 0, 4, 0
    },
    { /* articulation 183 */
        { 32767, 32427, 0, 32427 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 184 */
        { 834, 32742, 19242, 31455 },
        { 32767, 148, 0, 0 },
        0, 0, 778, 0, 3000, 9907, 0, 4, 0
    }
}; /*end Articulations */

/*----------------------------------------------------------------------------
 * Regions
 *----------------------------------------------------------------------------
*/
static const S_WT_REGION eas_regions[] =
{
    { { 0, 27, 27 }, -4068, 16422, 0, 0, 81, 0 }, /* region 0 */
    { { 0, 28, 28 }, -4768, 32767, 0, 0, 40, 0 }, /* region 1 */
    { { 0, 29, 29 }, -5753, 32767, 0, 0, 32, 1 }, /* region 2 */
    { { 0, 30, 30 }, -6053, 32767, 0, 0, 32, 2 }, /* region 3 */
    { { 0, 31, 31 }, -5068, 23197, 0, 0, 48, 3 }, /* region 4 */
    { { 1536, 32, 32 }, -4400, 20675, 0, 0, 137, 4 }, /* region 5 */
    { { 1537, 33, 33 }, -4903, 20675, 792, 879, 50, 5 }, /* region 6 */
    { { 1537, 34, 34 }, -5003, 16422, 792, 879, 50, 6 }, /* region 7 */
    { { 0, 35, 35 }, -6168, 32767, 0, 0, 83, 7 }, /* region 8 */
    { { 0, 36, 36 }, -6168, 32767, 0, 0, 83, 7 }, /* region 9 */
    { { 0, 37, 37 }, -5251, 18426, 0, 0, 53, 8 }, /* region 10 */
    { { 0, 38, 38 }, -5351, 23197, 0, 0, 16, 9 }, /* region 11 */
    { { 0, 39, 39 }, -4768, 32767, 0, 0, 40, 10 }, /* region 12 */
    { { 0, 40, 40 }, -5351, 23197, 0, 0, 16, 4 }, /* region 13 */
    { { 1, 41, 41 }, -7055, 26028, 798, 993, 45, 11 }, /* region 14 */
    { { 257, 42, 42 }, -5400, 26028, 4288, 7488, 7, 12 }, /* region 15 */
    { { 1, 43, 43 }, -6955, 26028, 798, 993, 45, 13 }, /* region 16 */
    { { 257, 44, 44 }, -5600, 26028, 4288, 7488, 7, 14 }, /* region 17 */
    { { 1, 45, 45 }, -6955, 26028, 798, 993, 45, 15 }, /* region 18 */
    { { 257, 46, 46 }, -5800, 26028, 4288, 7488, 7, 16 }, /* region 19 */
    { { 1, 47, 47 }, -6655, 26028, 798, 993, 45, 17 }, /* region 20 */
    { { 1, 48, 48 }, -6555, 26028, 798, 993, 45, 18 }, /* region 21 */
    { { 1, 49, 49 }, -6400, 16422, 1294, 5778, 8, 19 }, /* region 22 */
    { { 1, 50, 50 }, -6455, 26028, 798, 993, 45, 20 }, /* region 23 */
    { { 1, 51, 51 }, -6468, 16422, 6592, 9921, 6, 21 }, /* region 24 */
    { { 1, 52, 52 }, -6800, 32767, 1294, 5778, 8, 22 }, /* region 25 */
    { { 1, 53, 53 }, -6618, 14636, 6592, 9921, 6, 23 }, /* region 26 */
    { { 0, 54, 54 }, -6951, 26028, 0, 0, 39, 24 }, /* region 27 */
    { { 1, 55, 55 }, -6500, 32767, 1294, 5778, 8, 25 }, /* region 28 */
    { { 0, 56, 56 }, -8455, 32767, 0, 0, 90, 26 }, /* region 29 */
    { { 1, 57, 57 }, -6900, 32767, 1294, 5778, 8, 27 }, /* region 30 */
    { { 1, 58, 58 }, -8253, 23197, 0, 166, 113, 28 }, /* region 31 */
    { { 1, 59, 59 }, -7168, 16422, 6592, 9921, 6, 29 }, /* region 32 */
    { { 1, 60, 60 }, -7653, 23197, 432, 582, 63, 30 }, /* region 33 */
    { { 1, 61, 61 }, -8053, 16422, 432, 582, 63, 30 }, /* region 34 */
    { { 1, 62, 62 }, -8453, 20675, 432, 582, 63, 31 }, /* region 35 */
    { { 1, 63, 63 }, -8553, 23197, 432, 582, 63, 32 }, /* region 36 */
    { { 1, 64, 64 }, -9153, 23197, 432, 582, 63, 33 }, /* region 37 */
    { { 0, 65, 65 }, -8755, 32767, 0, 0, 14, 34 }, /* region 38 */
    { { 0, 66, 66 }, -9155, 20675, 0, 0, 14, 34 }, /* region 39 */
    { { 512, 67, 67 }, -8355, 18426, 0, 0, 90, 35 }, /* region 40 */
    { { 512, 68, 68 }, -8955, 18426, 0, 0, 90, 35 }, /* region 41 */
    { { 0, 69, 69 }, -8955, 32767, 0, 0, 86, 36 }, /* region 42 */
    { { 0, 70, 70 }, -8055, 21900, 0, 0, 86, 37 }, /* region 43 */
    { { 769, 71, 71 }, -7555, 23197, 0, 1226, 35, 38 }, /* region 44 */
    { { 769, 72, 72 }, -8155, 26028, 0, 1226, 35, 38 }, /* region 45 */
    { { 1024, 73, 73 }, -9155, 32767, 0, 0, 22, 39 }, /* region 46 */
    { { 1024, 74, 74 }, -9655, 32767, 0, 0, 22, 40 }, /* region 47 */
    { { 1, 75, 75 }, -9100, 23197, 0, 31, 139, 41 }, /* region 48 */
    { { 0, 76, 76 }, -11655, 23197, 0, 0, 134, 42 }, /* region 49 */
    { { 0, 77, 77 }, -11255, 23197, 0, 0, 134, 43 }, /* region 50 */
    { { 0, 78, 78 }, -10053, 16422, 0, 0, 89, 44 }, /* region 51 */
    { { 0, 79, 79 }, -11453, 16422, 0, 0, 89, 45 }, /* region 52 */
    { { 1281, 80, 80 }, -7500, 13045, 209, 230, 103, 46 }, /* region 53 */
    { { 1281, 81, 81 }, -7600, 16422, 209, 230, 103, 47 }, /* region 54 */
    { { 0, 82, 82 }, -9655, 20675, 0, 0, 87, 48 }, /* region 55 */
    { { 0, 83, 83 }, -10100, 32767, 0, 0, 13, 49 }, /* region 56 */
    { { 1, 84, 84 }, -9600, 23197, 0, 10294, 5, 50 }, /* region 57 */
    { { 0, 85, 85 }, -10855, 32767, 0, 0, 135, 4 }, /* region 58 */
    { { 0, 86, 86 }, -10268, 16422, 0, 0, 24, 51 }, /* region 59 */
    { { 32769, 87, 87 }, -10368, 32767, 1335, 1603, 24, 52 }, /* region 60 */
    { { 1, 12, 67 }, -7805, 23197, 437, 16584, 2, 48 }, /* region 61 */
    { { 1, 68, 73 }, -8396, 23197, 452, 16803, 0, 48 }, /* region 62 */
    { { 32769, 74, 108 }, -9667, 23197, 404, 16698, 1, 48 }, /* region 63 */
    { { 1, 12, 78 }, -7805, 16422, 437, 16584, 2, 48 }, /* region 64 */
    { { 1, 79, 91 }, -8396, 16422, 452, 16803, 0, 48 }, /* region 65 */
    { { 32769, 92, 108 }, -9667, 16422, 404, 16698, 1, 48 }, /* region 66 */
    { { 1, 12, 78 }, -7805, 16422, 437, 16584, 2, 48 }, /* region 67 */
    { { 1, 79, 91 }, -8396, 16422, 452, 16803, 0, 48 }, /* region 68 */
    { { 32769, 92, 108 }, -9667, 16422, 404, 16698, 1, 48 }, /* region 69 */
    { { 1, 12, 70 }, -7800, 23197, 437, 16584, 2, 48 }, /* region 70 */
    { { 1, 71, 88 }, -8391, 23197, 452, 16803, 0, 48 }, /* region 71 */
    { { 32769, 89, 108 }, -9662, 23197, 404, 16698, 1, 48 }, /* region 72 */
    { { 1, 12, 54 }, -7156, 13045, 639, 4368, 10, 48 }, /* region 73 */
    { { 32769, 55, 108 }, -7551, 18426, 702, 3112, 12, 48 }, /* region 74 */
    { { 1, 12, 66 }, -7811, 23197, 437, 16584, 2, 48 }, /* region 75 */
    { { 1, 67, 87 }, -8402, 23197, 452, 16803, 0, 48 }, /* region 76 */
    { { 32769, 88, 108 }, -9673, 16422, 404, 16698, 1, 48 }, /* region 77 */
    { { 1, 12, 43 }, -4255, 23197, 920, 1383, 30, 59 }, /* region 78 */
    { { 32769, 44, 96 }, -6260, 18426, 885, 1176, 37, 59 }, /* region 79 */
    { { 1, 12, 48 }, -4661, 18426, 1148, 1514, 26, 60 }, /* region 80 */
    { { 32769, 49, 96 }, -7453, 16422, 1347, 1420, 29, 60 }, /* region 81 */
    { { 1, 33, 56 }, -6800, 26028, 1064, 1170, 38, 61 }, /* region 82 */
    { { 1, 57, 72 }, -7200, 26028, 930, 1014, 44, 61 }, /* region 83 */
    { { 32769, 73, 108 }, -8800, 26028, 726, 826, 52, 61 }, /* region 84 */
    { { 1, 36, 96 }, -8800, 20675, 635, 735, 58, 62 }, /* region 85 */
    { { 32769, 97, 108 }, -11308, 13045, 0, 31, 139, 62 }, /* region 86 */
    { { 1, 36, 96 }, -8800, 14636, 635, 735, 58, 0 }, /* region 87 */
    { { 32769, 97, 108 }, -11308, 13045, 0, 31, 139, 0 }, /* region 88 */
    { { 1, 36, 83 }, -7206, 13045, 838, 922, 47, 63 }, /* region 89 */
    { { 1, 84, 93 }, -9606, 14636, 209, 230, 103, 63 }, /* region 90 */
    { { 32769, 94, 108 }, -11308, 13045, 0, 31, 139, 63 }, /* region 91 */
    { { 1, 36, 83 }, -7206, 13045, 838, 922, 47, 64 }, /* region 92 */
    { { 1, 84, 93 }, -9606, 13045, 209, 230, 103, 64 }, /* region 93 */
    { { 32769, 94, 108 }, -11308, 13045, 0, 31, 139, 64 }, /* region 94 */
    { { 1, 21, 56 }, -6795, 23197, 1064, 1170, 38, 65 }, /* region 95 */
    { { 1, 57, 72 }, -7195, 23197, 930, 1014, 44, 65 }, /* region 96 */
    { { 32769, 73, 108 }, -8798, 23197, 726, 826, 52, 65 }, /* region 97 */
    { { 1, 12, 83 }, -7206, 16422, 838, 922, 47, 66 }, /* region 98 */
    { { 1, 84, 93 }, -9606, 16422, 209, 230, 103, 66 }, /* region 99 */
    { { 32769, 94, 108 }, -11308, 16422, 0, 31, 139, 66 }, /* region 100 */
    { { 1, 24, 83 }, -7206, 16422, 838, 922, 47, 67 }, /* region 101 */
    { { 1, 84, 93 }, -9606, 16422, 209, 230, 103, 67 }, /* region 102 */
    { { 32769, 94, 108 }, -11308, 16422, 0, 31, 139, 67 }, /* region 103 */
    { { 1, 12, 83 }, -7220, 16422, 0, 83, 126, 68 }, /* region 104 */
    { { 1, 84, 90 }, -9682, 16422, 0, 20, 145, 68 }, /* region 105 */
    { { 32769, 91, 108 }, -10301, 16422, 6, 20, 147, 68 }, /* region 106 */
    { { 1, 21, 75 }, -8441, 16422, 419, 460, 76, 69 }, /* region 107 */
    { { 32769, 76, 108 }, -10890, 14636, 254, 264, 101, 69 }, /* region 108 */
    { { 32769, 36, 84 }, -8955, 16422, 0, 2775, 17, 70 }, /* region 109 */
    { { 32769, 12, 108 }, -7855, 23197, 30, 276, 100, 71 }, /* region 110 */
    { { 0, 12, 60 }, -9114, 26028, 0, 0, 15, 72 }, /* region 111 */
    { { 32768, 61, 96 }, -9114, 26028, 0, 0, 15, 73 }, /* region 112 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 74 }, /* region 113 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 74 }, /* region 114 */
    { { 1, 12, 35 }, -6555, 16422, 2869, 3778, 11, 75 }, /* region 115 */
    { { 1, 36, 48 }, -7755, 20675, 2869, 3778, 11, 75 }, /* region 116 */
    { { 32769, 49, 72 }, -7755, 20675, 2869, 3778, 11, 76 }, /* region 117 */
    { { 1, 16, 55 }, -7424, 20675, 1045, 1119, 41, 77 }, /* region 118 */
    { { 32769, 56, 96 }, -7918, 20675, 907, 963, 46, 77 }, /* region 119 */
    { { 1, 16, 53 }, -7194, 29204, 1140, 1479, 27, 78 }, /* region 120 */
    { { 1, 54, 70 }, -8371, 29204, 726, 812, 55, 78 }, /* region 121 */
    { { 32769, 71, 108 }, -8988, 29204, 718, 748, 56, 78 }, /* region 122 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 79 }, /* region 123 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 79 }, /* region 124 */
    { { 1, 16, 54 }, -6927, 20675, 5362, 5461, 9, 80 }, /* region 125 */
    { { 1, 55, 63 }, -7051, 26028, 1362, 1454, 28, 80 }, /* region 126 */
    { { 32769, 64, 108 }, -7944, 16422, 311, 366, 88, 80 }, /* region 127 */
    { { 1, 16, 48 }, -5998, 20675, 1132, 1301, 31, 81 }, /* region 128 */
    { { 32769, 49, 108 }, -7188, 20675, 1099, 1184, 36, 81 }, /* region 129 */
    { { 1, 21, 68 }, -9658, 20675, 87, 2170, 18, 82 }, /* region 130 */
    { { 1, 69, 82 }, -10160, 20675, 120, 2167, 19, 82 }, /* region 131 */
    { { 32769, 83, 108 }, -11360, 20675, 376, 2041, 20, 82 }, /* region 132 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 83 }, /* region 133 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 83 }, /* region 134 */
    { { 32769, 55, 108 }, -8568, 20675, 0, 477, 75, 84 }, /* region 135 */
    { { 32769, 36, 96 }, -8100, 14636, 101, 151, 116, 85 }, /* region 136 */
    { { 1, 24, 83 }, -7220, 13045, 0, 83, 126, 86 }, /* region 137 */
    { { 1, 84, 90 }, -9682, 13045, 0, 20, 145, 86 }, /* region 138 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 147, 86 }, /* region 139 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 87 }, /* region 140 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 87 }, /* region 141 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 88 }, /* region 142 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 88 }, /* region 143 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 89 }, /* region 144 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 89 }, /* region 145 */
    { { 1, 24, 83 }, -7220, 13045, 0, 83, 126, 90 }, /* region 146 */
    { { 1, 84, 90 }, -9682, 13045, 0, 20, 145, 90 }, /* region 147 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 147, 90 }, /* region 148 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 91 }, /* region 149 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 91 }, /* region 150 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 92 }, /* region 151 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 92 }, /* region 152 */
    { { 1, 12, 62 }, -8253, 16422, 23, 10953, 4, 93 }, /* region 153 */
    { { 32769, 63, 108 }, -8955, 20675, 11, 11753, 3, 93 }, /* region 154 */
    { { 1, 12, 62 }, -8253, 16422, 23, 10953, 4, 94 }, /* region 155 */
    { { 32769, 63, 108 }, -8955, 16422, 11, 11753, 3, 94 }, /* region 156 */
    { { 1, 24, 79 }, -7220, 13045, 0, 83, 126, 95 }, /* region 157 */
    { { 1, 80, 90 }, -9682, 13045, 0, 20, 145, 95 }, /* region 158 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 147, 95 }, /* region 159 */
    { { 1, 12, 65 }, -8253, 13045, 23, 10953, 4, 96 }, /* region 160 */
    { { 32769, 66, 108 }, -8955, 16422, 11, 11753, 3, 96 }, /* region 161 */
    { { 32768, 36, 84 }, -8700, 20675, 0, 0, 25, 97 }, /* region 162 */
    { { 32769, 36, 96 }, -10055, 20675, 1482, 1613, 23, 98 }, /* region 163 */
    { { 32769, 12, 96 }, -5566, 32767, 818, 1033, 42, 99 }, /* region 164 */
    { { 32769, 36, 84 }, -9768, 18426, 0, 293, 98, 100 }, /* region 165 */
    { { 32769, 12, 96 }, -7220, 26028, 0, 83, 125, 101 }, /* region 166 */
    { { 32769, 12, 96 }, -7220, 20675, 0, 83, 125, 102 }, /* region 167 */
    { { 1, 12, 83 }, -7220, 13045, 0, 83, 125, 104 }, /* region 168 */
    { { 1, 84, 90 }, -9682, 13045, 0, 20, 146, 104 }, /* region 169 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 148, 104 }, /* region 170 */
    { { 32769, 36, 108 }, -9770, 32767, 472, 491, 74, 105 }, /* region 171 */
    { { 32769, 36, 108 }, -9770, 20675, 472, 491, 74, 106 }, /* region 172 */
    { { 1, 12, 72 }, -7212, 7336, 2, 86, 124, 107 }, /* region 173 */
    { { 1, 73, 101 }, -9700, 8231, 2, 22, 143, 107 }, /* region 174 */
    { { 32769, 102, 108 }, -10883, 20675, 173, 183, 110, 107 }, /* region 175 */
    { { 1, 21, 96 }, -8968, 13045, 477, 507, 73, 108 }, /* region 176 */
    { { 32769, 97, 108 }, -10883, 13045, 173, 183, 110, 109 }, /* region 177 */
    { { 32769, 12, 108 }, -8971, 16422, 477, 507, 73, 110 }, /* region 178 */
    { { 1, 12, 53 }, -6171, 16422, 388, 541, 68, 111 }, /* region 179 */
    { { 32769, 54, 60 }, -7149, 11626, 473, 560, 65, 111 }, /* region 180 */
    { { 32769, 36, 72 }, -7149, 16422, 473, 560, 65, 112 }, /* region 181 */
    { { 1, 48, 58 }, -8253, 16422, 356, 402, 82, 113 }, /* region 182 */
    { { 1, 59, 65 }, -8774, 16422, 514, 548, 67, 113 }, /* region 183 */
    { { 1, 66, 78 }, -9374, 16422, 505, 529, 71, 113 }, /* region 184 */
    { { 32769, 79, 96 }, -10433, 16422, 178, 191, 109, 113 }, /* region 185 */
    { { 1, 55, 60 }, -8253, 16422, 356, 402, 82, 114 }, /* region 186 */
    { { 1, 61, 69 }, -8774, 16422, 514, 548, 67, 114 }, /* region 187 */
    { { 1, 70, 79 }, -9374, 16422, 505, 529, 71, 114 }, /* region 188 */
    { { 32769, 80, 108 }, -10433, 16422, 178, 191, 109, 114 }, /* region 189 */
    { { 1, 16, 82 }, -9229, 23197, 180, 206, 106, 115 }, /* region 190 */
    { { 32769, 83, 108 }, -8440, 18426, 3, 44, 131, 115 }, /* region 191 */
    { { 32769, 21, 108 }, -10069, 20675, 483, 515, 72, 116 }, /* region 192 */
    { { 1, 21, 89 }, -8405, 18426, 3, 45, 130, 117 }, /* region 193 */
    { { 32769, 90, 108 }, -10301, 10362, 6, 20, 148, 117 }, /* region 194 */
    { { 1, 21, 42 }, -5886, 20675, 0, 180, 111, 118 }, /* region 195 */
    { { 1, 43, 51 }, -6486, 23197, 0, 127, 120, 118 }, /* region 196 */
    { { 1, 52, 58 }, -7492, 26028, 0, 71, 127, 118 }, /* region 197 */
    { { 1, 59, 68 }, -8668, 23197, 0, 36, 136, 118 }, /* region 198 */
    { { 32769, 69, 108 }, -9774, 20675, 0, 19, 149, 118 }, /* region 199 */
    { { 1, 21, 89 }, -8399, 20675, 3, 45, 130, 119 }, /* region 200 */
    { { 32769, 90, 108 }, -10301, 14636, 6, 20, 148, 119 }, /* region 201 */
    { { 1, 21, 46 }, -6851, 26028, 236, 340, 92, 120 }, /* region 202 */
    { { 1, 47, 71 }, -7763, 20675, 824, 885, 49, 120 }, /* region 203 */
    { { 1, 72, 88 }, -9107, 18426, 719, 747, 57, 120 }, /* region 204 */
    { { 1, 89, 93 }, -10076, 16422, 83, 99, 122, 120 }, /* region 205 */
    { { 32769, 94, 108 }, -10889, 16422, 173, 183, 110, 120 }, /* region 206 */
    { { 1, 60, 71 }, -8405, 16422, 0, 42, 132, 121 }, /* region 207 */
    { { 1, 72, 78 }, -9103, 16422, 0, 28, 141, 121 }, /* region 208 */
    { { 32769, 79, 96 }, -9605, 16422, 0, 21, 144, 121 }, /* region 209 */
    { { 1, 48, 65 }, -7516, 11626, 0, 70, 128, 122 }, /* region 210 */
    { { 1, 66, 79 }, -8924, 14636, 0, 31, 138, 122 }, /* region 211 */
    { { 32769, 80, 96 }, -9230, 11626, 0, 26, 142, 122 }, /* region 212 */
    { { 1, 16, 44 }, -7068, 14636, 163, 254, 102, 123 }, /* region 213 */
    { { 1, 45, 51 }, -7618, 16422, 261, 393, 85, 123 }, /* region 214 */
    { { 1, 52, 58 }, -8533, 18426, 190, 229, 104, 123 }, /* region 215 */
    { { 1, 59, 66 }, -9300, 18426, 168, 193, 108, 123 }, /* region 216 */
    { { 1, 67, 70 }, -9776, 18426, 138, 157, 115, 123 }, /* region 217 */
    { { 1, 71, 80 }, -10303, 18426, 166, 180, 112, 123 }, /* region 218 */
    { { 32769, 81, 108 }, -11274, 18426, 135, 151, 117, 123 }, /* region 219 */
    { { 32769, 12, 96 }, -6204, 23197, 570, 719, 59, 124 }, /* region 220 */
    { { 1, 12, 48 }, -7068, 14636, 163, 254, 102, 125 }, /* region 221 */
    { { 1, 49, 54 }, -7618, 16422, 261, 393, 85, 125 }, /* region 222 */
    { { 1, 55, 63 }, -8533, 18426, 190, 229, 104, 125 }, /* region 223 */
    { { 1, 64, 70 }, -9300, 18426, 168, 193, 108, 125 }, /* region 224 */
    { { 1, 71, 75 }, -9776, 18426, 138, 157, 115, 125 }, /* region 225 */
    { { 1, 76, 82 }, -10303, 18426, 166, 180, 112, 125 }, /* region 226 */
    { { 32769, 83, 108 }, -11274, 18426, 135, 151, 117, 125 }, /* region 227 */
    { { 32770, 36, 84 }, -8400, 29204, 0, 0, 0, 126 }, /* region 228 */
    { { 32770, 36, 84 }, -8800, 8231, 0, 0, 0, 127 }, /* region 229 */
    { { 32770, 36, 84 }, -8400, 20675, 0, 0, 0, 128 }, /* region 230 */
    { { 32769, 36, 84 }, -7200, -24285, 1294, 5778, 8, 129 }, /* region 231 */
    { { 32769, 36, 84 }, -7755, 29204, 798, 993, 45, 130 }, /* region 232 */
    { { 32769, 36, 84 }, -8055, 20675, 798, 993, 45, 131 }, /* region 233 */
    { { 32769, 36, 84 }, -8955, 29204, 798, 993, 45, 132 }, /* region 234 */
    { { 32768, 36, 84 }, -9355, 32767, 0, 0, 133, 133 }, /* region 235 */
    { { 32768, 36, 84 }, -7755, 20675, 0, 0, 91, 134 }, /* region 236 */
    { { 1, 24, 62 }, -8200, 23197, 286, 333, 94, 135 }, /* region 237 */
    { { 1, 63, 66 }, -8564, 26028, 297, 335, 93, 135 }, /* region 238 */
    { { 1, 67, 72 }, -8922, 23197, 368, 399, 84, 135 }, /* region 239 */
    { { 32769, 73, 96 }, -9510, 23197, 116, 138, 119, 135 }, /* region 240 */
    { { 1, 24, 48 }, -6341, 23197, 309, 447, 77, 136 }, /* region 241 */
    { { 1, 49, 56 }, -7466, 26028, 211, 283, 99, 136 }, /* region 242 */
    { { 1, 57, 63 }, -8200, 26028, 286, 333, 94, 136 }, /* region 243 */
    { { 32769, 64, 84 }, -8922, 23197, 368, 399, 84, 136 }, /* region 244 */
    { { 1, 24, 56 }, -7466, 29204, 211, 283, 99, 137 }, /* region 245 */
    { { 1, 57, 63 }, -8200, 29204, 286, 333, 94, 137 }, /* region 246 */
    { { 1, 64, 69 }, -8922, 29204, 368, 399, 84, 137 }, /* region 247 */
    { { 32769, 70, 96 }, -9510, 29204, 116, 138, 119, 137 }, /* region 248 */
    { { 1, 24, 68 }, -8922, 18426, 368, 399, 84, 138 }, /* region 249 */
    { { 1, 69, 76 }, -9510, 26028, 116, 138, 119, 138 }, /* region 250 */
    { { 32769, 77, 108 }, -9958, 23197, 127, 144, 118, 138 }, /* region 251 */
    { { 1, 24, 82 }, -8813, 23197, 389, 422, 80, 139 }, /* region 252 */
    { { 32769, 83, 108 }, -9964, 26028, 146, 163, 114, 139 }, /* region 253 */
    { { 1, 12, 58 }, -8098, 29204, 386, 436, 78, 140 }, /* region 254 */
    { { 32769, 59, 96 }, -8571, 26028, 290, 328, 95, 140 }, /* region 255 */
    { { 1, 12, 58 }, -8098, 16422, 386, 436, 78, 141 }, /* region 256 */
    { { 32769, 59, 96 }, -8571, 18426, 290, 328, 95, 141 }, /* region 257 */
    { { 1, 12, 48 }, -8098, -28771, 386, 436, 78, 142 }, /* region 258 */
    { { 32769, 49, 84 }, -8571, 29204, 290, 328, 95, 142 }, /* region 259 */
    { { 1, 12, 60 }, -6653, 20675, 314, 430, 79, 143 }, /* region 260 */
    { { 32769, 61, 84 }, -7753, 18426, 263, 324, 96, 143 }, /* region 261 */
    { { 1, 24, 60 }, -7753, 16422, 263, 324, 96, 144 }, /* region 262 */
    { { 1, 61, 70 }, -8869, 20675, 279, 311, 97, 144 }, /* region 263 */
    { { 32769, 71, 96 }, -9298, 23197, 179, 204, 107, 144 }, /* region 264 */
    { { 1, 24, 84 }, -9683, 20675, 191, 211, 105, 145 }, /* region 265 */
    { { 32769, 85, 108 }, -10883, 20675, 92, 102, 121, 145 }, /* region 266 */
    { { 1, 21, 69 }, -7753, 13045, 263, 324, 96, 146 }, /* region 267 */
    { { 1, 70, 94 }, -8869, 20675, 279, 311, 97, 146 }, /* region 268 */
    { { 1, 95, 96 }, -9298, -24285, 179, 204, 107, 146 }, /* region 269 */
    { { 32769, 97, 108 }, -10883, -24285, 173, 183, 110, 146 }, /* region 270 */
    { { 1, 16, 55 }, -9300, 20675, 168, 193, 108, 147 }, /* region 271 */
    { { 1, 56, 74 }, -9776, 26028, 138, 157, 115, 147 }, /* region 272 */
    { { 32769, 75, 96 }, -11274, 26028, 135, 151, 117, 147 }, /* region 273 */
    { { 1, 24, 72 }, -9298, 26028, 179, 204, 107, 148 }, /* region 274 */
    { { 1, 73, 85 }, -9683, 20675, 191, 211, 105, 148 }, /* region 275 */
    { { 32769, 86, 108 }, -10883, 18426, 92, 102, 121, 148 }, /* region 276 */
    { { 32769, 36, 108 }, -8930, 18426, 1839, 1901, 21, 149 }, /* region 277 */
    { { 32769, 24, 108 }, -8473, 20675, 494, 534, 69, 150 }, /* region 278 */
    { { 32769, 12, 108 }, -8473, 20675, 494, 534, 69, 151 }, /* region 279 */
    { { 32769, 24, 108 }, -8473, 20675, 494, 534, 69, 152 }, /* region 280 */
    { { 1, 36, 60 }, -6100, 5193, 2, 22, 143, 153 }, /* region 281 */
    { { 32769, 61, 84 }, -7283, 20675, 173, 183, 110, 153 }, /* region 282 */
    { { 32769, 24, 96 }, -7753, 14636, 263, 324, 96, 154 }, /* region 283 */
    { { 32769, 36, 96 }, -8930, 26028, 1839, 1901, 21, 155 }, /* region 284 */
    { { 32769, 24, 108 }, -8473, 20675, 494, 534, 69, 156 }, /* region 285 */
    { { 1, 24, 58 }, -9051, 14636, 0, 29, 140, 157 }, /* region 286 */
    { { 32769, 59, 96 }, -9051, 14636, 0, 29, 140, 157 }, /* region 287 */
    { { 1, 12, 83 }, -7220, 13045, 0, 83, 125, 158 }, /* region 288 */
    { { 1, 84, 90 }, -9682, 13045, 0, 20, 146, 158 }, /* region 289 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 148, 158 }, /* region 290 */
    { { 1, 21, 42 }, -5863, 26028, 1047, 1229, 34, 159 }, /* region 291 */
    { { 1, 43, 48 }, -6656, 29204, 1138, 1253, 33, 159 }, /* region 292 */
    { { 1, 49, 53 }, -7045, 26028, 559, 651, 60, 159 }, /* region 293 */
    { { 1, 54, 60 }, -7932, 26028, 508, 563, 64, 159 }, /* region 294 */
    { { 1, 61, 65 }, -8280, 32767, 819, 864, 51, 159 }, /* region 295 */
    { { 1, 66, 70 }, -8066, 26942, 981, 1032, 43, 159 }, /* region 296 */
    { { 1, 71, 76 }, -9366, 26028, 790, 814, 54, 159 }, /* region 297 */
    { { 1, 77, 82 }, -9966, 26028, 592, 609, 61, 159 }, /* region 298 */
    { { 1, 83, 87 }, -10717, 23197, 543, 554, 66, 159 }, /* region 299 */
    { { 1, 88, 96 }, -11271, 18426, 601, 609, 62, 159 }, /* region 300 */
    { { 32769, 97, 108 }, -11766, 18426, 523, 529, 70, 159 }, /* region 301 */
    { { 1, 48, 69 }, -7513, 14636, 0, 70, 128, 160 }, /* region 302 */
    { { 1, 70, 79 }, -8924, 18426, 0, 31, 138, 160 }, /* region 303 */
    { { 32769, 80, 96 }, -9230, 14636, 0, 26, 142, 160 }, /* region 304 */
    { { 1, 36, 72 }, -8334, 29204, 0, 87, 123, 161 }, /* region 305 */
    { { 32769, 73, 96 }, -9160, 29204, 0, 54, 129, 161 }, /* region 306 */
    { { 32769, 36, 96 }, -8930, 26028, 1839, 1901, 21, 162 }, /* region 307 */
    { { 32769, 12, 96 }, -5572, 32767, 818, 1033, 42, 163 }, /* region 308 */
    { { 32769, 36, 108 }, -9770, 26028, 472, 491, 74, 164 }, /* region 309 */
    { { 32769, 12, 96 }, -6204, 29204, 570, 719, 59, 165 }, /* region 310 */
    { { 1, 12, 83 }, -7220, 13045, 0, 83, 125, 166 }, /* region 311 */
    { { 1, 84, 90 }, -9682, 13045, 0, 20, 146, 166 }, /* region 312 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 148, 166 }, /* region 313 */
    { { 1, 21, 46 }, -6851, 32767, 236, 340, 92, 167 }, /* region 314 */
    { { 1, 47, 75 }, -7763, 26028, 824, 885, 49, 167 }, /* region 315 */
    { { 1, 76, 84 }, -9107, 23197, 719, 747, 57, 167 }, /* region 316 */
    { { 1, 85, 93 }, -10076, 20675, 83, 99, 122, 167 }, /* region 317 */
    { { 32769, 94, 108 }, -10889, 20675, 173, 183, 110, 167 }, /* region 318 */
    { { 1, 21, 46 }, -6851, 26028, 236, 340, 92, 168 }, /* region 319 */
    { { 1, 47, 71 }, -7763, 20675, 824, 885, 49, 168 }, /* region 320 */
    { { 1, 72, 88 }, -9107, 18426, 719, 747, 57, 168 }, /* region 321 */
    { { 1, 89, 93 }, -10076, 16422, 83, 99, 122, 168 }, /* region 322 */
    { { 32769, 94, 108 }, -10889, 16422, 173, 183, 110, 168 }, /* region 323 */
    { { 1, 21, 45 }, -5863, 26028, 1047, 1229, 34, 169 }, /* region 324 */
    { { 1, 46, 51 }, -6656, 29204, 1138, 1253, 33, 169 }, /* region 325 */
    { { 1, 52, 54 }, -7045, 26028, 559, 651, 60, 169 }, /* region 326 */
    { { 1, 55, 63 }, -7932, 26028, 508, 563, 64, 169 }, /* region 327 */
    { { 1, 64, 68 }, -8280, 32767, 819, 864, 51, 169 }, /* region 328 */
    { { 1, 69, 73 }, -8066, 26942, 981, 1032, 43, 169 }, /* region 329 */
    { { 1, 74, 79 }, -9366, 26028, 790, 814, 54, 169 }, /* region 330 */
    { { 1, 80, 88 }, -9966, 23197, 592, 609, 61, 169 }, /* region 331 */
    { { 1, 89, 99 }, -11271, 18426, 601, 609, 62, 169 }, /* region 332 */
    { { 32769, 100, 108 }, -11766, 18426, 523, 529, 70, 169 }, /* region 333 */
    { { 1, 21, 45 }, -5863, 26028, 1047, 1229, 34, 170 }, /* region 334 */
    { { 1, 46, 51 }, -6656, 29204, 1138, 1253, 33, 170 }, /* region 335 */
    { { 1, 52, 54 }, -7045, 26028, 559, 651, 60, 170 }, /* region 336 */
    { { 1, 55, 63 }, -7932, 26028, 508, 563, 64, 170 }, /* region 337 */
    { { 1, 64, 68 }, -8280, 32767, 819, 864, 51, 170 }, /* region 338 */
    { { 1, 69, 73 }, -8066, 26942, 981, 1032, 43, 170 }, /* region 339 */
    { { 1, 74, 79 }, -9366, 26028, 790, 814, 54, 170 }, /* region 340 */
    { { 1, 80, 88 }, -9966, 23197, 592, 609, 61, 170 }, /* region 341 */
    { { 1, 89, 99 }, -11271, 18426, 601, 609, 62, 171 }, /* region 342 */
    { { 32769, 100, 108 }, -11766, 18426, 523, 529, 70, 172 }, /* region 343 */
    { { 32769, 36, 108 }, -9770, 20675, 472, 491, 74, 173 }, /* region 344 */
    { { 32769, 12, 108 }, -8930, 20675, 1839, 1901, 21, 174 }, /* region 345 */
    { { 1, 12, 44 }, -7068, 18426, 163, 254, 102, 175 }, /* region 346 */
    { { 1, 45, 51 }, -7618, 20675, 261, 393, 85, 175 }, /* region 347 */
    { { 1, 52, 58 }, -8533, 23197, 190, 229, 104, 175 }, /* region 348 */
    { { 1, 59, 66 }, -9300, 23197, 168, 193, 108, 175 }, /* region 349 */
    { { 1, 67, 70 }, -9776, 23197, 138, 157, 115, 175 }, /* region 350 */
    { { 1, 71, 80 }, -10303, 23197, 166, 180, 112, 175 }, /* region 351 */
    { { 32769, 81, 108 }, -11274, 23197, 135, 151, 117, 175 }, /* region 352 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 176 }, /* region 353 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 176 }, /* region 354 */
    { { 1, 12, 48 }, -5998, 29204, 1132, 1301, 31, 177 }, /* region 355 */
    { { 32769, 49, 108 }, -7188, 29204, 1099, 1184, 36, 177 }, /* region 356 */
    { { 1, 12, 83 }, -8441, 20675, 419, 460, 76, 178 }, /* region 357 */
    { { 32769, 84, 108 }, -11323, 20675, 0, 31, 139, 178 }, /* region 358 */
    { { 1, 55, 60 }, -8253, 18426, 356, 402, 82, 179 }, /* region 359 */
    { { 1, 61, 69 }, -8774, 18426, 514, 548, 67, 179 }, /* region 360 */
    { { 1, 70, 79 }, -9374, 18426, 505, 529, 71, 179 }, /* region 361 */
    { { 32769, 80, 108 }, -10433, 23197, 178, 191, 109, 179 }, /* region 362 */
    { { 32769, 36, 96 }, -8930, -24285, 1839, 1901, 21, 180 }, /* region 363 */
    { { 1, 12, 83 }, -7206, 16422, 838, 922, 47, 181 }, /* region 364 */
    { { 1, 84, 93 }, -9606, 18426, 209, 230, 103, 181 }, /* region 365 */
    { { 32769, 94, 108 }, -11308, 16422, 0, 31, 139, 181 }, /* region 366 */
    { { 1, 12, 56 }, -6795, 23197, 1064, 1170, 38, 182 }, /* region 367 */
    { { 1, 57, 72 }, -7195, 23197, 930, 1014, 44, 182 }, /* region 368 */
    { { 32769, 73, 108 }, -8798, 23197, 726, 826, 52, 182 }, /* region 369 */
    { { 32769, 24, 108 }, -8800, 23197, 635, 735, 58, 62 }, /* region 370 */
    { { 1, 36, 83 }, -7206, 13045, 838, 922, 47, 183 }, /* region 371 */
    { { 1, 84, 93 }, -9606, 13045, 209, 230, 103, 183 }, /* region 372 */
    { { 32769, 94, 108 }, -11308, 13045, 0, 31, 139, 183 }, /* region 373 */
    { { 1, 12, 66 }, -7811, 23197, 437, 16584, 2, 184 }, /* region 374 */
    { { 1, 67, 87 }, -8402, 23197, 452, 16803, 0, 184 }, /* region 375 */
    { { 32769, 88, 108 }, -9673, 16422, 404, 16698, 1, 184 } /* region 376 */
}; /* end Regions */

/* end wt_200k_G_MAC.c */
