// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/tasks/v2/cloudtasks.proto

package tasks

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for [ListQueues][google.cloud.tasks.v2.CloudTasks.ListQueues].
type ListQueuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location name.
	// For example: `projects/PROJECT_ID/locations/LOCATION_ID`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// `filter` can be used to specify a subset of queues. Any [Queue][google.cloud.tasks.v2.Queue]
	// field can be used as a filter and several operators as supported.
	// For example: `<=, <, >=, >, !=, =, :`. The filter syntax is the same as
	// described in
	// [Stackdriver's Advanced Logs
	// Filters](https://cloud.google.com/logging/docs/view/advanced_filters).
	//
	// Sample filter "state: PAUSED".
	//
	// Note that using filters might cause fewer queues than the
	// requested page_size to be returned.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	//
	// The maximum page size is 9800. If unspecified, the page size will
	// be the maximum. Fewer queues than requested might be returned,
	// even if more queues exist; use the
	// [next_page_token][google.cloud.tasks.v2.ListQueuesResponse.next_page_token] in the
	// response to determine if more queues exist.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return.
	//
	// To request the first page results, page_token must be empty. To
	// request the next page of results, page_token must be the value of
	// [next_page_token][google.cloud.tasks.v2.ListQueuesResponse.next_page_token] returned
	// from the previous call to [ListQueues][google.cloud.tasks.v2.CloudTasks.ListQueues]
	// method. It is an error to switch the value of the
	// [filter][google.cloud.tasks.v2.ListQueuesRequest.filter] while iterating through pages.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListQueuesRequest) Reset() {
	*x = ListQueuesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListQueuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQueuesRequest) ProtoMessage() {}

func (x *ListQueuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQueuesRequest.ProtoReflect.Descriptor instead.
func (*ListQueuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{0}
}

func (x *ListQueuesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListQueuesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListQueuesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListQueuesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for [ListQueues][google.cloud.tasks.v2.CloudTasks.ListQueues].
type ListQueuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of queues.
	Queues []*Queue `protobuf:"bytes,1,rep,name=queues,proto3" json:"queues,omitempty"`
	// A token to retrieve next page of results.
	//
	// To return the next page of results, call
	// [ListQueues][google.cloud.tasks.v2.CloudTasks.ListQueues] with this value as the
	// [page_token][google.cloud.tasks.v2.ListQueuesRequest.page_token].
	//
	// If the next_page_token is empty, there are no more results.
	//
	// The page token is valid for only 2 hours.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListQueuesResponse) Reset() {
	*x = ListQueuesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListQueuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListQueuesResponse) ProtoMessage() {}

func (x *ListQueuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListQueuesResponse.ProtoReflect.Descriptor instead.
func (*ListQueuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{1}
}

func (x *ListQueuesResponse) GetQueues() []*Queue {
	if x != nil {
		return x.Queues
	}
	return nil
}

func (x *ListQueuesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for [GetQueue][google.cloud.tasks.v2.CloudTasks.GetQueue].
type GetQueueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the queue. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetQueueRequest) Reset() {
	*x = GetQueueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetQueueRequest) ProtoMessage() {}

func (x *GetQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetQueueRequest.ProtoReflect.Descriptor instead.
func (*GetQueueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{2}
}

func (x *GetQueueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [CreateQueue][google.cloud.tasks.v2.CloudTasks.CreateQueue].
type CreateQueueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location name in which the queue will be created.
	// For example: `projects/PROJECT_ID/locations/LOCATION_ID`
	//
	// The list of allowed locations can be obtained by calling Cloud
	// Tasks' implementation of
	// [ListLocations][google.cloud.location.Locations.ListLocations].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The queue to create.
	//
	// [Queue's name][google.cloud.tasks.v2.Queue.name] cannot be the same as an existing queue.
	Queue *Queue `protobuf:"bytes,2,opt,name=queue,proto3" json:"queue,omitempty"`
}

func (x *CreateQueueRequest) Reset() {
	*x = CreateQueueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateQueueRequest) ProtoMessage() {}

func (x *CreateQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateQueueRequest.ProtoReflect.Descriptor instead.
func (*CreateQueueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{3}
}

func (x *CreateQueueRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateQueueRequest) GetQueue() *Queue {
	if x != nil {
		return x.Queue
	}
	return nil
}

// Request message for [UpdateQueue][google.cloud.tasks.v2.CloudTasks.UpdateQueue].
type UpdateQueueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The queue to create or update.
	//
	// The queue's [name][google.cloud.tasks.v2.Queue.name] must be specified.
	//
	// Output only fields cannot be modified using UpdateQueue.
	// Any value specified for an output only field will be ignored.
	// The queue's [name][google.cloud.tasks.v2.Queue.name] cannot be changed.
	Queue *Queue `protobuf:"bytes,1,opt,name=queue,proto3" json:"queue,omitempty"`
	// A mask used to specify which fields of the queue are being updated.
	//
	// If empty, then all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateQueueRequest) Reset() {
	*x = UpdateQueueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateQueueRequest) ProtoMessage() {}

func (x *UpdateQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateQueueRequest.ProtoReflect.Descriptor instead.
func (*UpdateQueueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateQueueRequest) GetQueue() *Queue {
	if x != nil {
		return x.Queue
	}
	return nil
}

func (x *UpdateQueueRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for [DeleteQueue][google.cloud.tasks.v2.CloudTasks.DeleteQueue].
type DeleteQueueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The queue name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteQueueRequest) Reset() {
	*x = DeleteQueueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteQueueRequest) ProtoMessage() {}

func (x *DeleteQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteQueueRequest.ProtoReflect.Descriptor instead.
func (*DeleteQueueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteQueueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue].
type PurgeQueueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The queue name. For example:
	// `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *PurgeQueueRequest) Reset() {
	*x = PurgeQueueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PurgeQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeQueueRequest) ProtoMessage() {}

func (x *PurgeQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeQueueRequest.ProtoReflect.Descriptor instead.
func (*PurgeQueueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{6}
}

func (x *PurgeQueueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [PauseQueue][google.cloud.tasks.v2.CloudTasks.PauseQueue].
type PauseQueueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The queue name. For example:
	// `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *PauseQueueRequest) Reset() {
	*x = PauseQueueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PauseQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseQueueRequest) ProtoMessage() {}

func (x *PauseQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseQueueRequest.ProtoReflect.Descriptor instead.
func (*PauseQueueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{7}
}

func (x *PauseQueueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue].
type ResumeQueueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The queue name. For example:
	// `projects/PROJECT_ID/location/LOCATION_ID/queues/QUEUE_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ResumeQueueRequest) Reset() {
	*x = ResumeQueueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResumeQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeQueueRequest) ProtoMessage() {}

func (x *ResumeQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeQueueRequest.ProtoReflect.Descriptor instead.
func (*ResumeQueueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{8}
}

func (x *ResumeQueueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for listing tasks using [ListTasks][google.cloud.tasks.v2.CloudTasks.ListTasks].
type ListTasksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The queue name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The response_view specifies which subset of the [Task][google.cloud.tasks.v2.Task] will be
	// returned.
	//
	// By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC]; not all
	// information is retrieved by default because some data, such as
	// payloads, might be desirable to return only when needed because
	// of its large size or because of the sensitivity of data that it
	// contains.
	//
	// Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
	// `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
	// permission on the [Task][google.cloud.tasks.v2.Task] resource.
	ResponseView Task_View `protobuf:"varint,2,opt,name=response_view,json=responseView,proto3,enum=google.cloud.tasks.v2.Task_View" json:"response_view,omitempty"`
	// Maximum page size.
	//
	// Fewer tasks than requested might be returned, even if more tasks exist; use
	// [next_page_token][google.cloud.tasks.v2.ListTasksResponse.next_page_token] in the response to
	// determine if more tasks exist.
	//
	// The maximum page size is 1000. If unspecified, the page size will be the
	// maximum.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying the page of results to return.
	//
	// To request the first page results, page_token must be empty. To
	// request the next page of results, page_token must be the value of
	// [next_page_token][google.cloud.tasks.v2.ListTasksResponse.next_page_token] returned
	// from the previous call to [ListTasks][google.cloud.tasks.v2.CloudTasks.ListTasks]
	// method.
	//
	// The page token is valid for only 2 hours.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTasksRequest) Reset() {
	*x = ListTasksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTasksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTasksRequest) ProtoMessage() {}

func (x *ListTasksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTasksRequest.ProtoReflect.Descriptor instead.
func (*ListTasksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{9}
}

func (x *ListTasksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTasksRequest) GetResponseView() Task_View {
	if x != nil {
		return x.ResponseView
	}
	return Task_VIEW_UNSPECIFIED
}

func (x *ListTasksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTasksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for listing tasks using [ListTasks][google.cloud.tasks.v2.CloudTasks.ListTasks].
type ListTasksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of tasks.
	Tasks []*Task `protobuf:"bytes,1,rep,name=tasks,proto3" json:"tasks,omitempty"`
	// A token to retrieve next page of results.
	//
	// To return the next page of results, call
	// [ListTasks][google.cloud.tasks.v2.CloudTasks.ListTasks] with this value as the
	// [page_token][google.cloud.tasks.v2.ListTasksRequest.page_token].
	//
	// If the next_page_token is empty, there are no more results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTasksResponse) Reset() {
	*x = ListTasksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTasksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTasksResponse) ProtoMessage() {}

func (x *ListTasksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTasksResponse.ProtoReflect.Descriptor instead.
func (*ListTasksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{10}
}

func (x *ListTasksResponse) GetTasks() []*Task {
	if x != nil {
		return x.Tasks
	}
	return nil
}

func (x *ListTasksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for getting a task using [GetTask][google.cloud.tasks.v2.CloudTasks.GetTask].
type GetTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The task name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The response_view specifies which subset of the [Task][google.cloud.tasks.v2.Task] will be
	// returned.
	//
	// By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC]; not all
	// information is retrieved by default because some data, such as
	// payloads, might be desirable to return only when needed because
	// of its large size or because of the sensitivity of data that it
	// contains.
	//
	// Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
	// `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
	// permission on the [Task][google.cloud.tasks.v2.Task] resource.
	ResponseView Task_View `protobuf:"varint,2,opt,name=response_view,json=responseView,proto3,enum=google.cloud.tasks.v2.Task_View" json:"response_view,omitempty"`
}

func (x *GetTaskRequest) Reset() {
	*x = GetTaskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTaskRequest) ProtoMessage() {}

func (x *GetTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTaskRequest.ProtoReflect.Descriptor instead.
func (*GetTaskRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{11}
}

func (x *GetTaskRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetTaskRequest) GetResponseView() Task_View {
	if x != nil {
		return x.ResponseView
	}
	return Task_VIEW_UNSPECIFIED
}

// Request message for [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask].
type CreateTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The queue name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
	//
	// The queue must already exist.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The task to add.
	//
	// Task names have the following format:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
	// The user can optionally specify a task [name][google.cloud.tasks.v2.Task.name]. If a
	// name is not specified then the system will generate a random
	// unique task id, which will be set in the task returned in the
	// [response][google.cloud.tasks.v2.Task.name].
	//
	// If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or is in the
	// past then Cloud Tasks will set it to the current time.
	//
	// Task De-duplication:
	//
	// Explicitly specifying a task ID enables task de-duplication.  If
	// a task's ID is identical to that of an existing task or a task
	// that was deleted or executed recently then the call will fail
	// with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
	// If the task's queue was created using Cloud Tasks, then another task with
	// the same name can't be created for ~1hour after the original task was
	// deleted or executed. If the task's queue was created using queue.yaml or
	// queue.xml, then another task with the same name can't be created
	// for ~9days after the original task was deleted or executed.
	//
	// Because there is an extra lookup cost to identify duplicate task
	// names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask] calls have significantly
	// increased latency. Using hashed strings for the task id or for
	// the prefix of the task id is recommended. Choosing task ids that
	// are sequential or have sequential prefixes, for example using a
	// timestamp, causes an increase in latency and error rates in all
	// task commands. The infrastructure relies on an approximately
	// uniform distribution of task ids to store and serve tasks
	// efficiently.
	Task *Task `protobuf:"bytes,2,opt,name=task,proto3" json:"task,omitempty"`
	// The response_view specifies which subset of the [Task][google.cloud.tasks.v2.Task] will be
	// returned.
	//
	// By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC]; not all
	// information is retrieved by default because some data, such as
	// payloads, might be desirable to return only when needed because
	// of its large size or because of the sensitivity of data that it
	// contains.
	//
	// Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
	// `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
	// permission on the [Task][google.cloud.tasks.v2.Task] resource.
	ResponseView Task_View `protobuf:"varint,3,opt,name=response_view,json=responseView,proto3,enum=google.cloud.tasks.v2.Task_View" json:"response_view,omitempty"`
}

func (x *CreateTaskRequest) Reset() {
	*x = CreateTaskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTaskRequest) ProtoMessage() {}

func (x *CreateTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTaskRequest.ProtoReflect.Descriptor instead.
func (*CreateTaskRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{12}
}

func (x *CreateTaskRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTaskRequest) GetTask() *Task {
	if x != nil {
		return x.Task
	}
	return nil
}

func (x *CreateTaskRequest) GetResponseView() Task_View {
	if x != nil {
		return x.ResponseView
	}
	return Task_VIEW_UNSPECIFIED
}

// Request message for deleting a task using
// [DeleteTask][google.cloud.tasks.v2.CloudTasks.DeleteTask].
type DeleteTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The task name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTaskRequest) Reset() {
	*x = DeleteTaskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTaskRequest) ProtoMessage() {}

func (x *DeleteTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTaskRequest.ProtoReflect.Descriptor instead.
func (*DeleteTaskRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteTaskRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for forcing a task to run now using
// [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask].
type RunTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The task name. For example:
	// `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The response_view specifies which subset of the [Task][google.cloud.tasks.v2.Task] will be
	// returned.
	//
	// By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC]; not all
	// information is retrieved by default because some data, such as
	// payloads, might be desirable to return only when needed because
	// of its large size or because of the sensitivity of data that it
	// contains.
	//
	// Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
	// `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
	// permission on the [Task][google.cloud.tasks.v2.Task] resource.
	ResponseView Task_View `protobuf:"varint,2,opt,name=response_view,json=responseView,proto3,enum=google.cloud.tasks.v2.Task_View" json:"response_view,omitempty"`
}

func (x *RunTaskRequest) Reset() {
	*x = RunTaskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunTaskRequest) ProtoMessage() {}

func (x *RunTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunTaskRequest.ProtoReflect.Descriptor instead.
func (*RunTaskRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP(), []int{14}
}

func (x *RunTaskRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RunTaskRequest) GetResponseView() Task_View {
	if x != nil {
		return x.ResponseView
	}
	return Task_VIEW_UNSPECIFIED
}

var File_google_cloud_tasks_v2_cloudtasks_proto protoreflect.FileDescriptor

var file_google_cloud_tasks_v2_cloudtasks_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x73, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73,
	0x6b, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x74, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xa8, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x12, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x65, 0x75,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x72, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x75,
	0x65, 0x52, 0x06, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x4e, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x8e, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x75, 0x65, 0x75,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x12, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x65, 0x75,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x05, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x22, 0x8a, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x05, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0x51, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x50, 0x0a, 0x11, 0x50, 0x75, 0x72, 0x67, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x50, 0x0a, 0x11, 0x50, 0x61, 0x75, 0x73, 0x65, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x51, 0x0a, 0x12, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65,
	0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x51, 0x75,
	0x65, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd5, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73,
	0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x45,
	0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x6e, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x05, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x52, 0x05, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x93, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x45, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x54, 0x61, 0x73, 0x6b, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x56, 0x69, 0x65, 0x77, 0x22, 0xd0, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a,
	0x04, 0x74, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74,
	0x61, 0x73, 0x6b, 0x12, 0x45, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0c, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x56, 0x69, 0x65, 0x77, 0x22, 0x4f, 0x0a, 0x11, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x0e,
	0x52, 0x75, 0x6e, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x0d, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x56,
	0x69, 0x65, 0x77, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x56, 0x69, 0x65,
	0x77, 0x32, 0xdd, 0x14, 0x0a, 0x0a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x54, 0x61, 0x73, 0x6b, 0x73,
	0x12, 0x9e, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x75, 0x65, 0x73, 0x12,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x75,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x8b, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x51, 0x75, 0x65, 0x75, 0x65, 0x12, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x51,
	0x75, 0x65, 0x75, 0x65, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71,
	0x75, 0x65, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xa0, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x12,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x51, 0x75,
	0x65, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33,
	0x22, 0x2a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x3a, 0x05, 0x71, 0x75,
	0x65, 0x75, 0x65, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x12, 0xab, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73,
	0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x22, 0x53, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x39, 0x32, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x71, 0x75, 0x65, 0x75, 0x65, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x65, 0x75,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x05, 0x71, 0x75, 0x65, 0x75, 0x65, 0xda, 0x41, 0x11, 0x71,
	0x75, 0x65, 0x75, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x12, 0x8b, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x51,
	0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a, 0x2a, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75,
	0x65, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x98,
	0x01, 0x0a, 0x0a, 0x50, 0x75, 0x72, 0x67, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x12, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73,
	0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x51, 0x75, 0x65, 0x75, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x22, 0x30, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x98, 0x01, 0x0a, 0x0a, 0x50, 0x61,
	0x75, 0x73, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x50, 0x61, 0x75, 0x73, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x22, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x61, 0x75, 0x73, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x9b, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x51,
	0x75, 0x65, 0x75, 0x65, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73,
	0x75, 0x6d, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x22, 0x43, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x9c, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x51,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x3b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0xa3, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x58, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x3b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x65, 0x75,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xce, 0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x22, 0x41, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xa3, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x73, 0x6b,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x34, 0x12, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x74, 0x61, 0x73, 0x6b, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x90,
	0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x22, 0x41,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xa0, 0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x73, 0x6b,
	0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x22, 0x4b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x22,
	0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61,
	0x73, 0x6b, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x74, 0x61, 0x73, 0x6b, 0x12, 0x91, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x61, 0x73, 0x6b, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x97, 0x01, 0x0a, 0x07, 0x52, 0x75, 0x6e,
	0x54, 0x61, 0x73, 0x6b, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x75, 0x6e,
	0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b,
	0x22, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x73, 0x6b,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x61, 0x73, 0x6b,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x42, 0x72, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x42, 0x0f,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x73, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x3b, 0x74, 0x61, 0x73, 0x6b, 0x73, 0xa2, 0x02, 0x05,
	0x54, 0x41, 0x53, 0x4b, 0x53, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_tasks_v2_cloudtasks_proto_rawDescOnce sync.Once
	file_google_cloud_tasks_v2_cloudtasks_proto_rawDescData = file_google_cloud_tasks_v2_cloudtasks_proto_rawDesc
)

func file_google_cloud_tasks_v2_cloudtasks_proto_rawDescGZIP() []byte {
	file_google_cloud_tasks_v2_cloudtasks_proto_rawDescOnce.Do(func() {
		file_google_cloud_tasks_v2_cloudtasks_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_tasks_v2_cloudtasks_proto_rawDescData)
	})
	return file_google_cloud_tasks_v2_cloudtasks_proto_rawDescData
}

var file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_cloud_tasks_v2_cloudtasks_proto_goTypes = []interface{}{
	(*ListQueuesRequest)(nil),             // 0: google.cloud.tasks.v2.ListQueuesRequest
	(*ListQueuesResponse)(nil),            // 1: google.cloud.tasks.v2.ListQueuesResponse
	(*GetQueueRequest)(nil),               // 2: google.cloud.tasks.v2.GetQueueRequest
	(*CreateQueueRequest)(nil),            // 3: google.cloud.tasks.v2.CreateQueueRequest
	(*UpdateQueueRequest)(nil),            // 4: google.cloud.tasks.v2.UpdateQueueRequest
	(*DeleteQueueRequest)(nil),            // 5: google.cloud.tasks.v2.DeleteQueueRequest
	(*PurgeQueueRequest)(nil),             // 6: google.cloud.tasks.v2.PurgeQueueRequest
	(*PauseQueueRequest)(nil),             // 7: google.cloud.tasks.v2.PauseQueueRequest
	(*ResumeQueueRequest)(nil),            // 8: google.cloud.tasks.v2.ResumeQueueRequest
	(*ListTasksRequest)(nil),              // 9: google.cloud.tasks.v2.ListTasksRequest
	(*ListTasksResponse)(nil),             // 10: google.cloud.tasks.v2.ListTasksResponse
	(*GetTaskRequest)(nil),                // 11: google.cloud.tasks.v2.GetTaskRequest
	(*CreateTaskRequest)(nil),             // 12: google.cloud.tasks.v2.CreateTaskRequest
	(*DeleteTaskRequest)(nil),             // 13: google.cloud.tasks.v2.DeleteTaskRequest
	(*RunTaskRequest)(nil),                // 14: google.cloud.tasks.v2.RunTaskRequest
	(*Queue)(nil),                         // 15: google.cloud.tasks.v2.Queue
	(*fieldmaskpb.FieldMask)(nil),         // 16: google.protobuf.FieldMask
	(Task_View)(0),                        // 17: google.cloud.tasks.v2.Task.View
	(*Task)(nil),                          // 18: google.cloud.tasks.v2.Task
	(*v1.GetIamPolicyRequest)(nil),        // 19: google.iam.v1.GetIamPolicyRequest
	(*v1.SetIamPolicyRequest)(nil),        // 20: google.iam.v1.SetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),  // 21: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                 // 22: google.protobuf.Empty
	(*v1.Policy)(nil),                     // 23: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil), // 24: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_tasks_v2_cloudtasks_proto_depIdxs = []int32{
	15, // 0: google.cloud.tasks.v2.ListQueuesResponse.queues:type_name -> google.cloud.tasks.v2.Queue
	15, // 1: google.cloud.tasks.v2.CreateQueueRequest.queue:type_name -> google.cloud.tasks.v2.Queue
	15, // 2: google.cloud.tasks.v2.UpdateQueueRequest.queue:type_name -> google.cloud.tasks.v2.Queue
	16, // 3: google.cloud.tasks.v2.UpdateQueueRequest.update_mask:type_name -> google.protobuf.FieldMask
	17, // 4: google.cloud.tasks.v2.ListTasksRequest.response_view:type_name -> google.cloud.tasks.v2.Task.View
	18, // 5: google.cloud.tasks.v2.ListTasksResponse.tasks:type_name -> google.cloud.tasks.v2.Task
	17, // 6: google.cloud.tasks.v2.GetTaskRequest.response_view:type_name -> google.cloud.tasks.v2.Task.View
	18, // 7: google.cloud.tasks.v2.CreateTaskRequest.task:type_name -> google.cloud.tasks.v2.Task
	17, // 8: google.cloud.tasks.v2.CreateTaskRequest.response_view:type_name -> google.cloud.tasks.v2.Task.View
	17, // 9: google.cloud.tasks.v2.RunTaskRequest.response_view:type_name -> google.cloud.tasks.v2.Task.View
	0,  // 10: google.cloud.tasks.v2.CloudTasks.ListQueues:input_type -> google.cloud.tasks.v2.ListQueuesRequest
	2,  // 11: google.cloud.tasks.v2.CloudTasks.GetQueue:input_type -> google.cloud.tasks.v2.GetQueueRequest
	3,  // 12: google.cloud.tasks.v2.CloudTasks.CreateQueue:input_type -> google.cloud.tasks.v2.CreateQueueRequest
	4,  // 13: google.cloud.tasks.v2.CloudTasks.UpdateQueue:input_type -> google.cloud.tasks.v2.UpdateQueueRequest
	5,  // 14: google.cloud.tasks.v2.CloudTasks.DeleteQueue:input_type -> google.cloud.tasks.v2.DeleteQueueRequest
	6,  // 15: google.cloud.tasks.v2.CloudTasks.PurgeQueue:input_type -> google.cloud.tasks.v2.PurgeQueueRequest
	7,  // 16: google.cloud.tasks.v2.CloudTasks.PauseQueue:input_type -> google.cloud.tasks.v2.PauseQueueRequest
	8,  // 17: google.cloud.tasks.v2.CloudTasks.ResumeQueue:input_type -> google.cloud.tasks.v2.ResumeQueueRequest
	19, // 18: google.cloud.tasks.v2.CloudTasks.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	20, // 19: google.cloud.tasks.v2.CloudTasks.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	21, // 20: google.cloud.tasks.v2.CloudTasks.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	9,  // 21: google.cloud.tasks.v2.CloudTasks.ListTasks:input_type -> google.cloud.tasks.v2.ListTasksRequest
	11, // 22: google.cloud.tasks.v2.CloudTasks.GetTask:input_type -> google.cloud.tasks.v2.GetTaskRequest
	12, // 23: google.cloud.tasks.v2.CloudTasks.CreateTask:input_type -> google.cloud.tasks.v2.CreateTaskRequest
	13, // 24: google.cloud.tasks.v2.CloudTasks.DeleteTask:input_type -> google.cloud.tasks.v2.DeleteTaskRequest
	14, // 25: google.cloud.tasks.v2.CloudTasks.RunTask:input_type -> google.cloud.tasks.v2.RunTaskRequest
	1,  // 26: google.cloud.tasks.v2.CloudTasks.ListQueues:output_type -> google.cloud.tasks.v2.ListQueuesResponse
	15, // 27: google.cloud.tasks.v2.CloudTasks.GetQueue:output_type -> google.cloud.tasks.v2.Queue
	15, // 28: google.cloud.tasks.v2.CloudTasks.CreateQueue:output_type -> google.cloud.tasks.v2.Queue
	15, // 29: google.cloud.tasks.v2.CloudTasks.UpdateQueue:output_type -> google.cloud.tasks.v2.Queue
	22, // 30: google.cloud.tasks.v2.CloudTasks.DeleteQueue:output_type -> google.protobuf.Empty
	15, // 31: google.cloud.tasks.v2.CloudTasks.PurgeQueue:output_type -> google.cloud.tasks.v2.Queue
	15, // 32: google.cloud.tasks.v2.CloudTasks.PauseQueue:output_type -> google.cloud.tasks.v2.Queue
	15, // 33: google.cloud.tasks.v2.CloudTasks.ResumeQueue:output_type -> google.cloud.tasks.v2.Queue
	23, // 34: google.cloud.tasks.v2.CloudTasks.GetIamPolicy:output_type -> google.iam.v1.Policy
	23, // 35: google.cloud.tasks.v2.CloudTasks.SetIamPolicy:output_type -> google.iam.v1.Policy
	24, // 36: google.cloud.tasks.v2.CloudTasks.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	10, // 37: google.cloud.tasks.v2.CloudTasks.ListTasks:output_type -> google.cloud.tasks.v2.ListTasksResponse
	18, // 38: google.cloud.tasks.v2.CloudTasks.GetTask:output_type -> google.cloud.tasks.v2.Task
	18, // 39: google.cloud.tasks.v2.CloudTasks.CreateTask:output_type -> google.cloud.tasks.v2.Task
	22, // 40: google.cloud.tasks.v2.CloudTasks.DeleteTask:output_type -> google.protobuf.Empty
	18, // 41: google.cloud.tasks.v2.CloudTasks.RunTask:output_type -> google.cloud.tasks.v2.Task
	26, // [26:42] is the sub-list for method output_type
	10, // [10:26] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_tasks_v2_cloudtasks_proto_init() }
func file_google_cloud_tasks_v2_cloudtasks_proto_init() {
	if File_google_cloud_tasks_v2_cloudtasks_proto != nil {
		return
	}
	file_google_cloud_tasks_v2_queue_proto_init()
	file_google_cloud_tasks_v2_task_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListQueuesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListQueuesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetQueueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateQueueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateQueueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteQueueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PurgeQueueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PauseQueueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResumeQueueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTasksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTasksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTaskRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTaskRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTaskRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunTaskRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_tasks_v2_cloudtasks_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_tasks_v2_cloudtasks_proto_goTypes,
		DependencyIndexes: file_google_cloud_tasks_v2_cloudtasks_proto_depIdxs,
		MessageInfos:      file_google_cloud_tasks_v2_cloudtasks_proto_msgTypes,
	}.Build()
	File_google_cloud_tasks_v2_cloudtasks_proto = out.File
	file_google_cloud_tasks_v2_cloudtasks_proto_rawDesc = nil
	file_google_cloud_tasks_v2_cloudtasks_proto_goTypes = nil
	file_google_cloud_tasks_v2_cloudtasks_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudTasksClient is the client API for CloudTasks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudTasksClient interface {
	// Lists queues.
	//
	// Queues are returned in lexicographical order.
	ListQueues(ctx context.Context, in *ListQueuesRequest, opts ...grpc.CallOption) (*ListQueuesResponse, error)
	// Gets a queue.
	GetQueue(ctx context.Context, in *GetQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Creates a queue.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of whether
	// it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	CreateQueue(ctx context.Context, in *CreateQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Updates a queue.
	//
	// This method creates the queue if it does not exist and updates
	// the queue if it does exist.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of whether
	// it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	UpdateQueue(ctx context.Context, in *UpdateQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Deletes a queue.
	//
	// This command will delete the queue even if it has tasks in it.
	//
	// Note: If you delete a queue, a queue with the same name can't be created
	// for 7 days.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	DeleteQueue(ctx context.Context, in *DeleteQueueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Purges a queue by deleting all of its tasks.
	//
	// All tasks created before this method is called are permanently deleted.
	//
	// Purge operations can take up to one minute to take effect. Tasks
	// might be dispatched before the purge takes effect. A purge is irreversible.
	PurgeQueue(ctx context.Context, in *PurgeQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Pauses the queue.
	//
	// If a queue is paused then the system will stop dispatching tasks
	// until the queue is resumed via
	// [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue]. Tasks can still be added
	// when the queue is paused. A queue is paused if its
	// [state][google.cloud.tasks.v2.Queue.state] is [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED].
	PauseQueue(ctx context.Context, in *PauseQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Resume a queue.
	//
	// This method resumes a queue after it has been
	// [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED] or
	// [DISABLED][google.cloud.tasks.v2.Queue.State.DISABLED]. The state of a queue is stored
	// in the queue's [state][google.cloud.tasks.v2.Queue.state]; after calling this method it
	// will be set to [RUNNING][google.cloud.tasks.v2.Queue.State.RUNNING].
	//
	// WARNING: Resuming many high-QPS queues at the same time can
	// lead to target overloading. If you are resuming high-QPS
	// queues, follow the 500/50/5 pattern described in
	// [Managing Cloud Tasks Scaling
	// Risks](https://cloud.google.com/tasks/docs/manage-cloud-task-scaling).
	ResumeQueue(ctx context.Context, in *ResumeQueueRequest, opts ...grpc.CallOption) (*Queue, error)
	// Gets the access control policy for a [Queue][google.cloud.tasks.v2.Queue].
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.getIamPolicy`
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the access control policy for a [Queue][google.cloud.tasks.v2.Queue]. Replaces any existing
	// policy.
	//
	// Note: The Cloud Console does not check queue-level IAM permissions yet.
	// Project-level permissions are required to use the Cloud Console.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.setIamPolicy`
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on a [Queue][google.cloud.tasks.v2.Queue].
	// If the resource does not exist, this will return an empty set of
	// permissions, not a [NOT_FOUND][google.rpc.Code.NOT_FOUND] error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Lists the tasks in a queue.
	//
	// By default, only the [BASIC][google.cloud.tasks.v2.Task.View.BASIC] view is retrieved
	// due to performance considerations;
	// [response_view][google.cloud.tasks.v2.ListTasksRequest.response_view] controls the
	// subset of information which is returned.
	//
	// The tasks may be returned in any order. The ordering may change at any
	// time.
	ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error)
	// Gets a task.
	GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Creates a task and adds it to a queue.
	//
	// Tasks cannot be updated after creation; there is no UpdateTask command.
	//
	// * The maximum task size is 100KB.
	CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// Deletes a task.
	//
	// A task can be deleted if it is scheduled or dispatched. A task
	// cannot be deleted if it has executed successfully or permanently
	// failed.
	DeleteTask(ctx context.Context, in *DeleteTaskRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Forces a task to run now.
	//
	// When this method is called, Cloud Tasks will dispatch the task, even if
	// the task is already running, the queue has reached its [RateLimits][google.cloud.tasks.v2.RateLimits] or
	// is [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED].
	//
	// This command is meant to be used for manual debugging. For
	// example, [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] can be used to retry a failed
	// task after a fix has been made or to manually force a task to be
	// dispatched now.
	//
	// The dispatched task is returned. That is, the task that is returned
	// contains the [status][Task.status] after the task is dispatched but
	// before the task is received by its target.
	//
	// If Cloud Tasks receives a successful response from the task's
	// target, then the task will be deleted; otherwise the task's
	// [schedule_time][google.cloud.tasks.v2.Task.schedule_time] will be reset to the time that
	// [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] was called plus the retry delay specified
	// in the queue's [RetryConfig][google.cloud.tasks.v2.RetryConfig].
	//
	// [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] returns
	// [NOT_FOUND][google.rpc.Code.NOT_FOUND] when it is called on a
	// task that has already succeeded or permanently failed.
	RunTask(ctx context.Context, in *RunTaskRequest, opts ...grpc.CallOption) (*Task, error)
}

type cloudTasksClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudTasksClient(cc grpc.ClientConnInterface) CloudTasksClient {
	return &cloudTasksClient{cc}
}

func (c *cloudTasksClient) ListQueues(ctx context.Context, in *ListQueuesRequest, opts ...grpc.CallOption) (*ListQueuesResponse, error) {
	out := new(ListQueuesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/ListQueues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) GetQueue(ctx context.Context, in *GetQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/GetQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) CreateQueue(ctx context.Context, in *CreateQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/CreateQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) UpdateQueue(ctx context.Context, in *UpdateQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/UpdateQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) DeleteQueue(ctx context.Context, in *DeleteQueueRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/DeleteQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) PurgeQueue(ctx context.Context, in *PurgeQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/PurgeQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) PauseQueue(ctx context.Context, in *PauseQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/PauseQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) ResumeQueue(ctx context.Context, in *ResumeQueueRequest, opts ...grpc.CallOption) (*Queue, error) {
	out := new(Queue)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/ResumeQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) ListTasks(ctx context.Context, in *ListTasksRequest, opts ...grpc.CallOption) (*ListTasksResponse, error) {
	out := new(ListTasksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/ListTasks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/GetTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) CreateTask(ctx context.Context, in *CreateTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/CreateTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) DeleteTask(ctx context.Context, in *DeleteTaskRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/DeleteTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudTasksClient) RunTask(ctx context.Context, in *RunTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := c.cc.Invoke(ctx, "/google.cloud.tasks.v2.CloudTasks/RunTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudTasksServer is the server API for CloudTasks service.
type CloudTasksServer interface {
	// Lists queues.
	//
	// Queues are returned in lexicographical order.
	ListQueues(context.Context, *ListQueuesRequest) (*ListQueuesResponse, error)
	// Gets a queue.
	GetQueue(context.Context, *GetQueueRequest) (*Queue, error)
	// Creates a queue.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of whether
	// it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	CreateQueue(context.Context, *CreateQueueRequest) (*Queue, error)
	// Updates a queue.
	//
	// This method creates the queue if it does not exist and updates
	// the queue if it does exist.
	//
	// Queues created with this method allow tasks to live for a maximum of 31
	// days. After a task is 31 days old, the task will be deleted regardless of whether
	// it was dispatched or not.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	UpdateQueue(context.Context, *UpdateQueueRequest) (*Queue, error)
	// Deletes a queue.
	//
	// This command will delete the queue even if it has tasks in it.
	//
	// Note: If you delete a queue, a queue with the same name can't be created
	// for 7 days.
	//
	// WARNING: Using this method may have unintended side effects if you are
	// using an App Engine `queue.yaml` or `queue.xml` file to manage your queues.
	// Read
	// [Overview of Queue Management and
	// queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using
	// this method.
	DeleteQueue(context.Context, *DeleteQueueRequest) (*emptypb.Empty, error)
	// Purges a queue by deleting all of its tasks.
	//
	// All tasks created before this method is called are permanently deleted.
	//
	// Purge operations can take up to one minute to take effect. Tasks
	// might be dispatched before the purge takes effect. A purge is irreversible.
	PurgeQueue(context.Context, *PurgeQueueRequest) (*Queue, error)
	// Pauses the queue.
	//
	// If a queue is paused then the system will stop dispatching tasks
	// until the queue is resumed via
	// [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue]. Tasks can still be added
	// when the queue is paused. A queue is paused if its
	// [state][google.cloud.tasks.v2.Queue.state] is [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED].
	PauseQueue(context.Context, *PauseQueueRequest) (*Queue, error)
	// Resume a queue.
	//
	// This method resumes a queue after it has been
	// [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED] or
	// [DISABLED][google.cloud.tasks.v2.Queue.State.DISABLED]. The state of a queue is stored
	// in the queue's [state][google.cloud.tasks.v2.Queue.state]; after calling this method it
	// will be set to [RUNNING][google.cloud.tasks.v2.Queue.State.RUNNING].
	//
	// WARNING: Resuming many high-QPS queues at the same time can
	// lead to target overloading. If you are resuming high-QPS
	// queues, follow the 500/50/5 pattern described in
	// [Managing Cloud Tasks Scaling
	// Risks](https://cloud.google.com/tasks/docs/manage-cloud-task-scaling).
	ResumeQueue(context.Context, *ResumeQueueRequest) (*Queue, error)
	// Gets the access control policy for a [Queue][google.cloud.tasks.v2.Queue].
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.getIamPolicy`
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the access control policy for a [Queue][google.cloud.tasks.v2.Queue]. Replaces any existing
	// policy.
	//
	// Note: The Cloud Console does not check queue-level IAM permissions yet.
	// Project-level permissions are required to use the Cloud Console.
	//
	// Authorization requires the following
	// [Google IAM](https://cloud.google.com/iam) permission on the specified
	// resource parent:
	//
	// * `cloudtasks.queues.setIamPolicy`
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on a [Queue][google.cloud.tasks.v2.Queue].
	// If the resource does not exist, this will return an empty set of
	// permissions, not a [NOT_FOUND][google.rpc.Code.NOT_FOUND] error.
	//
	// Note: This operation is designed to be used for building permission-aware
	// UIs and command-line tools, not for authorization checking. This operation
	// may "fail open" without warning.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Lists the tasks in a queue.
	//
	// By default, only the [BASIC][google.cloud.tasks.v2.Task.View.BASIC] view is retrieved
	// due to performance considerations;
	// [response_view][google.cloud.tasks.v2.ListTasksRequest.response_view] controls the
	// subset of information which is returned.
	//
	// The tasks may be returned in any order. The ordering may change at any
	// time.
	ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error)
	// Gets a task.
	GetTask(context.Context, *GetTaskRequest) (*Task, error)
	// Creates a task and adds it to a queue.
	//
	// Tasks cannot be updated after creation; there is no UpdateTask command.
	//
	// * The maximum task size is 100KB.
	CreateTask(context.Context, *CreateTaskRequest) (*Task, error)
	// Deletes a task.
	//
	// A task can be deleted if it is scheduled or dispatched. A task
	// cannot be deleted if it has executed successfully or permanently
	// failed.
	DeleteTask(context.Context, *DeleteTaskRequest) (*emptypb.Empty, error)
	// Forces a task to run now.
	//
	// When this method is called, Cloud Tasks will dispatch the task, even if
	// the task is already running, the queue has reached its [RateLimits][google.cloud.tasks.v2.RateLimits] or
	// is [PAUSED][google.cloud.tasks.v2.Queue.State.PAUSED].
	//
	// This command is meant to be used for manual debugging. For
	// example, [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] can be used to retry a failed
	// task after a fix has been made or to manually force a task to be
	// dispatched now.
	//
	// The dispatched task is returned. That is, the task that is returned
	// contains the [status][Task.status] after the task is dispatched but
	// before the task is received by its target.
	//
	// If Cloud Tasks receives a successful response from the task's
	// target, then the task will be deleted; otherwise the task's
	// [schedule_time][google.cloud.tasks.v2.Task.schedule_time] will be reset to the time that
	// [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] was called plus the retry delay specified
	// in the queue's [RetryConfig][google.cloud.tasks.v2.RetryConfig].
	//
	// [RunTask][google.cloud.tasks.v2.CloudTasks.RunTask] returns
	// [NOT_FOUND][google.rpc.Code.NOT_FOUND] when it is called on a
	// task that has already succeeded or permanently failed.
	RunTask(context.Context, *RunTaskRequest) (*Task, error)
}

// UnimplementedCloudTasksServer can be embedded to have forward compatible implementations.
type UnimplementedCloudTasksServer struct {
}

func (*UnimplementedCloudTasksServer) ListQueues(context.Context, *ListQueuesRequest) (*ListQueuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListQueues not implemented")
}
func (*UnimplementedCloudTasksServer) GetQueue(context.Context, *GetQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetQueue not implemented")
}
func (*UnimplementedCloudTasksServer) CreateQueue(context.Context, *CreateQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateQueue not implemented")
}
func (*UnimplementedCloudTasksServer) UpdateQueue(context.Context, *UpdateQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateQueue not implemented")
}
func (*UnimplementedCloudTasksServer) DeleteQueue(context.Context, *DeleteQueueRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteQueue not implemented")
}
func (*UnimplementedCloudTasksServer) PurgeQueue(context.Context, *PurgeQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeQueue not implemented")
}
func (*UnimplementedCloudTasksServer) PauseQueue(context.Context, *PauseQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseQueue not implemented")
}
func (*UnimplementedCloudTasksServer) ResumeQueue(context.Context, *ResumeQueueRequest) (*Queue, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeQueue not implemented")
}
func (*UnimplementedCloudTasksServer) GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedCloudTasksServer) SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedCloudTasksServer) TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedCloudTasksServer) ListTasks(context.Context, *ListTasksRequest) (*ListTasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTasks not implemented")
}
func (*UnimplementedCloudTasksServer) GetTask(context.Context, *GetTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTask not implemented")
}
func (*UnimplementedCloudTasksServer) CreateTask(context.Context, *CreateTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTask not implemented")
}
func (*UnimplementedCloudTasksServer) DeleteTask(context.Context, *DeleteTaskRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTask not implemented")
}
func (*UnimplementedCloudTasksServer) RunTask(context.Context, *RunTaskRequest) (*Task, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunTask not implemented")
}

func RegisterCloudTasksServer(s *grpc.Server, srv CloudTasksServer) {
	s.RegisterService(&_CloudTasks_serviceDesc, srv)
}

func _CloudTasks_ListQueues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListQueuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).ListQueues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/ListQueues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).ListQueues(ctx, req.(*ListQueuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_GetQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).GetQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/GetQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).GetQueue(ctx, req.(*GetQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_CreateQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).CreateQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/CreateQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).CreateQueue(ctx, req.(*CreateQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_UpdateQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).UpdateQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/UpdateQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).UpdateQueue(ctx, req.(*UpdateQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_DeleteQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).DeleteQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/DeleteQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).DeleteQueue(ctx, req.(*DeleteQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_PurgeQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).PurgeQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/PurgeQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).PurgeQueue(ctx, req.(*PurgeQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_PauseQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).PauseQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/PauseQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).PauseQueue(ctx, req.(*PauseQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_ResumeQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).ResumeQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/ResumeQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).ResumeQueue(ctx, req.(*ResumeQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_ListTasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).ListTasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/ListTasks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).ListTasks(ctx, req.(*ListTasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_GetTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).GetTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/GetTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).GetTask(ctx, req.(*GetTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_CreateTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).CreateTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/CreateTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).CreateTask(ctx, req.(*CreateTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_DeleteTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).DeleteTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/DeleteTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).DeleteTask(ctx, req.(*DeleteTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudTasks_RunTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudTasksServer).RunTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.tasks.v2.CloudTasks/RunTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudTasksServer).RunTask(ctx, req.(*RunTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudTasks_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.tasks.v2.CloudTasks",
	HandlerType: (*CloudTasksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListQueues",
			Handler:    _CloudTasks_ListQueues_Handler,
		},
		{
			MethodName: "GetQueue",
			Handler:    _CloudTasks_GetQueue_Handler,
		},
		{
			MethodName: "CreateQueue",
			Handler:    _CloudTasks_CreateQueue_Handler,
		},
		{
			MethodName: "UpdateQueue",
			Handler:    _CloudTasks_UpdateQueue_Handler,
		},
		{
			MethodName: "DeleteQueue",
			Handler:    _CloudTasks_DeleteQueue_Handler,
		},
		{
			MethodName: "PurgeQueue",
			Handler:    _CloudTasks_PurgeQueue_Handler,
		},
		{
			MethodName: "PauseQueue",
			Handler:    _CloudTasks_PauseQueue_Handler,
		},
		{
			MethodName: "ResumeQueue",
			Handler:    _CloudTasks_ResumeQueue_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _CloudTasks_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _CloudTasks_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _CloudTasks_TestIamPermissions_Handler,
		},
		{
			MethodName: "ListTasks",
			Handler:    _CloudTasks_ListTasks_Handler,
		},
		{
			MethodName: "GetTask",
			Handler:    _CloudTasks_GetTask_Handler,
		},
		{
			MethodName: "CreateTask",
			Handler:    _CloudTasks_CreateTask_Handler,
		},
		{
			MethodName: "DeleteTask",
			Handler:    _CloudTasks_DeleteTask_Handler,
		},
		{
			MethodName: "RunTask",
			Handler:    _CloudTasks_RunTask_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/tasks/v2/cloudtasks.proto",
}
