# 2022-01-12 Triage Log

Improvements generally outweighed regressions with most regressions coming in the form of correctness fixes (where performance regressions are generally less of a concern). The biggest win was arguably a change to the Sip128 hasher implementation which seemed to have decent performance implications for many real world crates. 

Triage done by **@rylev**.
Revision range: [2b681ac06b1a6b7ea39525e59363ffee0d1a68e5..72e74d7b9cf1a7901650227e74650f1fcc797600](https://perf.rust-lang.org/?start=2b681ac06b1a6b7ea39525e59363ffee0d1a68e5&end=72e74d7b9cf1a7901650227e74650f1fcc797600&absolute=false&stat=instructions%3Au)

3 Regressions, 7 Improvements, 2 Mixed; 4 of them in rollups
28 comparisons made in total

#### Regressions

Hash `Ident` spans in all HIR structures [#92534](https://github.com/rust-lang/rust/issues/92534)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f7bb8e3677ba4277914e85a3060e5d69151aed44&end=092e1c9d23158d81be27bb6f71bdd0c6282478fb&stat=instructions:u) (up to 1.6% on `incr-unchanged` builds of `derive`)
- A subset of of [#92210](https://github.com/rust-lang/rust/pull/92210) which has absolutely horrific performance regressions. This is a partial fix where the regressions are much less severe.
- This is a correctness fix so performance loss is typically much more acceptable. Without this fix, it was possible for incremental compilation [to be broken](https://github.com/rust-lang/rust/issues/92192) when a change to a span was misidentified as not being an actual change.


Ensure that `Fingerprint` caching respects hashing configuration [#92278](https://github.com/rust-lang/rust/issues/92278)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=092e1c9d23158d81be27bb6f71bdd0c6282478fb&end=d63a8d965e76f29a2b65c1f22a32613df1fe5c2c&stat=instructions:u) (up to 1.3% on `incr-unchanged` builds of `clap-rs`)
- Another fix in how we're doing hashing of certain structures. This is a correctness fix and as such, the relatively moderation regression [was deemed acceptable](https://github.com/rust-lang/rust/pull/92278#issuecomment-1001765797).


Actually instantiate the opaque type when checking bounds [#90948](https://github.com/rust-lang/rust/issues/90948)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2e2c86eba21a08cf505cd67073736d03ff3887ad&end=1409c015b44a4d4d38bef2250b2a37c17b8b7463&stat=instructions:u) (up to 1.2% on `full` builds of `wg-grammar`)
- The regressions are mostly limited to a stress benchmark (`wg-grammar`) and as a correctness fix [were deemed acceptable](https://github.com/rust-lang/rust/pull/90948#issuecomment-984361673).


#### Improvements

Do not hash leading zero bytes of i64 numbers in Sip128 hasher [#92103](https://github.com/rust-lang/rust/issues/92103)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b03c504742d086df063bfa105a1186bbc01a4b0e&end=936ce3dab7fd042101767c439362310f8355e859&stat=instructions:u) (up to -6.9% on `incr-full` builds of `clap-rs`)


Rollup of 8 pull requests [#92627](https://github.com/rust-lang/rust/issues/92627)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=cfa4ac66c194046f631ce076c75516ecfdeb77ee&end=e012a191d768adeda1ee36a99ef8b92d51920154&stat=instructions:u) (up to -2.9% on `incr-unchanged` builds of `clap-rs`)


rustc_metadata: Optimize and document module children decoding [#92086](https://github.com/rust-lang/rust/issues/92086)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=02fe61b381c2dedc0071e1aacfbe91e0bad1f656&end=e19ca1d946269f7b7eb13171531caf2e16f42076&stat=instructions:u) (up to -14.9% on `incr-unchanged` builds of `issue-88862`)


Rollup of 8 pull requests [#92690](https://github.com/rust-lang/rust/issues/92690)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e19ca1d946269f7b7eb13171531caf2e16f42076&end=f7bb8e3677ba4277914e85a3060e5d69151aed44&stat=instructions:u) (up to -2.5% on `full` builds of `cargo`)


Fixes wrong unreachable_pub lints on nested and glob public reexport [#87487](https://github.com/rust-lang/rust/issues/87487)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d63a8d965e76f29a2b65c1f22a32613df1fe5c2c&end=df035a33b228daa700ac50712d9e16509d373e41&stat=instructions:u) (up to -1.1% on `incr-unchanged` builds of `unused-warnings`)


Rollup of 7 pull requests [#92719](https://github.com/rust-lang/rust/issues/92719)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=df035a33b228daa700ac50712d9e16509d373e41&end=89b9f7b284aacc5f8613438b80e4dd7bdd10549e&stat=instructions:u) (up to -1.2% on `full` builds of `keccak`)


Store a `Symbol` instead of an `Ident` in `VariantDef`/`FieldDef` [#92533](https://github.com/rust-lang/rust/issues/92533)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1409c015b44a4d4d38bef2250b2a37c17b8b7463&end=72e74d7b9cf1a7901650227e74650f1fcc797600&stat=instructions:u) (up to -5.9% on `incr-unchanged` builds of `issue-46449`)


#### Mixed

Rollup of 7 pull requests [#92556](https://github.com/rust-lang/rust/issues/92556)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2b681ac06b1a6b7ea39525e59363ffee0d1a68e5&end=7d6f948173ccb18822bab13d548c65632db5f0aa&stat=instructions:u) (up to -1.6% on `incr-full` builds of `issue-88862`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2b681ac06b1a6b7ea39525e59363ffee0d1a68e5&end=7d6f948173ccb18822bab13d548c65632db5f0aa&stat=instructions:u) (up to 6.6% on `full` builds of `tokio-webpush-simple`)


Switch all libraries to the 2021 edition [#92068](https://github.com/rust-lang/rust/issues/92068)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a7e2e33960e95d2eb1a2a2aeec169dba5f73de05&end=23ce5fc4655ed546f74a85fc8836e95bec0c64fd&stat=instructions:u) (up to -0.4% on `full` builds of `cranelift-codegen`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a7e2e33960e95d2eb1a2a2aeec169dba5f73de05&end=23ce5fc4655ed546f74a85fc8836e95bec0c64fd&stat=instructions:u) (up to 3.1% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo`)
- Seems like the panic infrastructure in the 2021 edition is ever so slightly more expensive to compile and run causing this issue. It was [deemed acceptable](https://github.com/rust-lang/rust/pull/92068#issuecomment-1008349995) to take the small performance hit.

#### Untriaged Pull Requests

- [#92534 Hash `Ident` spans in all HIR structures](https://github.com/rust-lang/rust/pull/92534)
- [#92252 Update pulldown-cmark version to 0.9](https://github.com/rust-lang/rust/pull/92252)
- [#92229 Do not display `~const Drop` in rustdoc](https://github.com/rust-lang/rust/pull/92229)
- [#92227 Rustdoc: use `is_doc_hidden` method on more places](https://github.com/rust-lang/rust/pull/92227)
- [#92149 Fix bad caching of `~const Drop` bounds](https://github.com/rust-lang/rust/pull/92149)
- [#92135 Add `#[inline]` modifier to `TypeId::of`](https://github.com/rust-lang/rust/pull/92135)
- [#92110 Backport LLVM changes to disable deferred inlining](https://github.com/rust-lang/rust/pull/92110)
- [#92106 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/92106)
- [#92088 intra-doc: Use an enum to represent URL fragments](https://github.com/rust-lang/rust/pull/92088)
- [#92064 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92064)
- [#92062 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92062)
- [#92041 Remove 'speculative evaluation' of predicates](https://github.com/rust-lang/rust/pull/92041)
- [#92003 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92003)
- [#91996 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91996)
- [#91959 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91959)
- [#91924 Fully serialize AdtDef](https://github.com/rust-lang/rust/pull/91924)
- [#91900 rustdoc: make `--passes` and `--no-defaults` have no effect](https://github.com/rust-lang/rust/pull/91900)
- [#91844 Eliminate `ObligationCauseData`](https://github.com/rust-lang/rust/pull/91844)
- [#91841 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/91841)
- [#91838 Do array-slice equality via array equality, rather than always via slices](https://github.com/rust-lang/rust/pull/91838)
- [#91812 rustdoc: Pretty-print assoc const defaults on-demand](https://github.com/rust-lang/rust/pull/91812)
- [#91799 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91799)
- [#91766 Allow `memcmp` for more array comparisons](https://github.com/rust-lang/rust/pull/91766)
- [#91406 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/91406)
- [#91354 Cleanup: Eliminate ConstnessAnd](https://github.com/rust-lang/rust/pull/91354)
- [#91318 Reduce boilerplate around infallible folders](https://github.com/rust-lang/rust/pull/91318)
- [#91288 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91288)
- [#91269 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91269)
