/***************************************************************************
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \___|\___/|_| \_\_____|
 *
 * Copyright (C) Daniel Stenberg, <daniel@haxx.se>, et al.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution. The terms
 * are also available at https://curl.se/docs/copyright.html.
 *
 * You may opt to use, copy, modify, merge, publish, distribute and/or sell
 * copies of the Software, and permit persons to whom the Software is
 * furnished to do so, under the terms of the COPYING file.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 * SPDX-License-Identifier: curl
 *
 ***************************************************************************/
/* This is the 'proxyauth.c' test app posted by Shmulik Regev on the libcurl
 * mailing list on 10 Jul 2007, converted to a test case.
 *
 * argv1 = URL
 * argv2 = proxy
 * argv3 = proxyuser:password
 * argv4 = hostname to use for the custom Host: header
 */

#include "first.h"

static CURL *t540_curl[2];

static CURLcode init(int num, CURLM *multi, const char *url,
                     const char *userpwd, struct curl_slist *headers)
{
  CURLcode result = CURLE_OK;

  const char *proxy = libtest_arg2;

  res_easy_init(t540_curl[num]);
  if(result)
    goto init_failed;

  res_easy_setopt(t540_curl[num], CURLOPT_URL, url);
  if(result)
    goto init_failed;

  res_easy_setopt(t540_curl[num], CURLOPT_PROXY, proxy);
  if(result)
    goto init_failed;

  res_easy_setopt(t540_curl[num], CURLOPT_PROXYUSERPWD, userpwd);
  if(result)
    goto init_failed;

  res_easy_setopt(t540_curl[num], CURLOPT_PROXYAUTH, CURLAUTH_ANY);
  if(result)
    goto init_failed;

  res_easy_setopt(t540_curl[num], CURLOPT_VERBOSE, 1L);
  if(result)
    goto init_failed;

  res_easy_setopt(t540_curl[num], CURLOPT_HEADER, 1L);
  if(result)
    goto init_failed;

  /* custom Host: */
  res_easy_setopt(t540_curl[num], CURLOPT_HTTPHEADER, headers);
  if(result)
    goto init_failed;

  res_multi_add_handle(multi, t540_curl[num]);
  if(result)
    goto init_failed;

  return CURLE_OK; /* success */

init_failed:

  curl_easy_cleanup(t540_curl[num]);
  t540_curl[num] = NULL;

  return result; /* failure */
}

static CURLcode loop(int num, CURLM *multi, const char *url,
                     const char *userpwd, struct curl_slist *headers)
{
  CURLMsg *msg;
  long L;
  int Q, U = -1;
  fd_set R, W, E;
  struct timeval T;
  CURLcode result = CURLE_OK;

  result = init(num, multi, url, userpwd, headers);
  if(result)
    return result;

  while(U) {

    int M = -99;

    res_multi_perform(multi, &U);
    if(result)
      return result;

    res_test_timedout();
    if(result)
      return result;

    if(U) {
      FD_ZERO(&R);
      FD_ZERO(&W);
      FD_ZERO(&E);

      res_multi_fdset(multi, &R, &W, &E, &M);
      if(result)
        return result;

      /* At this point, M is guaranteed to be greater or equal than -1. */

      res_multi_timeout(multi, &L);
      if(result)
        return result;

      /* At this point, L is guaranteed to be greater or equal than -1. */

      if(L != -1) {
        int itimeout;
#if LONG_MAX > INT_MAX
        itimeout = (L > INT_MAX) ? INT_MAX : (int)L;
#else
        itimeout = (int)L;
#endif
        T.tv_sec = itimeout / 1000;
        T.tv_usec = (itimeout % 1000) * 1000;
      }
      else {
        T.tv_sec = 5;
        T.tv_usec = 0;
      }

      res_select_test(M + 1, &R, &W, &E, &T);
      if(result)
        return result;
    }

    while(1) {
      msg = curl_multi_info_read(multi, &Q);
      if(!msg)
        break;
      if(msg->msg == CURLMSG_DONE) {
        size_t i;
        CURL *curl = msg->easy_handle;
        curl_mfprintf(stderr, "R: %d - %s\n", msg->data.result,
                      curl_easy_strerror(msg->data.result));
        curl_multi_remove_handle(multi, curl);
        curl_easy_cleanup(curl);
        for(i = 0; i < CURL_ARRAYSIZE(t540_curl); i++) {
          if(t540_curl[i] == curl) {
            t540_curl[i] = NULL;
            break;
          }
        }
      }
      else
        curl_mfprintf(stderr, "E: CURLMsg (%d)\n", msg->msg);
    }

    res_test_timedout();
    if(result)
      return result;
  }

  return CURLE_OK;
}

static CURLcode test_lib540(const char *URL)
{
  CURLM *multi = NULL;
  struct curl_slist *headers = NULL;
  char buffer[246]; /* naively fixed-size */
  CURLcode result = CURLE_OK;
  size_t i;

  const char *proxyuserpws = libtest_arg3;
  const char *host;

  for(i = 0; i < CURL_ARRAYSIZE(t540_curl); i++)
    t540_curl[i] = NULL;

  start_test_timing();

  if(test_argc < 4)
    return TEST_ERR_MAJOR_BAD;

  host = test_argv[4];
  curl_msnprintf(buffer, sizeof(buffer), "Host: %s", host);

  /* now add a custom Host: header */
  headers = curl_slist_append(headers, buffer);
  if(!headers) {
    curl_mfprintf(stderr, "curl_slist_append() failed\n");
    return TEST_ERR_MAJOR_BAD;
  }

  res_global_init(CURL_GLOBAL_ALL);
  if(result) {
    curl_slist_free_all(headers);
    return result;
  }

  res_multi_init(multi);
  if(result) {
    curl_global_cleanup();
    curl_slist_free_all(headers);
    return result;
  }

  result = loop(0, multi, URL, proxyuserpws, headers);
  if(result)
    goto test_cleanup;

  curl_mfprintf(stderr, "lib540: now we do the request again\n");

  result = loop(1, multi, URL, proxyuserpws, headers);

test_cleanup:

  /* proper cleanup sequence - type PB */

  for(i = 0; i < CURL_ARRAYSIZE(t540_curl); i++) {
    curl_multi_remove_handle(multi, t540_curl[i]);
    curl_easy_cleanup(t540_curl[i]);
  }

  curl_multi_cleanup(multi);
  curl_global_cleanup();

  curl_slist_free_all(headers);

  return result;
}
