/* SPDX-License-Identifier: LGPL-2.1-or-later */
/*
 * Copyright (C) 2019, Collabora Ltd.
 *     Author: Nicolas Dufresne <nicolas.dufresne@collabora.com>
 *
 * GStreamer Capture Element
 */

#pragma once

#include "gstlibcamerapool.h"

#include <gst/gst.h>

#include <libcamera/stream.h>

#define GST_TYPE_LIBCAMERA_PAD gst_libcamera_pad_get_type()
G_DECLARE_FINAL_TYPE(GstLibcameraPad, gst_libcamera_pad, GST_LIBCAMERA, PAD, GstPad)

libcamera::StreamRole gst_libcamera_pad_get_role(GstPad *pad);

GstLibcameraPool *gst_libcamera_pad_get_pool(GstPad *pad);

void gst_libcamera_pad_set_pool(GstPad *pad, GstLibcameraPool *pool);

GstBufferPool *gst_libcamera_pad_get_video_pool(GstPad *pad);

void gst_libcamera_pad_set_video_pool(GstPad *pad, GstBufferPool *video_pool);

GstVideoInfo gst_libcamera_pad_get_video_info(GstPad *pad);

void gst_libcamera_pad_set_video_info(GstPad *pad, const GstVideoInfo *info);

libcamera::Stream *gst_libcamera_pad_get_stream(GstPad *pad);

void gst_libcamera_pad_set_stream(GstPad *pad, libcamera::Stream *stream);

void gst_libcamera_pad_set_latency(GstPad *pad, GstClockTime latency);
