% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDelayedArray.R
\name{readDelayedArray}
\alias{readDelayedArray}
\title{Read a delayed array from disk}
\usage{
readDelayedArray(path, metadata, delayed_array.reload.args = list(), ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created by the \code{\link{saveObject}} method for a delayed array.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObject}} for more details.}

\item{delayed_array.reload.args}{Named list of arguments to be passed to \code{\link{reloadDelayedObject}}.}

\item{...}{Further arguments, ignored.}
}
\value{
A multi-dimensional array-like object.
}
\description{
Read a delayed high-dimensional array from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
arr <- array(rpois(10000, 10), c(50, 20, 10))
dimnames(arr) <- list(
   paste0("GENE_", seq_len(nrow(arr))),
   letters[1:20],
   NULL
)

dir <- tempfile()
saveObject(arr, dir)
readObject(dir)

}
\seealso{
\code{"\link{saveObject,DelayedArray-method}"}, to create the directory and its contents.

\code{\link{reloadDelayedObject}}, for the methods to reload each delayed operation.
}
\author{
Aaron Lun
}
