% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveSparseMatrix.R
\name{saveSparseMatrix}
\alias{saveSparseMatrix}
\alias{saveObject,sparseMatrix-method}
\alias{saveObject,SVT_SparseMatrix-method}
\title{Save a sparse matrix to disk}
\usage{
\S4method{saveObject}{sparseMatrix}(x, path, ...)

\S4method{saveObject}{SVT_SparseMatrix}(x, path, ...)
}
\arguments{
\item{x}{A sparse matrix of some kind, typically from either the \pkg{Matrix} or \pkg{SparseArray} packages.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Further arguments, currently ignored.}
}
\value{
\code{x} is saved to \code{path} and \code{NULL} is invisibly returned.
}
\description{
Save a sparse matrix to its on-disk representations.
}
\examples{
mat <- Matrix::rsparsematrix(100, 200, density=0.2)
rownames(mat) <- paste0("GENE_", seq_len(nrow(mat)))

dir <- tempfile()
saveObject(mat, dir)
list.files(dir)

}
\seealso{
\code{\link{readSparseMatrix}}, to read the directory contents back into the R session.
}
\author{
Aaron Lun
}
