% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolveLinks.R
\name{resolveLinks}
\alias{resolveLinks}
\title{Resolve links in the cache directory}
\usage{
resolveLinks(
  project,
  asset,
  version,
  cache = cacheDirectory(),
  overwrite = FALSE,
  url = restUrl(),
  config = NULL
)
}
\arguments{
\item{project}{String containing the project name.}

\item{asset}{String containing the asset name.}

\item{version}{String containing the version name.}

\item{cache}{String containing the path to the cache directory.}

\item{overwrite}{Logical scalar indicating whether to replace existing files at the linked-from paths.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{config}{Deprecated and ignored.}
}
\value{
\code{NULL} is returned on successful completion.
}
\description{
Create hard links (or copies, if filesystem links are not supported) for linked-from files to their link destinations.
}
\examples{
cache <- tempfile()
saveVersion("test-R", "basic", "v3", relink=FALSE, cache=cache)
list.files(cache, recursive=TRUE, all.files=TRUE)

resolveLinks("test-R", "basic", "v3", cache=cache)
list.files(cache, recursive=TRUE, all.files=TRUE)

}
\author{
Aaron Lun
}
