% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getErrorMessages.R
\name{getErrorMessages}
\alias{getErrorMessages}
\title{Retrieve Error Messages}
\usage{
getErrorMessages(
  ids = NULL,
  missing.as.error = FALSE,
  reg = getDefaultRegistry()
)
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to the return value of \code{\link{findErrors}}.
Invalid ids are ignored.}

\item{missing.as.error}{[\code{logical(1)}]\cr
Treat missing results as errors? If \code{TRUE}, the error message \dQuote{[not terminated]} is imputed
for jobs which have not terminated. Default is \code{FALSE}}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}
}
\value{
[\code{\link[data.table]{data.table}}] with columns \dQuote{job.id}, \dQuote{terminated} (logical),
  \dQuote{error} (logical) and \dQuote{message} (string).
}
\description{
Extracts error messages from the internal data base and returns them in a table.
}
\examples{
\dontshow{ batchtools:::example_push_temp(1) }
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
fun = function(i) if (i == 3) stop(i) else i
ids = batchMap(fun, i = 1:5, reg = tmp)
submitJobs(1:4, reg = tmp)
waitForJobs(1:4, reg = tmp)
getErrorMessages(ids, reg = tmp)
getErrorMessages(ids, missing.as.error = TRUE, reg = tmp)
}
\seealso{
Other debug: 
\code{\link{getStatus}()},
\code{\link{grepLogs}()},
\code{\link{killJobs}()},
\code{\link{resetJobs}()},
\code{\link{showLog}()},
\code{\link{testJob}()}
}
\concept{debug}
