% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posixt.R
\name{date-time-zone}
\alias{date-time-zone}
\alias{date_time_zone}
\alias{date_time_set_zone}
\title{Get or set the time zone}
\usage{
date_time_zone(x)

date_time_set_zone(x, zone)
}
\arguments{
\item{x}{\verb{[POSIXct / POSIXlt]}

A date-time vector.}

\item{zone}{\verb{[character(1)]}

A valid time zone to switch to.}
}
\value{
\itemize{
\item \code{date_time_zone()} returns a string containing the time zone.
\item \code{date_time_set_zone()} returns \code{x} with an altered printed time. The
underlying duration is not changed.
}
}
\description{
\itemize{
\item \code{date_time_zone()} gets the time zone.
\item \code{date_time_set_zone()} sets the time zone. This retains the \emph{underlying
duration}, but changes the \emph{printed time} depending on the zone that is
chosen.
}
}
\details{
This function is only valid for date-times, as clock treats R's Date class as
a \emph{naive} type, which always has a yet-to-be-specified time zone.
}
\examples{
library(magrittr)

# Cannot set or get the zone of Date.
# clock assumes that Dates are naive types, like naive-time.
x <- date_parse("2019-01-01")
try(date_time_zone(x))
try(date_time_set_zone(x, "America/New_York"))

x <- date_time_parse("2019-01-02 01:30:00", "America/New_York")
x

date_time_zone(x)

# If it is 1:30am in New York, what time is it in Los Angeles?
# Same underlying duration, new printed time
date_time_set_zone(x, "America/Los_Angeles")

# If you want to retain the printed time, but change the underlying duration,
# convert to a naive-time to drop the time zone, then convert back to a
# date-time. Be aware that this requires that you handle daylight saving time
# irregularities with the `nonexistent` and `ambiguous` arguments to
# `as_date_time()`!
x \%>\%
  as_naive_time() \%>\%
  as_date_time("America/Los_Angeles")

y <- date_time_parse("2021-03-28 03:30:00", "America/New_York")
y

y_nt <- as_naive_time(y)
y_nt

# Helsinki had a daylight saving time gap where they jumped from
# 02:59:59 -> 04:00:00
try(as_date_time(y_nt, "Europe/Helsinki"))

as_date_time(y_nt, "Europe/Helsinki", nonexistent = "roll-forward")
as_date_time(y_nt, "Europe/Helsinki", nonexistent = "roll-backward")
}
