% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf.R
\name{eafdiff}
\alias{eafdiff}
\title{Compute empirical attainment function differences}
\usage{
eafdiff(x, y, intervals, maximise = c(FALSE, FALSE),
  rectangles = FALSE)
}
\arguments{
\item{x, y}{Data frames corresponding to the input data of
left and right sides, respectively. Each data frame has at least three
columns, the third one being the set of each point. See also
\code{\link{read_datasets}}.}

\item{intervals}{(`integer(1)`) \cr The absolute range of the differences
\eqn{[0, 1]} is partitioned into the number of intervals provided.}

\item{maximise}{(\code{logical()} | \code{logical(1)}) \cr Whether the objectives must be
maximised instead of minimised. Either a single logical value that applies
to all objectives or a vector of logical values, with one value per
objective.}

\item{rectangles}{If TRUE, the output is in the form of rectangles of the same color.}
}
\value{
With \code{rectangle=FALSE}, a \code{data.frame} containing points
  where there is a transition in the value of the EAF differences. The last
  column gives the difference in terms of sets in \code{x} minus sets in
  \code{y} that attain each point (i.e., negative values are differences in
  favour \code{y}).
}
\description{
Calculate the differences between the empirical attainment functions of two
data sets.
}
\details{
This function calculates the differences between the EAFs of two
  data sets.
}
\examples{
A1 <- read_datasets(file.path(system.file(package="eaf"), "extdata", "ALG_1_dat"))
A2 <- read_datasets(file.path(system.file(package="eaf"), "extdata", "ALG_2_dat"))
d <- eafdiff(A1, A2)
# This is large
str(d)
head(d)

d <- eafdiff(A1, A2, rectangles = TRUE)
# This is large
str(d)
head(d)
# FIXME: finish this!
# Small example
X <- read_datasets(text='
1 2
2.5 1

3.5 2

2 3

4 1
')
Y <- read_datasets(text='
2.5 1

3.5 2

2 3

4 1
')


}
\seealso{
\code{\link{read_datasets}}, \code{\link{eafdiffplot}}
}
