% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviceUtils.R
\encoding{UTF8}
\name{anyMultibyteUTF8Characters}
\alias{anyMultibyteUTF8Characters}
\title{Check If a String Contains Multibyte UTF-8 characters}
\usage{
anyMultibyteUTF8Characters(string, encoding = "UTF-8")
}
\arguments{
\item{string}{A character vector of length 1 (a string).}

\item{encoding}{Unused.}
}
\value{
A boolean value
}
\description{
This function is used by tikzDevice to check if an incoming string contains
multibyte UTF-8 characters
}
\details{
This function searches through the characters in the given string, if any of
the characters in the string are more than one byte then the function
returns \code{TRUE} otherwise it returns \code{FALSE}.

The function will assume an input encoding of UTF-8 but will take any
specified encoding into account and will convert from the specified encoding
to UTF-8 before doing any checks
}
\examples{

# TRUE
anyMultibyteUTF8Characters('R is GNU ©, but not ®')
# FALSE
anyMultibyteUTF8Characters('R is GNU copyright but not restricted')

}
\seealso{
\code{\link[=tikz]{tikz()}}
}
\author{
Cameron Bracken \email{cameron.bracken@gmail.com}
}
\keyword{character}
