% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tikzAnnotate.R
\name{gridToDevice}
\alias{gridToDevice}
\title{Convert grid coordinates to device coordinates}
\usage{
gridToDevice(x = 0, y = 0, units = "native")
}
\arguments{
\item{x}{x coordinate.}

\item{y}{y coordinate. If no values are given for \code{x} and \code{y}, the
location of the lower-left corner of the current viewport will be
calculated.}

\item{units}{Character string indicating the units of \code{x} and \code{y}.
See the \code{\link[=unit]{unit()}} function for acceptable unit types.}
}
\value{
A tuple of coordinates in device units.
}
\description{
This function converts a coordinate pair specifying a location in a
grid \code{\link[=viewport]{viewport()}} in grid units to a coordinate pair specifying a
location in device units relative to the lower left corner of the plotting
canvas.
}
\seealso{
\code{\link[=unit]{unit()}}
\code{\link[=viewport]{viewport()}}
\code{\link[=convertX]{convertX()}}
\code{\link[=convertY]{convertY()}}
\code{\link[=current.transform]{current.transform()}}
}
\author{
Charlie Sharpsteen \email{source@sharpsteen.net}
}
\keyword{conversion}
\keyword{graphics}
\keyword{grid}
\keyword{units}
