// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from cl.xml and cl_angle_ext.xml.
//
// Copyright 2025 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_cl_autogen.cpp:
//   Capture functions for the OpenCL  entry points.

#include "libANGLE/capture/capture_cl_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationCL_autogen.h"

using namespace angle;

namespace cl
{

// CL 1.0
CallCapture CaptureGetPlatformIDs(bool isCallValid,
                                  cl_uint num_entries,
                                  cl_platform_id *platforms,
                                  cl_uint *num_platforms,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("num_entries", ParamType::Tcl_uint, num_entries);

    if (isCallValid)
    {
        ParamCapture platformsParam("platforms", ParamType::Tcl_platform_idPointer);
        InitParamValue(ParamType::Tcl_platform_idPointer, platforms, &platformsParam.value);
        CaptureGetPlatformIDs_platforms(isCallValid, num_entries, platforms, num_platforms,
                                        &platformsParam);
        paramBuffer.addParam(std::move(platformsParam));
    }
    else
    {
        ParamCapture platformsParam("platforms", ParamType::Tcl_platform_idPointer);
        InitParamValue(ParamType::Tcl_platform_idPointer, static_cast<cl_platform_id *>(nullptr),
                       &platformsParam.value);
        paramBuffer.addParam(std::move(platformsParam));
    }

    if (isCallValid)
    {
        ParamCapture num_platformsParam("num_platforms", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, num_platforms, &num_platformsParam.value);
        CaptureGetPlatformIDs_num_platforms(isCallValid, num_entries, platforms, num_platforms,
                                            &num_platformsParam);
        paramBuffer.addParam(std::move(num_platformsParam));
    }
    else
    {
        ParamCapture num_platformsParam("num_platforms", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_platformsParam.value);
        paramBuffer.addParam(std::move(num_platformsParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetPlatformIDs, std::move(paramBuffer));
}

CallCapture CaptureGetPlatformInfo(bool isCallValid,
                                   cl_platform_id platform,
                                   PlatformInfo param_namePacked,
                                   size_t param_value_size,
                                   void *param_value,
                                   size_t *param_value_size_ret,
                                   cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::Tcl_platform_id, platform);
    paramBuffer.addValueParam("param_namePacked", ParamType::TPlatformInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetPlatformInfo_param_value(isCallValid, platform, param_namePacked,
                                           param_value_size, param_value, param_value_size_ret,
                                           &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetPlatformInfo_param_value_size_ret(
            isCallValid, platform, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetPlatformInfo, std::move(paramBuffer));
}

CallCapture CaptureGetDeviceIDs(bool isCallValid,
                                cl_platform_id platform,
                                DeviceType device_typePacked,
                                cl_uint num_entries,
                                cl_device_id *devices,
                                cl_uint *num_devices,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::Tcl_platform_id, platform);
    paramBuffer.addValueParam("device_typePacked", ParamType::TDeviceType, device_typePacked);
    paramBuffer.addValueParam("num_entries", ParamType::Tcl_uint, num_entries);

    if (isCallValid)
    {
        ParamCapture devicesParam("devices", ParamType::Tcl_device_idPointer);
        InitParamValue(ParamType::Tcl_device_idPointer, devices, &devicesParam.value);
        CaptureGetDeviceIDs_devices(isCallValid, platform, device_typePacked, num_entries, devices,
                                    num_devices, &devicesParam);
        paramBuffer.addParam(std::move(devicesParam));
    }
    else
    {
        ParamCapture devicesParam("devices", ParamType::Tcl_device_idPointer);
        InitParamValue(ParamType::Tcl_device_idPointer, static_cast<cl_device_id *>(nullptr),
                       &devicesParam.value);
        paramBuffer.addParam(std::move(devicesParam));
    }

    if (isCallValid)
    {
        ParamCapture num_devicesParam("num_devices", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, num_devices, &num_devicesParam.value);
        CaptureGetDeviceIDs_num_devices(isCallValid, platform, device_typePacked, num_entries,
                                        devices, num_devices, &num_devicesParam);
        paramBuffer.addParam(std::move(num_devicesParam));
    }
    else
    {
        ParamCapture num_devicesParam("num_devices", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_devicesParam.value);
        paramBuffer.addParam(std::move(num_devicesParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetDeviceIDs, std::move(paramBuffer));
}

CallCapture CaptureGetDeviceInfo(bool isCallValid,
                                 cl_device_id device,
                                 DeviceInfo param_namePacked,
                                 size_t param_value_size,
                                 void *param_value,
                                 size_t *param_value_size_ret,
                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("param_namePacked", ParamType::TDeviceInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetDeviceInfo_param_value(isCallValid, device, param_namePacked, param_value_size,
                                         param_value, param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetDeviceInfo_param_value_size_ret(isCallValid, device, param_namePacked,
                                                  param_value_size, param_value,
                                                  param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetDeviceInfo, std::move(paramBuffer));
}

CallCapture CaptureCreateContext(bool isCallValid,
                                 const cl_context_properties *properties,
                                 cl_uint num_devices,
                                 const cl_device_id *devices,
                                 void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                               const void *private_info,
                                                               size_t cb,
                                                               void *user_data),
                                 void *user_data,
                                 cl_int *errcode_ret,
                                 cl_context returnValue)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_context_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_context_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateContext_properties(isCallValid, properties, num_devices, devices, pfn_notify,
                                        user_data, errcode_ret, &propertiesParam);
        paramBuffer.addParam(std::move(propertiesParam));
    }
    else
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_context_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_context_propertiesConstPointer,
                       static_cast<const cl_context_properties *>(nullptr), &propertiesParam.value);
        paramBuffer.addParam(std::move(propertiesParam));
    }

    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    if (isCallValid)
    {
        ParamCapture devicesParam("devices", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer, devices, &devicesParam.value);
        CaptureCreateContext_devices(isCallValid, properties, num_devices, devices, pfn_notify,
                                     user_data, errcode_ret, &devicesParam);
        paramBuffer.addParam(std::move(devicesParam));
    }
    else
    {
        ParamCapture devicesParam("devices", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &devicesParam.value);
        paramBuffer.addParam(std::move(devicesParam));
    }

    if (isCallValid)
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_context_func_type);
        InitParamValue(ParamType::Tcl_context_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureCreateContext_pfn_notify(isCallValid, properties, num_devices, devices, pfn_notify,
                                        user_data, errcode_ret, &pfn_notifyParam);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }
    else
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_context_func_type);
        InitParamValue(
            ParamType::Tcl_context_func_type,
            static_cast<void(CL_CALLBACK *)(const char *errinfo, const void *private_info,
                                            size_t cb, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }

    if (isCallValid)
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureCreateContext_user_data(isCallValid, properties, num_devices, devices, pfn_notify,
                                       user_data, errcode_ret, &user_dataParam);
        paramBuffer.addParam(std::move(user_dataParam));
    }
    else
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
        paramBuffer.addParam(std::move(user_dataParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateContext_errcode_ret(isCallValid, properties, num_devices, devices, pfn_notify,
                                         user_data, errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_context);
    InitParamValue(ParamType::Tcl_context, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateContext, std::move(paramBuffer));
}

CallCapture CaptureCreateContextFromType(bool isCallValid,
                                         const cl_context_properties *properties,
                                         DeviceType device_typePacked,
                                         void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                       const void *private_info,
                                                                       size_t cb,
                                                                       void *user_data),
                                         void *user_data,
                                         cl_int *errcode_ret,
                                         cl_context returnValue)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_context_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_context_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateContextFromType_properties(isCallValid, properties, device_typePacked,
                                                pfn_notify, user_data, errcode_ret,
                                                &propertiesParam);
        paramBuffer.addParam(std::move(propertiesParam));
    }
    else
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_context_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_context_propertiesConstPointer,
                       static_cast<const cl_context_properties *>(nullptr), &propertiesParam.value);
        paramBuffer.addParam(std::move(propertiesParam));
    }

    paramBuffer.addValueParam("device_typePacked", ParamType::TDeviceType, device_typePacked);

    if (isCallValid)
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_context_func_type);
        InitParamValue(ParamType::Tcl_context_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureCreateContextFromType_pfn_notify(isCallValid, properties, device_typePacked,
                                                pfn_notify, user_data, errcode_ret,
                                                &pfn_notifyParam);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }
    else
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_context_func_type);
        InitParamValue(
            ParamType::Tcl_context_func_type,
            static_cast<void(CL_CALLBACK *)(const char *errinfo, const void *private_info,
                                            size_t cb, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }

    if (isCallValid)
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureCreateContextFromType_user_data(isCallValid, properties, device_typePacked,
                                               pfn_notify, user_data, errcode_ret, &user_dataParam);
        paramBuffer.addParam(std::move(user_dataParam));
    }
    else
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
        paramBuffer.addParam(std::move(user_dataParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateContextFromType_errcode_ret(isCallValid, properties, device_typePacked,
                                                 pfn_notify, user_data, errcode_ret,
                                                 &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_context);
    InitParamValue(ParamType::Tcl_context, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateContextFromType, std::move(paramBuffer));
}

CallCapture CaptureRetainContext(bool isCallValid, cl_context context, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainContext, std::move(paramBuffer));
}

CallCapture CaptureReleaseContext(bool isCallValid, cl_context context, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseContext, std::move(paramBuffer));
}

CallCapture CaptureGetContextInfo(bool isCallValid,
                                  cl_context context,
                                  ContextInfo param_namePacked,
                                  size_t param_value_size,
                                  void *param_value,
                                  size_t *param_value_size_ret,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("param_namePacked", ParamType::TContextInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetContextInfo_param_value(isCallValid, context, param_namePacked, param_value_size,
                                          param_value, param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetContextInfo_param_value_size_ret(
            isCallValid, context, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetContextInfo, std::move(paramBuffer));
}

CallCapture CaptureRetainCommandQueue(bool isCallValid,
                                      cl_command_queue command_queue,
                                      cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainCommandQueue, std::move(paramBuffer));
}

CallCapture CaptureReleaseCommandQueue(bool isCallValid,
                                       cl_command_queue command_queue,
                                       cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseCommandQueue, std::move(paramBuffer));
}

CallCapture CaptureGetCommandQueueInfo(bool isCallValid,
                                       cl_command_queue command_queue,
                                       CommandQueueInfo param_namePacked,
                                       size_t param_value_size,
                                       void *param_value,
                                       size_t *param_value_size_ret,
                                       cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("param_namePacked", ParamType::TCommandQueueInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetCommandQueueInfo_param_value(isCallValid, command_queue, param_namePacked,
                                               param_value_size, param_value, param_value_size_ret,
                                               &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetCommandQueueInfo_param_value_size_ret(
            isCallValid, command_queue, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetCommandQueueInfo, std::move(paramBuffer));
}

CallCapture CaptureCreateBuffer(bool isCallValid,
                                cl_context context,
                                MemFlags flagsPacked,
                                size_t size,
                                void *host_ptr,
                                cl_int *errcode_ret,
                                cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);

    if (isCallValid)
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateBuffer_host_ptr(isCallValid, context, flagsPacked, size, host_ptr, errcode_ret,
                                     &host_ptrParam);
        paramBuffer.addParam(std::move(host_ptrParam));
    }
    else
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
        paramBuffer.addParam(std::move(host_ptrParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateBuffer_errcode_ret(isCallValid, context, flagsPacked, size, host_ptr,
                                        errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateBuffer, std::move(paramBuffer));
}

CallCapture CaptureRetainMemObject(bool isCallValid, cl_mem memobj, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memobj", ParamType::Tcl_mem, memobj);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainMemObject, std::move(paramBuffer));
}

CallCapture CaptureReleaseMemObject(bool isCallValid, cl_mem memobj, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memobj", ParamType::Tcl_mem, memobj);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseMemObject, std::move(paramBuffer));
}

CallCapture CaptureGetSupportedImageFormats(bool isCallValid,
                                            cl_context context,
                                            MemFlags flagsPacked,
                                            MemObjectType image_typePacked,
                                            cl_uint num_entries,
                                            cl_image_format *image_formats,
                                            cl_uint *num_image_formats,
                                            cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);
    paramBuffer.addValueParam("image_typePacked", ParamType::TMemObjectType, image_typePacked);
    paramBuffer.addValueParam("num_entries", ParamType::Tcl_uint, num_entries);

    if (isCallValid)
    {
        ParamCapture image_formatsParam("image_formats", ParamType::Tcl_image_formatPointer);
        InitParamValue(ParamType::Tcl_image_formatPointer, image_formats,
                       &image_formatsParam.value);
        CaptureGetSupportedImageFormats_image_formats(isCallValid, context, flagsPacked,
                                                      image_typePacked, num_entries, image_formats,
                                                      num_image_formats, &image_formatsParam);
        paramBuffer.addParam(std::move(image_formatsParam));
    }
    else
    {
        ParamCapture image_formatsParam("image_formats", ParamType::Tcl_image_formatPointer);
        InitParamValue(ParamType::Tcl_image_formatPointer, static_cast<cl_image_format *>(nullptr),
                       &image_formatsParam.value);
        paramBuffer.addParam(std::move(image_formatsParam));
    }

    if (isCallValid)
    {
        ParamCapture num_image_formatsParam("num_image_formats", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, num_image_formats,
                       &num_image_formatsParam.value);
        CaptureGetSupportedImageFormats_num_image_formats(
            isCallValid, context, flagsPacked, image_typePacked, num_entries, image_formats,
            num_image_formats, &num_image_formatsParam);
        paramBuffer.addParam(std::move(num_image_formatsParam));
    }
    else
    {
        ParamCapture num_image_formatsParam("num_image_formats", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_image_formatsParam.value);
        paramBuffer.addParam(std::move(num_image_formatsParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetSupportedImageFormats, std::move(paramBuffer));
}

CallCapture CaptureGetMemObjectInfo(bool isCallValid,
                                    cl_mem memobj,
                                    MemInfo param_namePacked,
                                    size_t param_value_size,
                                    void *param_value,
                                    size_t *param_value_size_ret,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memobj", ParamType::Tcl_mem, memobj);
    paramBuffer.addValueParam("param_namePacked", ParamType::TMemInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetMemObjectInfo_param_value(isCallValid, memobj, param_namePacked, param_value_size,
                                            param_value, param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetMemObjectInfo_param_value_size_ret(
            isCallValid, memobj, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetMemObjectInfo, std::move(paramBuffer));
}

CallCapture CaptureGetImageInfo(bool isCallValid,
                                cl_mem image,
                                ImageInfo param_namePacked,
                                size_t param_value_size,
                                void *param_value,
                                size_t *param_value_size_ret,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("image", ParamType::Tcl_mem, image);
    paramBuffer.addValueParam("param_namePacked", ParamType::TImageInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetImageInfo_param_value(isCallValid, image, param_namePacked, param_value_size,
                                        param_value, param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetImageInfo_param_value_size_ret(isCallValid, image, param_namePacked,
                                                 param_value_size, param_value,
                                                 param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetImageInfo, std::move(paramBuffer));
}

CallCapture CaptureRetainSampler(bool isCallValid, cl_sampler sampler, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::Tcl_sampler, sampler);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainSampler, std::move(paramBuffer));
}

CallCapture CaptureReleaseSampler(bool isCallValid, cl_sampler sampler, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::Tcl_sampler, sampler);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseSampler, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerInfo(bool isCallValid,
                                  cl_sampler sampler,
                                  SamplerInfo param_namePacked,
                                  size_t param_value_size,
                                  void *param_value,
                                  size_t *param_value_size_ret,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("sampler", ParamType::Tcl_sampler, sampler);
    paramBuffer.addValueParam("param_namePacked", ParamType::TSamplerInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetSamplerInfo_param_value(isCallValid, sampler, param_namePacked, param_value_size,
                                          param_value, param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetSamplerInfo_param_value_size_ret(
            isCallValid, sampler, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetSamplerInfo, std::move(paramBuffer));
}

CallCapture CaptureCreateProgramWithSource(bool isCallValid,
                                           cl_context context,
                                           cl_uint count,
                                           const char **strings,
                                           const size_t *lengths,
                                           cl_int *errcode_ret,
                                           cl_program returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("count", ParamType::Tcl_uint, count);

    if (isCallValid)
    {
        ParamCapture stringsParam("strings", ParamType::TcharConstPointerPointer);
        InitParamValue(ParamType::TcharConstPointerPointer, strings, &stringsParam.value);
        CaptureCreateProgramWithSource_strings(isCallValid, context, count, strings, lengths,
                                               errcode_ret, &stringsParam);
        paramBuffer.addParam(std::move(stringsParam));
    }
    else
    {
        ParamCapture stringsParam("strings", ParamType::TcharConstPointerPointer);
        InitParamValue(ParamType::TcharConstPointerPointer, static_cast<const char **>(nullptr),
                       &stringsParam.value);
        paramBuffer.addParam(std::move(stringsParam));
    }

    if (isCallValid)
    {
        ParamCapture lengthsParam("lengths", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, lengths, &lengthsParam.value);
        CaptureCreateProgramWithSource_lengths(isCallValid, context, count, strings, lengths,
                                               errcode_ret, &lengthsParam);
        paramBuffer.addParam(std::move(lengthsParam));
    }
    else
    {
        ParamCapture lengthsParam("lengths", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &lengthsParam.value);
        paramBuffer.addParam(std::move(lengthsParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateProgramWithSource_errcode_ret(isCallValid, context, count, strings, lengths,
                                                   errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_program);
    InitParamValue(ParamType::Tcl_program, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateProgramWithSource, std::move(paramBuffer));
}

CallCapture CaptureCreateProgramWithBinary(bool isCallValid,
                                           cl_context context,
                                           cl_uint num_devices,
                                           const cl_device_id *device_list,
                                           const size_t *lengths,
                                           const unsigned char **binaries,
                                           cl_int *binary_status,
                                           cl_int *errcode_ret,
                                           cl_program returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    if (isCallValid)
    {
        ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer, device_list, &device_listParam.value);
        CaptureCreateProgramWithBinary_device_list(isCallValid, context, num_devices, device_list,
                                                   lengths, binaries, binary_status, errcode_ret,
                                                   &device_listParam);
        paramBuffer.addParam(std::move(device_listParam));
    }
    else
    {
        ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &device_listParam.value);
        paramBuffer.addParam(std::move(device_listParam));
    }

    if (isCallValid)
    {
        ParamCapture lengthsParam("lengths", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, lengths, &lengthsParam.value);
        CaptureCreateProgramWithBinary_lengths(isCallValid, context, num_devices, device_list,
                                               lengths, binaries, binary_status, errcode_ret,
                                               &lengthsParam);
        paramBuffer.addParam(std::move(lengthsParam));
    }
    else
    {
        ParamCapture lengthsParam("lengths", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &lengthsParam.value);
        paramBuffer.addParam(std::move(lengthsParam));
    }

    if (isCallValid)
    {
        ParamCapture binariesParam("binaries", ParamType::TcharUnsignedConstPointerPointer);
        InitParamValue(ParamType::TcharUnsignedConstPointerPointer, binaries, &binariesParam.value);
        CaptureCreateProgramWithBinary_binaries(isCallValid, context, num_devices, device_list,
                                                lengths, binaries, binary_status, errcode_ret,
                                                &binariesParam);
        paramBuffer.addParam(std::move(binariesParam));
    }
    else
    {
        ParamCapture binariesParam("binaries", ParamType::TcharUnsignedConstPointerPointer);
        InitParamValue(ParamType::TcharUnsignedConstPointerPointer,
                       static_cast<const unsigned char **>(nullptr), &binariesParam.value);
        paramBuffer.addParam(std::move(binariesParam));
    }

    if (isCallValid)
    {
        ParamCapture binary_statusParam("binary_status", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, binary_status, &binary_statusParam.value);
        CaptureCreateProgramWithBinary_binary_status(isCallValid, context, num_devices, device_list,
                                                     lengths, binaries, binary_status, errcode_ret,
                                                     &binary_statusParam);
        paramBuffer.addParam(std::move(binary_statusParam));
    }
    else
    {
        ParamCapture binary_statusParam("binary_status", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &binary_statusParam.value);
        paramBuffer.addParam(std::move(binary_statusParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateProgramWithBinary_errcode_ret(isCallValid, context, num_devices, device_list,
                                                   lengths, binaries, binary_status, errcode_ret,
                                                   &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_program);
    InitParamValue(ParamType::Tcl_program, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateProgramWithBinary, std::move(paramBuffer));
}

CallCapture CaptureRetainProgram(bool isCallValid, cl_program program, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainProgram, std::move(paramBuffer));
}

CallCapture CaptureReleaseProgram(bool isCallValid, cl_program program, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseProgram, std::move(paramBuffer));
}

CallCapture CaptureBuildProgram(bool isCallValid,
                                cl_program program,
                                cl_uint num_devices,
                                const cl_device_id *device_list,
                                const char *options,
                                void(CL_CALLBACK *pfn_notify)(cl_program program, void *user_data),
                                void *user_data,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    if (isCallValid)
    {
        ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer, device_list, &device_listParam.value);
        CaptureBuildProgram_device_list(isCallValid, program, num_devices, device_list, options,
                                        pfn_notify, user_data, &device_listParam);
        paramBuffer.addParam(std::move(device_listParam));
    }
    else
    {
        ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &device_listParam.value);
        paramBuffer.addParam(std::move(device_listParam));
    }

    if (isCallValid)
    {
        ParamCapture optionsParam("options", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, options, &optionsParam.value);
        CaptureBuildProgram_options(isCallValid, program, num_devices, device_list, options,
                                    pfn_notify, user_data, &optionsParam);
        paramBuffer.addParam(std::move(optionsParam));
    }
    else
    {
        ParamCapture optionsParam("options", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &optionsParam.value);
        paramBuffer.addParam(std::move(optionsParam));
    }

    if (isCallValid)
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
        InitParamValue(ParamType::Tcl_program_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureBuildProgram_pfn_notify(isCallValid, program, num_devices, device_list, options,
                                       pfn_notify, user_data, &pfn_notifyParam);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }
    else
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
        InitParamValue(
            ParamType::Tcl_program_func_type,
            static_cast<void(CL_CALLBACK *)(cl_program program, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }

    if (isCallValid)
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureBuildProgram_user_data(isCallValid, program, num_devices, device_list, options,
                                      pfn_notify, user_data, &user_dataParam);
        paramBuffer.addParam(std::move(user_dataParam));
    }
    else
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
        paramBuffer.addParam(std::move(user_dataParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLBuildProgram, std::move(paramBuffer));
}

CallCapture CaptureGetProgramInfo(bool isCallValid,
                                  cl_program program,
                                  ProgramInfo param_namePacked,
                                  size_t param_value_size,
                                  void *param_value,
                                  size_t *param_value_size_ret,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("param_namePacked", ParamType::TProgramInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetProgramInfo_param_value(isCallValid, program, param_namePacked, param_value_size,
                                          param_value, param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetProgramInfo_param_value_size_ret(
            isCallValid, program, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetProgramInfo, std::move(paramBuffer));
}

CallCapture CaptureGetProgramBuildInfo(bool isCallValid,
                                       cl_program program,
                                       cl_device_id device,
                                       ProgramBuildInfo param_namePacked,
                                       size_t param_value_size,
                                       void *param_value,
                                       size_t *param_value_size_ret,
                                       cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("param_namePacked", ParamType::TProgramBuildInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetProgramBuildInfo_param_value(isCallValid, program, device, param_namePacked,
                                               param_value_size, param_value, param_value_size_ret,
                                               &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetProgramBuildInfo_param_value_size_ret(
            isCallValid, program, device, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetProgramBuildInfo, std::move(paramBuffer));
}

CallCapture CaptureCreateKernel(bool isCallValid,
                                cl_program program,
                                const char *kernel_name,
                                cl_int *errcode_ret,
                                cl_kernel returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);

    if (isCallValid)
    {
        ParamCapture kernel_nameParam("kernel_name", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, kernel_name, &kernel_nameParam.value);
        CaptureCreateKernel_kernel_name(isCallValid, program, kernel_name, errcode_ret,
                                        &kernel_nameParam);
        paramBuffer.addParam(std::move(kernel_nameParam));
    }
    else
    {
        ParamCapture kernel_nameParam("kernel_name", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &kernel_nameParam.value);
        paramBuffer.addParam(std::move(kernel_nameParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateKernel_errcode_ret(isCallValid, program, kernel_name, errcode_ret,
                                        &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_kernel);
    InitParamValue(ParamType::Tcl_kernel, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateKernel, std::move(paramBuffer));
}

CallCapture CaptureCreateKernelsInProgram(bool isCallValid,
                                          cl_program program,
                                          cl_uint num_kernels,
                                          cl_kernel *kernels,
                                          cl_uint *num_kernels_ret,
                                          cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("num_kernels", ParamType::Tcl_uint, num_kernels);

    if (isCallValid)
    {
        ParamCapture kernelsParam("kernels", ParamType::Tcl_kernelPointer);
        InitParamValue(ParamType::Tcl_kernelPointer, kernels, &kernelsParam.value);
        CaptureCreateKernelsInProgram_kernels(isCallValid, program, num_kernels, kernels,
                                              num_kernels_ret, &kernelsParam);
        paramBuffer.addParam(std::move(kernelsParam));
    }
    else
    {
        ParamCapture kernelsParam("kernels", ParamType::Tcl_kernelPointer);
        InitParamValue(ParamType::Tcl_kernelPointer, static_cast<cl_kernel *>(nullptr),
                       &kernelsParam.value);
        paramBuffer.addParam(std::move(kernelsParam));
    }

    if (isCallValid)
    {
        ParamCapture num_kernels_retParam("num_kernels_ret", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, num_kernels_ret, &num_kernels_retParam.value);
        CaptureCreateKernelsInProgram_num_kernels_ret(isCallValid, program, num_kernels, kernels,
                                                      num_kernels_ret, &num_kernels_retParam);
        paramBuffer.addParam(std::move(num_kernels_retParam));
    }
    else
    {
        ParamCapture num_kernels_retParam("num_kernels_ret", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_kernels_retParam.value);
        paramBuffer.addParam(std::move(num_kernels_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateKernelsInProgram, std::move(paramBuffer));
}

CallCapture CaptureRetainKernel(bool isCallValid, cl_kernel kernel, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainKernel, std::move(paramBuffer));
}

CallCapture CaptureReleaseKernel(bool isCallValid, cl_kernel kernel, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseKernel, std::move(paramBuffer));
}

CallCapture CaptureSetKernelArg(bool isCallValid,
                                cl_kernel kernel,
                                cl_uint arg_index,
                                size_t arg_size,
                                const void *arg_value,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("arg_index", ParamType::Tcl_uint, arg_index);
    paramBuffer.addValueParam("arg_size", ParamType::Tsize_t, arg_size);

    if (isCallValid)
    {
        ParamCapture arg_valueParam("arg_value", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, arg_value, &arg_valueParam.value);
        CaptureSetKernelArg_arg_value(isCallValid, kernel, arg_index, arg_size, arg_value,
                                      &arg_valueParam);
        paramBuffer.addParam(std::move(arg_valueParam));
    }
    else
    {
        ParamCapture arg_valueParam("arg_value", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &arg_valueParam.value);
        paramBuffer.addParam(std::move(arg_valueParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetKernelArg, std::move(paramBuffer));
}

CallCapture CaptureGetKernelInfo(bool isCallValid,
                                 cl_kernel kernel,
                                 KernelInfo param_namePacked,
                                 size_t param_value_size,
                                 void *param_value,
                                 size_t *param_value_size_ret,
                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("param_namePacked", ParamType::TKernelInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetKernelInfo_param_value(isCallValid, kernel, param_namePacked, param_value_size,
                                         param_value, param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetKernelInfo_param_value_size_ret(isCallValid, kernel, param_namePacked,
                                                  param_value_size, param_value,
                                                  param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetKernelInfo, std::move(paramBuffer));
}

CallCapture CaptureGetKernelWorkGroupInfo(bool isCallValid,
                                          cl_kernel kernel,
                                          cl_device_id device,
                                          KernelWorkGroupInfo param_namePacked,
                                          size_t param_value_size,
                                          void *param_value,
                                          size_t *param_value_size_ret,
                                          cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("param_namePacked", ParamType::TKernelWorkGroupInfo,
                              param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetKernelWorkGroupInfo_param_value(isCallValid, kernel, device, param_namePacked,
                                                  param_value_size, param_value,
                                                  param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetKernelWorkGroupInfo_param_value_size_ret(
            isCallValid, kernel, device, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetKernelWorkGroupInfo, std::move(paramBuffer));
}

CallCapture CaptureWaitForEvents(bool isCallValid,
                                 cl_uint num_events,
                                 const cl_event *event_list,
                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("num_events", ParamType::Tcl_uint, num_events);

    if (isCallValid)
    {
        ParamCapture event_listParam("event_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_list, &event_listParam.value);
        CaptureWaitForEvents_event_list(isCallValid, num_events, event_list, &event_listParam);
        paramBuffer.addParam(std::move(event_listParam));
    }
    else
    {
        ParamCapture event_listParam("event_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_listParam.value);
        paramBuffer.addParam(std::move(event_listParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLWaitForEvents, std::move(paramBuffer));
}

CallCapture CaptureGetEventInfo(bool isCallValid,
                                cl_event event,
                                EventInfo param_namePacked,
                                size_t param_value_size,
                                void *param_value,
                                size_t *param_value_size_ret,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);
    paramBuffer.addValueParam("param_namePacked", ParamType::TEventInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetEventInfo_param_value(isCallValid, event, param_namePacked, param_value_size,
                                        param_value, param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetEventInfo_param_value_size_ret(isCallValid, event, param_namePacked,
                                                 param_value_size, param_value,
                                                 param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetEventInfo, std::move(paramBuffer));
}

CallCapture CaptureRetainEvent(bool isCallValid, cl_event event, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainEvent, std::move(paramBuffer));
}

CallCapture CaptureReleaseEvent(bool isCallValid, cl_event event, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseEvent, std::move(paramBuffer));
}

CallCapture CaptureGetEventProfilingInfo(bool isCallValid,
                                         cl_event event,
                                         ProfilingInfo param_namePacked,
                                         size_t param_value_size,
                                         void *param_value,
                                         size_t *param_value_size_ret,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);
    paramBuffer.addValueParam("param_namePacked", ParamType::TProfilingInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetEventProfilingInfo_param_value(isCallValid, event, param_namePacked,
                                                 param_value_size, param_value,
                                                 param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetEventProfilingInfo_param_value_size_ret(
            isCallValid, event, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetEventProfilingInfo, std::move(paramBuffer));
}

CallCapture CaptureFlush(bool isCallValid, cl_command_queue command_queue, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLFlush, std::move(paramBuffer));
}

CallCapture CaptureFinish(bool isCallValid, cl_command_queue command_queue, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLFinish, std::move(paramBuffer));
}

CallCapture CaptureEnqueueReadBuffer(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem buffer,
                                     cl_bool blocking_read,
                                     size_t offset,
                                     size_t size,
                                     void *ptr,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("blocking_read", ParamType::Tcl_bool, blocking_read);
    paramBuffer.addValueParam("offset", ParamType::Tsize_t, offset);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);

    if (isCallValid)
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, ptr, &ptrParam.value);
        CaptureEnqueueReadBuffer_ptr(isCallValid, command_queue, buffer, blocking_read, offset,
                                     size, ptr, num_events_in_wait_list, event_wait_list, event,
                                     &ptrParam);
        paramBuffer.addParam(std::move(ptrParam));
    }
    else
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &ptrParam.value);
        paramBuffer.addParam(std::move(ptrParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueReadBuffer_event_wait_list(isCallValid, command_queue, buffer, blocking_read,
                                                 offset, size, ptr, num_events_in_wait_list,
                                                 event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueReadBuffer_event(isCallValid, command_queue, buffer, blocking_read, offset,
                                       size, ptr, num_events_in_wait_list, event_wait_list, event,
                                       &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueReadBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueWriteBuffer(bool isCallValid,
                                      cl_command_queue command_queue,
                                      cl_mem buffer,
                                      cl_bool blocking_write,
                                      size_t offset,
                                      size_t size,
                                      const void *ptr,
                                      cl_uint num_events_in_wait_list,
                                      const cl_event *event_wait_list,
                                      cl_event *event,
                                      cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("blocking_write", ParamType::Tcl_bool, blocking_write);
    paramBuffer.addValueParam("offset", ParamType::Tsize_t, offset);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);

    if (isCallValid)
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureEnqueueWriteBuffer_ptr(isCallValid, command_queue, buffer, blocking_write, offset,
                                      size, ptr, num_events_in_wait_list, event_wait_list, event,
                                      &ptrParam);
        paramBuffer.addParam(std::move(ptrParam));
    }
    else
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
        paramBuffer.addParam(std::move(ptrParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueWriteBuffer_event_wait_list(
            isCallValid, command_queue, buffer, blocking_write, offset, size, ptr,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueWriteBuffer_event(isCallValid, command_queue, buffer, blocking_write, offset,
                                        size, ptr, num_events_in_wait_list, event_wait_list, event,
                                        &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueWriteBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueCopyBuffer(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem src_buffer,
                                     cl_mem dst_buffer,
                                     size_t src_offset,
                                     size_t dst_offset,
                                     size_t size,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("src_buffer", ParamType::Tcl_mem, src_buffer);
    paramBuffer.addValueParam("dst_buffer", ParamType::Tcl_mem, dst_buffer);
    paramBuffer.addValueParam("src_offset", ParamType::Tsize_t, src_offset);
    paramBuffer.addValueParam("dst_offset", ParamType::Tsize_t, dst_offset);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueCopyBuffer_event_wait_list(
            isCallValid, command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueCopyBuffer_event(isCallValid, command_queue, src_buffer, dst_buffer,
                                       src_offset, dst_offset, size, num_events_in_wait_list,
                                       event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueCopyBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueReadImage(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem image,
                                    cl_bool blocking_read,
                                    const size_t *origin,
                                    const size_t *region,
                                    size_t row_pitch,
                                    size_t slice_pitch,
                                    void *ptr,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("image", ParamType::Tcl_mem, image);
    paramBuffer.addValueParam("blocking_read", ParamType::Tcl_bool, blocking_read);

    if (isCallValid)
    {
        ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, origin, &originParam.value);
        CaptureEnqueueReadImage_origin(isCallValid, command_queue, image, blocking_read, origin,
                                       region, row_pitch, slice_pitch, ptr, num_events_in_wait_list,
                                       event_wait_list, event, &originParam);
        paramBuffer.addParam(std::move(originParam));
    }
    else
    {
        ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &originParam.value);
        paramBuffer.addParam(std::move(originParam));
    }

    if (isCallValid)
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueReadImage_region(isCallValid, command_queue, image, blocking_read, origin,
                                       region, row_pitch, slice_pitch, ptr, num_events_in_wait_list,
                                       event_wait_list, event, &regionParam);
        paramBuffer.addParam(std::move(regionParam));
    }
    else
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
        paramBuffer.addParam(std::move(regionParam));
    }

    paramBuffer.addValueParam("row_pitch", ParamType::Tsize_t, row_pitch);
    paramBuffer.addValueParam("slice_pitch", ParamType::Tsize_t, slice_pitch);

    if (isCallValid)
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, ptr, &ptrParam.value);
        CaptureEnqueueReadImage_ptr(isCallValid, command_queue, image, blocking_read, origin,
                                    region, row_pitch, slice_pitch, ptr, num_events_in_wait_list,
                                    event_wait_list, event, &ptrParam);
        paramBuffer.addParam(std::move(ptrParam));
    }
    else
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &ptrParam.value);
        paramBuffer.addParam(std::move(ptrParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueReadImage_event_wait_list(isCallValid, command_queue, image, blocking_read,
                                                origin, region, row_pitch, slice_pitch, ptr,
                                                num_events_in_wait_list, event_wait_list, event,
                                                &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueReadImage_event(isCallValid, command_queue, image, blocking_read, origin,
                                      region, row_pitch, slice_pitch, ptr, num_events_in_wait_list,
                                      event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueReadImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueWriteImage(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem image,
                                     cl_bool blocking_write,
                                     const size_t *origin,
                                     const size_t *region,
                                     size_t input_row_pitch,
                                     size_t input_slice_pitch,
                                     const void *ptr,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("image", ParamType::Tcl_mem, image);
    paramBuffer.addValueParam("blocking_write", ParamType::Tcl_bool, blocking_write);

    if (isCallValid)
    {
        ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, origin, &originParam.value);
        CaptureEnqueueWriteImage_origin(
            isCallValid, command_queue, image, blocking_write, origin, region, input_row_pitch,
            input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, &originParam);
        paramBuffer.addParam(std::move(originParam));
    }
    else
    {
        ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &originParam.value);
        paramBuffer.addParam(std::move(originParam));
    }

    if (isCallValid)
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueWriteImage_region(
            isCallValid, command_queue, image, blocking_write, origin, region, input_row_pitch,
            input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, &regionParam);
        paramBuffer.addParam(std::move(regionParam));
    }
    else
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
        paramBuffer.addParam(std::move(regionParam));
    }

    paramBuffer.addValueParam("input_row_pitch", ParamType::Tsize_t, input_row_pitch);
    paramBuffer.addValueParam("input_slice_pitch", ParamType::Tsize_t, input_slice_pitch);

    if (isCallValid)
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureEnqueueWriteImage_ptr(isCallValid, command_queue, image, blocking_write, origin,
                                     region, input_row_pitch, input_slice_pitch, ptr,
                                     num_events_in_wait_list, event_wait_list, event, &ptrParam);
        paramBuffer.addParam(std::move(ptrParam));
    }
    else
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
        paramBuffer.addParam(std::move(ptrParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueWriteImage_event_wait_list(isCallValid, command_queue, image, blocking_write,
                                                 origin, region, input_row_pitch, input_slice_pitch,
                                                 ptr, num_events_in_wait_list, event_wait_list,
                                                 event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueWriteImage_event(
            isCallValid, command_queue, image, blocking_write, origin, region, input_row_pitch,
            input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueWriteImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueCopyImage(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem src_image,
                                    cl_mem dst_image,
                                    const size_t *src_origin,
                                    const size_t *dst_origin,
                                    const size_t *region,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("src_image", ParamType::Tcl_mem, src_image);
    paramBuffer.addValueParam("dst_image", ParamType::Tcl_mem, dst_image);

    if (isCallValid)
    {
        ParamCapture src_originParam("src_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, src_origin, &src_originParam.value);
        CaptureEnqueueCopyImage_src_origin(isCallValid, command_queue, src_image, dst_image,
                                           src_origin, dst_origin, region, num_events_in_wait_list,
                                           event_wait_list, event, &src_originParam);
        paramBuffer.addParam(std::move(src_originParam));
    }
    else
    {
        ParamCapture src_originParam("src_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &src_originParam.value);
        paramBuffer.addParam(std::move(src_originParam));
    }

    if (isCallValid)
    {
        ParamCapture dst_originParam("dst_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, dst_origin, &dst_originParam.value);
        CaptureEnqueueCopyImage_dst_origin(isCallValid, command_queue, src_image, dst_image,
                                           src_origin, dst_origin, region, num_events_in_wait_list,
                                           event_wait_list, event, &dst_originParam);
        paramBuffer.addParam(std::move(dst_originParam));
    }
    else
    {
        ParamCapture dst_originParam("dst_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &dst_originParam.value);
        paramBuffer.addParam(std::move(dst_originParam));
    }

    if (isCallValid)
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueCopyImage_region(isCallValid, command_queue, src_image, dst_image, src_origin,
                                       dst_origin, region, num_events_in_wait_list, event_wait_list,
                                       event, &regionParam);
        paramBuffer.addParam(std::move(regionParam));
    }
    else
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
        paramBuffer.addParam(std::move(regionParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueCopyImage_event_wait_list(
            isCallValid, command_queue, src_image, dst_image, src_origin, dst_origin, region,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueCopyImage_event(isCallValid, command_queue, src_image, dst_image, src_origin,
                                      dst_origin, region, num_events_in_wait_list, event_wait_list,
                                      event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueCopyImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueCopyImageToBuffer(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem src_image,
                                            cl_mem dst_buffer,
                                            const size_t *src_origin,
                                            const size_t *region,
                                            size_t dst_offset,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("src_image", ParamType::Tcl_mem, src_image);
    paramBuffer.addValueParam("dst_buffer", ParamType::Tcl_mem, dst_buffer);

    if (isCallValid)
    {
        ParamCapture src_originParam("src_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, src_origin, &src_originParam.value);
        CaptureEnqueueCopyImageToBuffer_src_origin(
            isCallValid, command_queue, src_image, dst_buffer, src_origin, region, dst_offset,
            num_events_in_wait_list, event_wait_list, event, &src_originParam);
        paramBuffer.addParam(std::move(src_originParam));
    }
    else
    {
        ParamCapture src_originParam("src_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &src_originParam.value);
        paramBuffer.addParam(std::move(src_originParam));
    }

    if (isCallValid)
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueCopyImageToBuffer_region(
            isCallValid, command_queue, src_image, dst_buffer, src_origin, region, dst_offset,
            num_events_in_wait_list, event_wait_list, event, &regionParam);
        paramBuffer.addParam(std::move(regionParam));
    }
    else
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
        paramBuffer.addParam(std::move(regionParam));
    }

    paramBuffer.addValueParam("dst_offset", ParamType::Tsize_t, dst_offset);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueCopyImageToBuffer_event_wait_list(
            isCallValid, command_queue, src_image, dst_buffer, src_origin, region, dst_offset,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueCopyImageToBuffer_event(
            isCallValid, command_queue, src_image, dst_buffer, src_origin, region, dst_offset,
            num_events_in_wait_list, event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueCopyImageToBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueCopyBufferToImage(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem src_buffer,
                                            cl_mem dst_image,
                                            size_t src_offset,
                                            const size_t *dst_origin,
                                            const size_t *region,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("src_buffer", ParamType::Tcl_mem, src_buffer);
    paramBuffer.addValueParam("dst_image", ParamType::Tcl_mem, dst_image);
    paramBuffer.addValueParam("src_offset", ParamType::Tsize_t, src_offset);

    if (isCallValid)
    {
        ParamCapture dst_originParam("dst_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, dst_origin, &dst_originParam.value);
        CaptureEnqueueCopyBufferToImage_dst_origin(
            isCallValid, command_queue, src_buffer, dst_image, src_offset, dst_origin, region,
            num_events_in_wait_list, event_wait_list, event, &dst_originParam);
        paramBuffer.addParam(std::move(dst_originParam));
    }
    else
    {
        ParamCapture dst_originParam("dst_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &dst_originParam.value);
        paramBuffer.addParam(std::move(dst_originParam));
    }

    if (isCallValid)
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueCopyBufferToImage_region(
            isCallValid, command_queue, src_buffer, dst_image, src_offset, dst_origin, region,
            num_events_in_wait_list, event_wait_list, event, &regionParam);
        paramBuffer.addParam(std::move(regionParam));
    }
    else
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
        paramBuffer.addParam(std::move(regionParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueCopyBufferToImage_event_wait_list(
            isCallValid, command_queue, src_buffer, dst_image, src_offset, dst_origin, region,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueCopyBufferToImage_event(
            isCallValid, command_queue, src_buffer, dst_image, src_offset, dst_origin, region,
            num_events_in_wait_list, event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueCopyBufferToImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueMapBuffer(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem buffer,
                                    cl_bool blocking_map,
                                    MapFlags map_flagsPacked,
                                    size_t offset,
                                    size_t size,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    cl_int *errcode_ret,
                                    void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("blocking_map", ParamType::Tcl_bool, blocking_map);
    paramBuffer.addValueParam("map_flagsPacked", ParamType::TMapFlags, map_flagsPacked);
    paramBuffer.addValueParam("offset", ParamType::Tsize_t, offset);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueMapBuffer_event_wait_list(
            isCallValid, command_queue, buffer, blocking_map, map_flagsPacked, offset, size,
            num_events_in_wait_list, event_wait_list, event, errcode_ret, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueMapBuffer_event(isCallValid, command_queue, buffer, blocking_map,
                                      map_flagsPacked, offset, size, num_events_in_wait_list,
                                      event_wait_list, event, errcode_ret, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureEnqueueMapBuffer_errcode_ret(isCallValid, command_queue, buffer, blocking_map,
                                            map_flagsPacked, offset, size, num_events_in_wait_list,
                                            event_wait_list, event, errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueMapBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueMapImage(bool isCallValid,
                                   cl_command_queue command_queue,
                                   cl_mem image,
                                   cl_bool blocking_map,
                                   MapFlags map_flagsPacked,
                                   const size_t *origin,
                                   const size_t *region,
                                   size_t *image_row_pitch,
                                   size_t *image_slice_pitch,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   cl_int *errcode_ret,
                                   void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("image", ParamType::Tcl_mem, image);
    paramBuffer.addValueParam("blocking_map", ParamType::Tcl_bool, blocking_map);
    paramBuffer.addValueParam("map_flagsPacked", ParamType::TMapFlags, map_flagsPacked);

    if (isCallValid)
    {
        ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, origin, &originParam.value);
        CaptureEnqueueMapImage_origin(isCallValid, command_queue, image, blocking_map,
                                      map_flagsPacked, origin, region, image_row_pitch,
                                      image_slice_pitch, num_events_in_wait_list, event_wait_list,
                                      event, errcode_ret, &originParam);
        paramBuffer.addParam(std::move(originParam));
    }
    else
    {
        ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &originParam.value);
        paramBuffer.addParam(std::move(originParam));
    }

    if (isCallValid)
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueMapImage_region(isCallValid, command_queue, image, blocking_map,
                                      map_flagsPacked, origin, region, image_row_pitch,
                                      image_slice_pitch, num_events_in_wait_list, event_wait_list,
                                      event, errcode_ret, &regionParam);
        paramBuffer.addParam(std::move(regionParam));
    }
    else
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
        paramBuffer.addParam(std::move(regionParam));
    }

    if (isCallValid)
    {
        ParamCapture image_row_pitchParam("image_row_pitch", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, image_row_pitch, &image_row_pitchParam.value);
        CaptureEnqueueMapImage_image_row_pitch(
            isCallValid, command_queue, image, blocking_map, map_flagsPacked, origin, region,
            image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event,
            errcode_ret, &image_row_pitchParam);
        paramBuffer.addParam(std::move(image_row_pitchParam));
    }
    else
    {
        ParamCapture image_row_pitchParam("image_row_pitch", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &image_row_pitchParam.value);
        paramBuffer.addParam(std::move(image_row_pitchParam));
    }

    if (isCallValid)
    {
        ParamCapture image_slice_pitchParam("image_slice_pitch", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, image_slice_pitch, &image_slice_pitchParam.value);
        CaptureEnqueueMapImage_image_slice_pitch(
            isCallValid, command_queue, image, blocking_map, map_flagsPacked, origin, region,
            image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event,
            errcode_ret, &image_slice_pitchParam);
        paramBuffer.addParam(std::move(image_slice_pitchParam));
    }
    else
    {
        ParamCapture image_slice_pitchParam("image_slice_pitch", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &image_slice_pitchParam.value);
        paramBuffer.addParam(std::move(image_slice_pitchParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueMapImage_event_wait_list(
            isCallValid, command_queue, image, blocking_map, map_flagsPacked, origin, region,
            image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event,
            errcode_ret, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueMapImage_event(isCallValid, command_queue, image, blocking_map,
                                     map_flagsPacked, origin, region, image_row_pitch,
                                     image_slice_pitch, num_events_in_wait_list, event_wait_list,
                                     event, errcode_ret, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureEnqueueMapImage_errcode_ret(isCallValid, command_queue, image, blocking_map,
                                           map_flagsPacked, origin, region, image_row_pitch,
                                           image_slice_pitch, num_events_in_wait_list,
                                           event_wait_list, event, errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueMapImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueUnmapMemObject(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_mem memobj,
                                         void *mapped_ptr,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("memobj", ParamType::Tcl_mem, memobj);

    if (isCallValid)
    {
        ParamCapture mapped_ptrParam("mapped_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, mapped_ptr, &mapped_ptrParam.value);
        CaptureEnqueueUnmapMemObject_mapped_ptr(isCallValid, command_queue, memobj, mapped_ptr,
                                                num_events_in_wait_list, event_wait_list, event,
                                                &mapped_ptrParam);
        paramBuffer.addParam(std::move(mapped_ptrParam));
    }
    else
    {
        ParamCapture mapped_ptrParam("mapped_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &mapped_ptrParam.value);
        paramBuffer.addParam(std::move(mapped_ptrParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueUnmapMemObject_event_wait_list(isCallValid, command_queue, memobj, mapped_ptr,
                                                     num_events_in_wait_list, event_wait_list,
                                                     event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueUnmapMemObject_event(isCallValid, command_queue, memobj, mapped_ptr,
                                           num_events_in_wait_list, event_wait_list, event,
                                           &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueUnmapMemObject, std::move(paramBuffer));
}

CallCapture CaptureEnqueueNDRangeKernel(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_kernel kernel,
                                        cl_uint work_dim,
                                        const size_t *global_work_offset,
                                        const size_t *global_work_size,
                                        const size_t *local_work_size,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("work_dim", ParamType::Tcl_uint, work_dim);

    if (isCallValid)
    {
        ParamCapture global_work_offsetParam("global_work_offset", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, global_work_offset,
                       &global_work_offsetParam.value);
        CaptureEnqueueNDRangeKernel_global_work_offset(
            isCallValid, command_queue, kernel, work_dim, global_work_offset, global_work_size,
            local_work_size, num_events_in_wait_list, event_wait_list, event,
            &global_work_offsetParam);
        paramBuffer.addParam(std::move(global_work_offsetParam));
    }
    else
    {
        ParamCapture global_work_offsetParam("global_work_offset", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &global_work_offsetParam.value);
        paramBuffer.addParam(std::move(global_work_offsetParam));
    }

    if (isCallValid)
    {
        ParamCapture global_work_sizeParam("global_work_size", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, global_work_size,
                       &global_work_sizeParam.value);
        CaptureEnqueueNDRangeKernel_global_work_size(
            isCallValid, command_queue, kernel, work_dim, global_work_offset, global_work_size,
            local_work_size, num_events_in_wait_list, event_wait_list, event,
            &global_work_sizeParam);
        paramBuffer.addParam(std::move(global_work_sizeParam));
    }
    else
    {
        ParamCapture global_work_sizeParam("global_work_size", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &global_work_sizeParam.value);
        paramBuffer.addParam(std::move(global_work_sizeParam));
    }

    if (isCallValid)
    {
        ParamCapture local_work_sizeParam("local_work_size", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, local_work_size,
                       &local_work_sizeParam.value);
        CaptureEnqueueNDRangeKernel_local_work_size(isCallValid, command_queue, kernel, work_dim,
                                                    global_work_offset, global_work_size,
                                                    local_work_size, num_events_in_wait_list,
                                                    event_wait_list, event, &local_work_sizeParam);
        paramBuffer.addParam(std::move(local_work_sizeParam));
    }
    else
    {
        ParamCapture local_work_sizeParam("local_work_size", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &local_work_sizeParam.value);
        paramBuffer.addParam(std::move(local_work_sizeParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueNDRangeKernel_event_wait_list(isCallValid, command_queue, kernel, work_dim,
                                                    global_work_offset, global_work_size,
                                                    local_work_size, num_events_in_wait_list,
                                                    event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueNDRangeKernel_event(
            isCallValid, command_queue, kernel, work_dim, global_work_offset, global_work_size,
            local_work_size, num_events_in_wait_list, event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueNDRangeKernel, std::move(paramBuffer));
}

CallCapture CaptureEnqueueNativeKernel(bool isCallValid,
                                       cl_command_queue command_queue,
                                       void(CL_CALLBACK *user_func)(void *),
                                       void *args,
                                       size_t cb_args,
                                       cl_uint num_mem_objects,
                                       const cl_mem *mem_list,
                                       const void **args_mem_loc,
                                       cl_uint num_events_in_wait_list,
                                       const cl_event *event_wait_list,
                                       cl_event *event,
                                       cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    if (isCallValid)
    {
        ParamCapture user_funcParam("user_func", ParamType::Tcl_void_func_type);
        InitParamValue(ParamType::Tcl_void_func_type, user_func, &user_funcParam.value);
        CaptureEnqueueNativeKernel_user_func(
            isCallValid, command_queue, user_func, args, cb_args, num_mem_objects, mem_list,
            args_mem_loc, num_events_in_wait_list, event_wait_list, event, &user_funcParam);
        paramBuffer.addParam(std::move(user_funcParam));
    }
    else
    {
        ParamCapture user_funcParam("user_func", ParamType::Tcl_void_func_type);
        InitParamValue(ParamType::Tcl_void_func_type,
                       static_cast<void(CL_CALLBACK *)(void *)>(nullptr), &user_funcParam.value);
        paramBuffer.addParam(std::move(user_funcParam));
    }

    if (isCallValid)
    {
        ParamCapture argsParam("args", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, args, &argsParam.value);
        CaptureEnqueueNativeKernel_args(
            isCallValid, command_queue, user_func, args, cb_args, num_mem_objects, mem_list,
            args_mem_loc, num_events_in_wait_list, event_wait_list, event, &argsParam);
        paramBuffer.addParam(std::move(argsParam));
    }
    else
    {
        ParamCapture argsParam("args", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &argsParam.value);
        paramBuffer.addParam(std::move(argsParam));
    }

    paramBuffer.addValueParam("cb_args", ParamType::Tsize_t, cb_args);
    paramBuffer.addValueParam("num_mem_objects", ParamType::Tcl_uint, num_mem_objects);

    if (isCallValid)
    {
        ParamCapture mem_listParam("mem_list", ParamType::Tcl_memConstPointer);
        InitParamValue(ParamType::Tcl_memConstPointer, mem_list, &mem_listParam.value);
        CaptureEnqueueNativeKernel_mem_list(
            isCallValid, command_queue, user_func, args, cb_args, num_mem_objects, mem_list,
            args_mem_loc, num_events_in_wait_list, event_wait_list, event, &mem_listParam);
        paramBuffer.addParam(std::move(mem_listParam));
    }
    else
    {
        ParamCapture mem_listParam("mem_list", ParamType::Tcl_memConstPointer);
        InitParamValue(ParamType::Tcl_memConstPointer, static_cast<const cl_mem *>(nullptr),
                       &mem_listParam.value);
        paramBuffer.addParam(std::move(mem_listParam));
    }

    if (isCallValid)
    {
        ParamCapture args_mem_locParam("args_mem_loc", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, args_mem_loc, &args_mem_locParam.value);
        CaptureEnqueueNativeKernel_args_mem_loc(
            isCallValid, command_queue, user_func, args, cb_args, num_mem_objects, mem_list,
            args_mem_loc, num_events_in_wait_list, event_wait_list, event, &args_mem_locParam);
        paramBuffer.addParam(std::move(args_mem_locParam));
    }
    else
    {
        ParamCapture args_mem_locParam("args_mem_loc", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, static_cast<const void **>(nullptr),
                       &args_mem_locParam.value);
        paramBuffer.addParam(std::move(args_mem_locParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueNativeKernel_event_wait_list(
            isCallValid, command_queue, user_func, args, cb_args, num_mem_objects, mem_list,
            args_mem_loc, num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueNativeKernel_event(
            isCallValid, command_queue, user_func, args, cb_args, num_mem_objects, mem_list,
            args_mem_loc, num_events_in_wait_list, event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueNativeKernel, std::move(paramBuffer));
}

CallCapture CaptureSetCommandQueueProperty(bool isCallValid,
                                           cl_command_queue command_queue,
                                           CommandQueueProperties propertiesPacked,
                                           cl_bool enable,
                                           cl_command_queue_properties *old_properties,
                                           cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("propertiesPacked", ParamType::TCommandQueueProperties,
                              propertiesPacked);
    paramBuffer.addValueParam("enable", ParamType::Tcl_bool, enable);

    if (isCallValid)
    {
        ParamCapture old_propertiesParam("old_properties",
                                         ParamType::Tcl_command_queue_propertiesPointer);
        InitParamValue(ParamType::Tcl_command_queue_propertiesPointer, old_properties,
                       &old_propertiesParam.value);
        CaptureSetCommandQueueProperty_old_properties(isCallValid, command_queue, propertiesPacked,
                                                      enable, old_properties, &old_propertiesParam);
        paramBuffer.addParam(std::move(old_propertiesParam));
    }
    else
    {
        ParamCapture old_propertiesParam("old_properties",
                                         ParamType::Tcl_command_queue_propertiesPointer);
        InitParamValue(ParamType::Tcl_command_queue_propertiesPointer,
                       static_cast<cl_command_queue_properties *>(nullptr),
                       &old_propertiesParam.value);
        paramBuffer.addParam(std::move(old_propertiesParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetCommandQueueProperty, std::move(paramBuffer));
}

CallCapture CaptureCreateImage2D(bool isCallValid,
                                 cl_context context,
                                 MemFlags flagsPacked,
                                 const cl_image_format *image_format,
                                 size_t image_width,
                                 size_t image_height,
                                 size_t image_row_pitch,
                                 void *host_ptr,
                                 cl_int *errcode_ret,
                                 cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);

    if (isCallValid)
    {
        ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
        InitParamValue(ParamType::Tcl_image_formatConstPointer, image_format,
                       &image_formatParam.value);
        CaptureCreateImage2D_image_format(isCallValid, context, flagsPacked, image_format,
                                          image_width, image_height, image_row_pitch, host_ptr,
                                          errcode_ret, &image_formatParam);
        paramBuffer.addParam(std::move(image_formatParam));
    }
    else
    {
        ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
        InitParamValue(ParamType::Tcl_image_formatConstPointer,
                       static_cast<const cl_image_format *>(nullptr), &image_formatParam.value);
        paramBuffer.addParam(std::move(image_formatParam));
    }

    paramBuffer.addValueParam("image_width", ParamType::Tsize_t, image_width);
    paramBuffer.addValueParam("image_height", ParamType::Tsize_t, image_height);
    paramBuffer.addValueParam("image_row_pitch", ParamType::Tsize_t, image_row_pitch);

    if (isCallValid)
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateImage2D_host_ptr(isCallValid, context, flagsPacked, image_format, image_width,
                                      image_height, image_row_pitch, host_ptr, errcode_ret,
                                      &host_ptrParam);
        paramBuffer.addParam(std::move(host_ptrParam));
    }
    else
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
        paramBuffer.addParam(std::move(host_ptrParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateImage2D_errcode_ret(isCallValid, context, flagsPacked, image_format,
                                         image_width, image_height, image_row_pitch, host_ptr,
                                         errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateImage2D, std::move(paramBuffer));
}

CallCapture CaptureCreateImage3D(bool isCallValid,
                                 cl_context context,
                                 MemFlags flagsPacked,
                                 const cl_image_format *image_format,
                                 size_t image_width,
                                 size_t image_height,
                                 size_t image_depth,
                                 size_t image_row_pitch,
                                 size_t image_slice_pitch,
                                 void *host_ptr,
                                 cl_int *errcode_ret,
                                 cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);

    if (isCallValid)
    {
        ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
        InitParamValue(ParamType::Tcl_image_formatConstPointer, image_format,
                       &image_formatParam.value);
        CaptureCreateImage3D_image_format(
            isCallValid, context, flagsPacked, image_format, image_width, image_height, image_depth,
            image_row_pitch, image_slice_pitch, host_ptr, errcode_ret, &image_formatParam);
        paramBuffer.addParam(std::move(image_formatParam));
    }
    else
    {
        ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
        InitParamValue(ParamType::Tcl_image_formatConstPointer,
                       static_cast<const cl_image_format *>(nullptr), &image_formatParam.value);
        paramBuffer.addParam(std::move(image_formatParam));
    }

    paramBuffer.addValueParam("image_width", ParamType::Tsize_t, image_width);
    paramBuffer.addValueParam("image_height", ParamType::Tsize_t, image_height);
    paramBuffer.addValueParam("image_depth", ParamType::Tsize_t, image_depth);
    paramBuffer.addValueParam("image_row_pitch", ParamType::Tsize_t, image_row_pitch);
    paramBuffer.addValueParam("image_slice_pitch", ParamType::Tsize_t, image_slice_pitch);

    if (isCallValid)
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateImage3D_host_ptr(isCallValid, context, flagsPacked, image_format, image_width,
                                      image_height, image_depth, image_row_pitch, image_slice_pitch,
                                      host_ptr, errcode_ret, &host_ptrParam);
        paramBuffer.addParam(std::move(host_ptrParam));
    }
    else
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
        paramBuffer.addParam(std::move(host_ptrParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateImage3D_errcode_ret(
            isCallValid, context, flagsPacked, image_format, image_width, image_height, image_depth,
            image_row_pitch, image_slice_pitch, host_ptr, errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateImage3D, std::move(paramBuffer));
}

CallCapture CaptureEnqueueMarker(bool isCallValid,
                                 cl_command_queue command_queue,
                                 cl_event *event,
                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueMarker_event(isCallValid, command_queue, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueMarker, std::move(paramBuffer));
}

CallCapture CaptureEnqueueWaitForEvents(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_uint num_events,
                                        const cl_event *event_list,
                                        cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_events", ParamType::Tcl_uint, num_events);

    if (isCallValid)
    {
        ParamCapture event_listParam("event_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_list, &event_listParam.value);
        CaptureEnqueueWaitForEvents_event_list(isCallValid, command_queue, num_events, event_list,
                                               &event_listParam);
        paramBuffer.addParam(std::move(event_listParam));
    }
    else
    {
        ParamCapture event_listParam("event_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_listParam.value);
        paramBuffer.addParam(std::move(event_listParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueWaitForEvents, std::move(paramBuffer));
}

CallCapture CaptureEnqueueBarrier(bool isCallValid,
                                  cl_command_queue command_queue,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueBarrier, std::move(paramBuffer));
}

CallCapture CaptureUnloadCompiler(bool isCallValid, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLUnloadCompiler, std::move(paramBuffer));
}

CallCapture CaptureGetExtensionFunctionAddress(bool isCallValid,
                                               const char *func_name,
                                               void *returnValue)
{
    ParamBuffer paramBuffer;

    if (isCallValid)
    {
        ParamCapture func_nameParam("func_name", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, func_name, &func_nameParam.value);
        CaptureGetExtensionFunctionAddress_func_name(isCallValid, func_name, &func_nameParam);
        paramBuffer.addParam(std::move(func_nameParam));
    }
    else
    {
        ParamCapture func_nameParam("func_name", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &func_nameParam.value);
        paramBuffer.addParam(std::move(func_nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetExtensionFunctionAddress, std::move(paramBuffer));
}

CallCapture CaptureCreateCommandQueue(bool isCallValid,
                                      cl_context context,
                                      cl_device_id device,
                                      CommandQueueProperties propertiesPacked,
                                      cl_int *errcode_ret,
                                      cl_command_queue returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("propertiesPacked", ParamType::TCommandQueueProperties,
                              propertiesPacked);

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateCommandQueue_errcode_ret(isCallValid, context, device, propertiesPacked,
                                              errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_command_queue);
    InitParamValue(ParamType::Tcl_command_queue, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateCommandQueue, std::move(paramBuffer));
}

CallCapture CaptureCreateSampler(bool isCallValid,
                                 cl_context context,
                                 cl_bool normalized_coords,
                                 AddressingMode addressing_modePacked,
                                 FilterMode filter_modePacked,
                                 cl_int *errcode_ret,
                                 cl_sampler returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("normalized_coords", ParamType::Tcl_bool, normalized_coords);
    paramBuffer.addValueParam("addressing_modePacked", ParamType::TAddressingMode,
                              addressing_modePacked);
    paramBuffer.addValueParam("filter_modePacked", ParamType::TFilterMode, filter_modePacked);

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateSampler_errcode_ret(isCallValid, context, normalized_coords,
                                         addressing_modePacked, filter_modePacked, errcode_ret,
                                         &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_sampler);
    InitParamValue(ParamType::Tcl_sampler, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateSampler, std::move(paramBuffer));
}

CallCapture CaptureEnqueueTask(bool isCallValid,
                               cl_command_queue command_queue,
                               cl_kernel kernel,
                               cl_uint num_events_in_wait_list,
                               const cl_event *event_wait_list,
                               cl_event *event,
                               cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueTask_event_wait_list(isCallValid, command_queue, kernel,
                                           num_events_in_wait_list, event_wait_list, event,
                                           &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueTask_event(isCallValid, command_queue, kernel, num_events_in_wait_list,
                                 event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueTask, std::move(paramBuffer));
}

// CL 1.1
CallCapture CaptureCreateSubBuffer(bool isCallValid,
                                   cl_mem buffer,
                                   MemFlags flagsPacked,
                                   cl_buffer_create_type buffer_create_type,
                                   const void *buffer_create_info,
                                   cl_int *errcode_ret,
                                   cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);
    paramBuffer.addValueParam("buffer_create_type", ParamType::Tcl_buffer_create_type,
                              buffer_create_type);

    if (isCallValid)
    {
        ParamCapture buffer_create_infoParam("buffer_create_info", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, buffer_create_info,
                       &buffer_create_infoParam.value);
        CaptureCreateSubBuffer_buffer_create_info(isCallValid, buffer, flagsPacked,
                                                  buffer_create_type, buffer_create_info,
                                                  errcode_ret, &buffer_create_infoParam);
        paramBuffer.addParam(std::move(buffer_create_infoParam));
    }
    else
    {
        ParamCapture buffer_create_infoParam("buffer_create_info", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &buffer_create_infoParam.value);
        paramBuffer.addParam(std::move(buffer_create_infoParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateSubBuffer_errcode_ret(isCallValid, buffer, flagsPacked, buffer_create_type,
                                           buffer_create_info, errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateSubBuffer, std::move(paramBuffer));
}

CallCapture CaptureSetMemObjectDestructorCallback(bool isCallValid,
                                                  cl_mem memobj,
                                                  void(CL_CALLBACK *pfn_notify)(cl_mem memobj,
                                                                                void *user_data),
                                                  void *user_data,
                                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("memobj", ParamType::Tcl_mem, memobj);

    if (isCallValid)
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_mem_destructor_func_type);
        InitParamValue(ParamType::Tcl_mem_destructor_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureSetMemObjectDestructorCallback_pfn_notify(isCallValid, memobj, pfn_notify, user_data,
                                                         &pfn_notifyParam);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }
    else
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_mem_destructor_func_type);
        InitParamValue(ParamType::Tcl_mem_destructor_func_type,
                       static_cast<void(CL_CALLBACK *)(cl_mem memobj, void *user_data)>(nullptr),
                       &pfn_notifyParam.value);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }

    if (isCallValid)
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureSetMemObjectDestructorCallback_user_data(isCallValid, memobj, pfn_notify, user_data,
                                                        &user_dataParam);
        paramBuffer.addParam(std::move(user_dataParam));
    }
    else
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
        paramBuffer.addParam(std::move(user_dataParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetMemObjectDestructorCallback, std::move(paramBuffer));
}

CallCapture CaptureCreateUserEvent(bool isCallValid,
                                   cl_context context,
                                   cl_int *errcode_ret,
                                   cl_event returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateUserEvent_errcode_ret(isCallValid, context, errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_event);
    InitParamValue(ParamType::Tcl_event, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateUserEvent, std::move(paramBuffer));
}

CallCapture CaptureSetUserEventStatus(bool isCallValid,
                                      cl_event event,
                                      cl_int execution_status,
                                      cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);
    paramBuffer.addValueParam("execution_status", ParamType::Tcl_int, execution_status);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetUserEventStatus, std::move(paramBuffer));
}

CallCapture CaptureSetEventCallback(bool isCallValid,
                                    cl_event event,
                                    cl_int command_exec_callback_type,
                                    void(CL_CALLBACK *pfn_notify)(cl_event event,
                                                                  cl_int event_command_status,
                                                                  void *user_data),
                                    void *user_data,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("event", ParamType::Tcl_event, event);
    paramBuffer.addValueParam("command_exec_callback_type", ParamType::Tcl_int,
                              command_exec_callback_type);

    if (isCallValid)
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_callback_func_type);
        InitParamValue(ParamType::Tcl_callback_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureSetEventCallback_pfn_notify(isCallValid, event, command_exec_callback_type,
                                           pfn_notify, user_data, &pfn_notifyParam);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }
    else
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_callback_func_type);
        InitParamValue(ParamType::Tcl_callback_func_type,
                       static_cast<void(CL_CALLBACK *)(cl_event event, cl_int event_command_status,
                                                       void *user_data)>(nullptr),
                       &pfn_notifyParam.value);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }

    if (isCallValid)
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureSetEventCallback_user_data(isCallValid, event, command_exec_callback_type,
                                          pfn_notify, user_data, &user_dataParam);
        paramBuffer.addParam(std::move(user_dataParam));
    }
    else
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
        paramBuffer.addParam(std::move(user_dataParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetEventCallback, std::move(paramBuffer));
}

CallCapture CaptureEnqueueReadBufferRect(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_mem buffer,
                                         cl_bool blocking_read,
                                         const size_t *buffer_origin,
                                         const size_t *host_origin,
                                         const size_t *region,
                                         size_t buffer_row_pitch,
                                         size_t buffer_slice_pitch,
                                         size_t host_row_pitch,
                                         size_t host_slice_pitch,
                                         void *ptr,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("blocking_read", ParamType::Tcl_bool, blocking_read);

    if (isCallValid)
    {
        ParamCapture buffer_originParam("buffer_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, buffer_origin, &buffer_originParam.value);
        CaptureEnqueueReadBufferRect_buffer_origin(
            isCallValid, command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &buffer_originParam);
        paramBuffer.addParam(std::move(buffer_originParam));
    }
    else
    {
        ParamCapture buffer_originParam("buffer_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &buffer_originParam.value);
        paramBuffer.addParam(std::move(buffer_originParam));
    }

    if (isCallValid)
    {
        ParamCapture host_originParam("host_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, host_origin, &host_originParam.value);
        CaptureEnqueueReadBufferRect_host_origin(
            isCallValid, command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &host_originParam);
        paramBuffer.addParam(std::move(host_originParam));
    }
    else
    {
        ParamCapture host_originParam("host_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &host_originParam.value);
        paramBuffer.addParam(std::move(host_originParam));
    }

    if (isCallValid)
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueReadBufferRect_region(
            isCallValid, command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &regionParam);
        paramBuffer.addParam(std::move(regionParam));
    }
    else
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
        paramBuffer.addParam(std::move(regionParam));
    }

    paramBuffer.addValueParam("buffer_row_pitch", ParamType::Tsize_t, buffer_row_pitch);
    paramBuffer.addValueParam("buffer_slice_pitch", ParamType::Tsize_t, buffer_slice_pitch);
    paramBuffer.addValueParam("host_row_pitch", ParamType::Tsize_t, host_row_pitch);
    paramBuffer.addValueParam("host_slice_pitch", ParamType::Tsize_t, host_slice_pitch);

    if (isCallValid)
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, ptr, &ptrParam.value);
        CaptureEnqueueReadBufferRect_ptr(
            isCallValid, command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &ptrParam);
        paramBuffer.addParam(std::move(ptrParam));
    }
    else
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &ptrParam.value);
        paramBuffer.addParam(std::move(ptrParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueReadBufferRect_event_wait_list(
            isCallValid, command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueReadBufferRect_event(
            isCallValid, command_queue, buffer, blocking_read, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueReadBufferRect, std::move(paramBuffer));
}

CallCapture CaptureEnqueueWriteBufferRect(bool isCallValid,
                                          cl_command_queue command_queue,
                                          cl_mem buffer,
                                          cl_bool blocking_write,
                                          const size_t *buffer_origin,
                                          const size_t *host_origin,
                                          const size_t *region,
                                          size_t buffer_row_pitch,
                                          size_t buffer_slice_pitch,
                                          size_t host_row_pitch,
                                          size_t host_slice_pitch,
                                          const void *ptr,
                                          cl_uint num_events_in_wait_list,
                                          const cl_event *event_wait_list,
                                          cl_event *event,
                                          cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);
    paramBuffer.addValueParam("blocking_write", ParamType::Tcl_bool, blocking_write);

    if (isCallValid)
    {
        ParamCapture buffer_originParam("buffer_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, buffer_origin, &buffer_originParam.value);
        CaptureEnqueueWriteBufferRect_buffer_origin(
            isCallValid, command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &buffer_originParam);
        paramBuffer.addParam(std::move(buffer_originParam));
    }
    else
    {
        ParamCapture buffer_originParam("buffer_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &buffer_originParam.value);
        paramBuffer.addParam(std::move(buffer_originParam));
    }

    if (isCallValid)
    {
        ParamCapture host_originParam("host_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, host_origin, &host_originParam.value);
        CaptureEnqueueWriteBufferRect_host_origin(
            isCallValid, command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &host_originParam);
        paramBuffer.addParam(std::move(host_originParam));
    }
    else
    {
        ParamCapture host_originParam("host_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &host_originParam.value);
        paramBuffer.addParam(std::move(host_originParam));
    }

    if (isCallValid)
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueWriteBufferRect_region(
            isCallValid, command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &regionParam);
        paramBuffer.addParam(std::move(regionParam));
    }
    else
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
        paramBuffer.addParam(std::move(regionParam));
    }

    paramBuffer.addValueParam("buffer_row_pitch", ParamType::Tsize_t, buffer_row_pitch);
    paramBuffer.addValueParam("buffer_slice_pitch", ParamType::Tsize_t, buffer_slice_pitch);
    paramBuffer.addValueParam("host_row_pitch", ParamType::Tsize_t, host_row_pitch);
    paramBuffer.addValueParam("host_slice_pitch", ParamType::Tsize_t, host_slice_pitch);

    if (isCallValid)
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, ptr, &ptrParam.value);
        CaptureEnqueueWriteBufferRect_ptr(
            isCallValid, command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &ptrParam);
        paramBuffer.addParam(std::move(ptrParam));
    }
    else
    {
        ParamCapture ptrParam("ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ptrParam.value);
        paramBuffer.addParam(std::move(ptrParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueWriteBufferRect_event_wait_list(
            isCallValid, command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueWriteBufferRect_event(
            isCallValid, command_queue, buffer, blocking_write, buffer_origin, host_origin, region,
            buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr,
            num_events_in_wait_list, event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueWriteBufferRect, std::move(paramBuffer));
}

CallCapture CaptureEnqueueCopyBufferRect(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_mem src_buffer,
                                         cl_mem dst_buffer,
                                         const size_t *src_origin,
                                         const size_t *dst_origin,
                                         const size_t *region,
                                         size_t src_row_pitch,
                                         size_t src_slice_pitch,
                                         size_t dst_row_pitch,
                                         size_t dst_slice_pitch,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("src_buffer", ParamType::Tcl_mem, src_buffer);
    paramBuffer.addValueParam("dst_buffer", ParamType::Tcl_mem, dst_buffer);

    if (isCallValid)
    {
        ParamCapture src_originParam("src_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, src_origin, &src_originParam.value);
        CaptureEnqueueCopyBufferRect_src_origin(
            isCallValid, command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region,
            src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list,
            event_wait_list, event, &src_originParam);
        paramBuffer.addParam(std::move(src_originParam));
    }
    else
    {
        ParamCapture src_originParam("src_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &src_originParam.value);
        paramBuffer.addParam(std::move(src_originParam));
    }

    if (isCallValid)
    {
        ParamCapture dst_originParam("dst_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, dst_origin, &dst_originParam.value);
        CaptureEnqueueCopyBufferRect_dst_origin(
            isCallValid, command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region,
            src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list,
            event_wait_list, event, &dst_originParam);
        paramBuffer.addParam(std::move(dst_originParam));
    }
    else
    {
        ParamCapture dst_originParam("dst_origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &dst_originParam.value);
        paramBuffer.addParam(std::move(dst_originParam));
    }

    if (isCallValid)
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueCopyBufferRect_region(
            isCallValid, command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region,
            src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list,
            event_wait_list, event, &regionParam);
        paramBuffer.addParam(std::move(regionParam));
    }
    else
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
        paramBuffer.addParam(std::move(regionParam));
    }

    paramBuffer.addValueParam("src_row_pitch", ParamType::Tsize_t, src_row_pitch);
    paramBuffer.addValueParam("src_slice_pitch", ParamType::Tsize_t, src_slice_pitch);
    paramBuffer.addValueParam("dst_row_pitch", ParamType::Tsize_t, dst_row_pitch);
    paramBuffer.addValueParam("dst_slice_pitch", ParamType::Tsize_t, dst_slice_pitch);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueCopyBufferRect_event_wait_list(
            isCallValid, command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region,
            src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list,
            event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueCopyBufferRect_event(
            isCallValid, command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region,
            src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list,
            event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueCopyBufferRect, std::move(paramBuffer));
}

// CL 1.2
CallCapture CaptureCreateSubDevices(bool isCallValid,
                                    cl_device_id in_device,
                                    const cl_device_partition_property *properties,
                                    cl_uint num_devices,
                                    cl_device_id *out_devices,
                                    cl_uint *num_devices_ret,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("in_device", ParamType::Tcl_device_id, in_device);

    if (isCallValid)
    {
        ParamCapture propertiesParam("properties",
                                     ParamType::Tcl_device_partition_propertyConstPointer);
        InitParamValue(ParamType::Tcl_device_partition_propertyConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateSubDevices_properties(isCallValid, in_device, properties, num_devices,
                                           out_devices, num_devices_ret, &propertiesParam);
        paramBuffer.addParam(std::move(propertiesParam));
    }
    else
    {
        ParamCapture propertiesParam("properties",
                                     ParamType::Tcl_device_partition_propertyConstPointer);
        InitParamValue(ParamType::Tcl_device_partition_propertyConstPointer,
                       static_cast<const cl_device_partition_property *>(nullptr),
                       &propertiesParam.value);
        paramBuffer.addParam(std::move(propertiesParam));
    }

    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    if (isCallValid)
    {
        ParamCapture out_devicesParam("out_devices", ParamType::Tcl_device_idPointer);
        InitParamValue(ParamType::Tcl_device_idPointer, out_devices, &out_devicesParam.value);
        CaptureCreateSubDevices_out_devices(isCallValid, in_device, properties, num_devices,
                                            out_devices, num_devices_ret, &out_devicesParam);
        paramBuffer.addParam(std::move(out_devicesParam));
    }
    else
    {
        ParamCapture out_devicesParam("out_devices", ParamType::Tcl_device_idPointer);
        InitParamValue(ParamType::Tcl_device_idPointer, static_cast<cl_device_id *>(nullptr),
                       &out_devicesParam.value);
        paramBuffer.addParam(std::move(out_devicesParam));
    }

    if (isCallValid)
    {
        ParamCapture num_devices_retParam("num_devices_ret", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, num_devices_ret, &num_devices_retParam.value);
        CaptureCreateSubDevices_num_devices_ret(isCallValid, in_device, properties, num_devices,
                                                out_devices, num_devices_ret,
                                                &num_devices_retParam);
        paramBuffer.addParam(std::move(num_devices_retParam));
    }
    else
    {
        ParamCapture num_devices_retParam("num_devices_ret", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_devices_retParam.value);
        paramBuffer.addParam(std::move(num_devices_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateSubDevices, std::move(paramBuffer));
}

CallCapture CaptureRetainDevice(bool isCallValid, cl_device_id device, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLRetainDevice, std::move(paramBuffer));
}

CallCapture CaptureReleaseDevice(bool isCallValid, cl_device_id device, cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLReleaseDevice, std::move(paramBuffer));
}

CallCapture CaptureCreateImage(bool isCallValid,
                               cl_context context,
                               MemFlags flagsPacked,
                               const cl_image_format *image_format,
                               const cl_image_desc *image_desc,
                               void *host_ptr,
                               cl_int *errcode_ret,
                               cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);

    if (isCallValid)
    {
        ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
        InitParamValue(ParamType::Tcl_image_formatConstPointer, image_format,
                       &image_formatParam.value);
        CaptureCreateImage_image_format(isCallValid, context, flagsPacked, image_format, image_desc,
                                        host_ptr, errcode_ret, &image_formatParam);
        paramBuffer.addParam(std::move(image_formatParam));
    }
    else
    {
        ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
        InitParamValue(ParamType::Tcl_image_formatConstPointer,
                       static_cast<const cl_image_format *>(nullptr), &image_formatParam.value);
        paramBuffer.addParam(std::move(image_formatParam));
    }

    if (isCallValid)
    {
        ParamCapture image_descParam("image_desc", ParamType::Tcl_image_descConstPointer);
        InitParamValue(ParamType::Tcl_image_descConstPointer, image_desc, &image_descParam.value);
        CaptureCreateImage_image_desc(isCallValid, context, flagsPacked, image_format, image_desc,
                                      host_ptr, errcode_ret, &image_descParam);
        paramBuffer.addParam(std::move(image_descParam));
    }
    else
    {
        ParamCapture image_descParam("image_desc", ParamType::Tcl_image_descConstPointer);
        InitParamValue(ParamType::Tcl_image_descConstPointer,
                       static_cast<const cl_image_desc *>(nullptr), &image_descParam.value);
        paramBuffer.addParam(std::move(image_descParam));
    }

    if (isCallValid)
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateImage_host_ptr(isCallValid, context, flagsPacked, image_format, image_desc,
                                    host_ptr, errcode_ret, &host_ptrParam);
        paramBuffer.addParam(std::move(host_ptrParam));
    }
    else
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
        paramBuffer.addParam(std::move(host_ptrParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateImage_errcode_ret(isCallValid, context, flagsPacked, image_format, image_desc,
                                       host_ptr, errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateImage, std::move(paramBuffer));
}

CallCapture CaptureCreateProgramWithBuiltInKernels(bool isCallValid,
                                                   cl_context context,
                                                   cl_uint num_devices,
                                                   const cl_device_id *device_list,
                                                   const char *kernel_names,
                                                   cl_int *errcode_ret,
                                                   cl_program returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    if (isCallValid)
    {
        ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer, device_list, &device_listParam.value);
        CaptureCreateProgramWithBuiltInKernels_device_list(isCallValid, context, num_devices,
                                                           device_list, kernel_names, errcode_ret,
                                                           &device_listParam);
        paramBuffer.addParam(std::move(device_listParam));
    }
    else
    {
        ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &device_listParam.value);
        paramBuffer.addParam(std::move(device_listParam));
    }

    if (isCallValid)
    {
        ParamCapture kernel_namesParam("kernel_names", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, kernel_names, &kernel_namesParam.value);
        CaptureCreateProgramWithBuiltInKernels_kernel_names(isCallValid, context, num_devices,
                                                            device_list, kernel_names, errcode_ret,
                                                            &kernel_namesParam);
        paramBuffer.addParam(std::move(kernel_namesParam));
    }
    else
    {
        ParamCapture kernel_namesParam("kernel_names", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &kernel_namesParam.value);
        paramBuffer.addParam(std::move(kernel_namesParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateProgramWithBuiltInKernels_errcode_ret(isCallValid, context, num_devices,
                                                           device_list, kernel_names, errcode_ret,
                                                           &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_program);
    InitParamValue(ParamType::Tcl_program, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateProgramWithBuiltInKernels,
                       std::move(paramBuffer));
}

CallCapture CaptureCompileProgram(bool isCallValid,
                                  cl_program program,
                                  cl_uint num_devices,
                                  const cl_device_id *device_list,
                                  const char *options,
                                  cl_uint num_input_headers,
                                  const cl_program *input_headers,
                                  const char **header_include_names,
                                  void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                void *user_data),
                                  void *user_data,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    if (isCallValid)
    {
        ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer, device_list, &device_listParam.value);
        CaptureCompileProgram_device_list(isCallValid, program, num_devices, device_list, options,
                                          num_input_headers, input_headers, header_include_names,
                                          pfn_notify, user_data, &device_listParam);
        paramBuffer.addParam(std::move(device_listParam));
    }
    else
    {
        ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &device_listParam.value);
        paramBuffer.addParam(std::move(device_listParam));
    }

    if (isCallValid)
    {
        ParamCapture optionsParam("options", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, options, &optionsParam.value);
        CaptureCompileProgram_options(isCallValid, program, num_devices, device_list, options,
                                      num_input_headers, input_headers, header_include_names,
                                      pfn_notify, user_data, &optionsParam);
        paramBuffer.addParam(std::move(optionsParam));
    }
    else
    {
        ParamCapture optionsParam("options", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &optionsParam.value);
        paramBuffer.addParam(std::move(optionsParam));
    }

    paramBuffer.addValueParam("num_input_headers", ParamType::Tcl_uint, num_input_headers);

    if (isCallValid)
    {
        ParamCapture input_headersParam("input_headers", ParamType::Tcl_programConstPointer);
        InitParamValue(ParamType::Tcl_programConstPointer, input_headers,
                       &input_headersParam.value);
        CaptureCompileProgram_input_headers(isCallValid, program, num_devices, device_list, options,
                                            num_input_headers, input_headers, header_include_names,
                                            pfn_notify, user_data, &input_headersParam);
        paramBuffer.addParam(std::move(input_headersParam));
    }
    else
    {
        ParamCapture input_headersParam("input_headers", ParamType::Tcl_programConstPointer);
        InitParamValue(ParamType::Tcl_programConstPointer, static_cast<const cl_program *>(nullptr),
                       &input_headersParam.value);
        paramBuffer.addParam(std::move(input_headersParam));
    }

    if (isCallValid)
    {
        ParamCapture header_include_namesParam("header_include_names",
                                               ParamType::TcharConstPointerPointer);
        InitParamValue(ParamType::TcharConstPointerPointer, header_include_names,
                       &header_include_namesParam.value);
        CaptureCompileProgram_header_include_names(
            isCallValid, program, num_devices, device_list, options, num_input_headers,
            input_headers, header_include_names, pfn_notify, user_data, &header_include_namesParam);
        paramBuffer.addParam(std::move(header_include_namesParam));
    }
    else
    {
        ParamCapture header_include_namesParam("header_include_names",
                                               ParamType::TcharConstPointerPointer);
        InitParamValue(ParamType::TcharConstPointerPointer, static_cast<const char **>(nullptr),
                       &header_include_namesParam.value);
        paramBuffer.addParam(std::move(header_include_namesParam));
    }

    if (isCallValid)
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
        InitParamValue(ParamType::Tcl_program_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureCompileProgram_pfn_notify(isCallValid, program, num_devices, device_list, options,
                                         num_input_headers, input_headers, header_include_names,
                                         pfn_notify, user_data, &pfn_notifyParam);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }
    else
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
        InitParamValue(
            ParamType::Tcl_program_func_type,
            static_cast<void(CL_CALLBACK *)(cl_program program, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }

    if (isCallValid)
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureCompileProgram_user_data(isCallValid, program, num_devices, device_list, options,
                                        num_input_headers, input_headers, header_include_names,
                                        pfn_notify, user_data, &user_dataParam);
        paramBuffer.addParam(std::move(user_dataParam));
    }
    else
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
        paramBuffer.addParam(std::move(user_dataParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCompileProgram, std::move(paramBuffer));
}

CallCapture CaptureLinkProgram(bool isCallValid,
                               cl_context context,
                               cl_uint num_devices,
                               const cl_device_id *device_list,
                               const char *options,
                               cl_uint num_input_programs,
                               const cl_program *input_programs,
                               void(CL_CALLBACK *pfn_notify)(cl_program program, void *user_data),
                               void *user_data,
                               cl_int *errcode_ret,
                               cl_program returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("num_devices", ParamType::Tcl_uint, num_devices);

    if (isCallValid)
    {
        ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer, device_list, &device_listParam.value);
        CaptureLinkProgram_device_list(isCallValid, context, num_devices, device_list, options,
                                       num_input_programs, input_programs, pfn_notify, user_data,
                                       errcode_ret, &device_listParam);
        paramBuffer.addParam(std::move(device_listParam));
    }
    else
    {
        ParamCapture device_listParam("device_list", ParamType::Tcl_device_idConstPointer);
        InitParamValue(ParamType::Tcl_device_idConstPointer,
                       static_cast<const cl_device_id *>(nullptr), &device_listParam.value);
        paramBuffer.addParam(std::move(device_listParam));
    }

    if (isCallValid)
    {
        ParamCapture optionsParam("options", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, options, &optionsParam.value);
        CaptureLinkProgram_options(isCallValid, context, num_devices, device_list, options,
                                   num_input_programs, input_programs, pfn_notify, user_data,
                                   errcode_ret, &optionsParam);
        paramBuffer.addParam(std::move(optionsParam));
    }
    else
    {
        ParamCapture optionsParam("options", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &optionsParam.value);
        paramBuffer.addParam(std::move(optionsParam));
    }

    paramBuffer.addValueParam("num_input_programs", ParamType::Tcl_uint, num_input_programs);

    if (isCallValid)
    {
        ParamCapture input_programsParam("input_programs", ParamType::Tcl_programConstPointer);
        InitParamValue(ParamType::Tcl_programConstPointer, input_programs,
                       &input_programsParam.value);
        CaptureLinkProgram_input_programs(isCallValid, context, num_devices, device_list, options,
                                          num_input_programs, input_programs, pfn_notify, user_data,
                                          errcode_ret, &input_programsParam);
        paramBuffer.addParam(std::move(input_programsParam));
    }
    else
    {
        ParamCapture input_programsParam("input_programs", ParamType::Tcl_programConstPointer);
        InitParamValue(ParamType::Tcl_programConstPointer, static_cast<const cl_program *>(nullptr),
                       &input_programsParam.value);
        paramBuffer.addParam(std::move(input_programsParam));
    }

    if (isCallValid)
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
        InitParamValue(ParamType::Tcl_program_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureLinkProgram_pfn_notify(isCallValid, context, num_devices, device_list, options,
                                      num_input_programs, input_programs, pfn_notify, user_data,
                                      errcode_ret, &pfn_notifyParam);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }
    else
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
        InitParamValue(
            ParamType::Tcl_program_func_type,
            static_cast<void(CL_CALLBACK *)(cl_program program, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }

    if (isCallValid)
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureLinkProgram_user_data(isCallValid, context, num_devices, device_list, options,
                                     num_input_programs, input_programs, pfn_notify, user_data,
                                     errcode_ret, &user_dataParam);
        paramBuffer.addParam(std::move(user_dataParam));
    }
    else
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
        paramBuffer.addParam(std::move(user_dataParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureLinkProgram_errcode_ret(isCallValid, context, num_devices, device_list, options,
                                       num_input_programs, input_programs, pfn_notify, user_data,
                                       errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_program);
    InitParamValue(ParamType::Tcl_program, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLLinkProgram, std::move(paramBuffer));
}

CallCapture CaptureUnloadPlatformCompiler(bool isCallValid,
                                          cl_platform_id platform,
                                          cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::Tcl_platform_id, platform);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLUnloadPlatformCompiler, std::move(paramBuffer));
}

CallCapture CaptureGetKernelArgInfo(bool isCallValid,
                                    cl_kernel kernel,
                                    cl_uint arg_index,
                                    KernelArgInfo param_namePacked,
                                    size_t param_value_size,
                                    void *param_value,
                                    size_t *param_value_size_ret,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("arg_index", ParamType::Tcl_uint, arg_index);
    paramBuffer.addValueParam("param_namePacked", ParamType::TKernelArgInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetKernelArgInfo_param_value(isCallValid, kernel, arg_index, param_namePacked,
                                            param_value_size, param_value, param_value_size_ret,
                                            &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetKernelArgInfo_param_value_size_ret(
            isCallValid, kernel, arg_index, param_namePacked, param_value_size, param_value,
            param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetKernelArgInfo, std::move(paramBuffer));
}

CallCapture CaptureEnqueueFillBuffer(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem buffer,
                                     const void *pattern,
                                     size_t pattern_size,
                                     size_t offset,
                                     size_t size,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("buffer", ParamType::Tcl_mem, buffer);

    if (isCallValid)
    {
        ParamCapture patternParam("pattern", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pattern, &patternParam.value);
        CaptureEnqueueFillBuffer_pattern(isCallValid, command_queue, buffer, pattern, pattern_size,
                                         offset, size, num_events_in_wait_list, event_wait_list,
                                         event, &patternParam);
        paramBuffer.addParam(std::move(patternParam));
    }
    else
    {
        ParamCapture patternParam("pattern", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &patternParam.value);
        paramBuffer.addParam(std::move(patternParam));
    }

    paramBuffer.addValueParam("pattern_size", ParamType::Tsize_t, pattern_size);
    paramBuffer.addValueParam("offset", ParamType::Tsize_t, offset);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueFillBuffer_event_wait_list(
            isCallValid, command_queue, buffer, pattern, pattern_size, offset, size,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueFillBuffer_event(isCallValid, command_queue, buffer, pattern, pattern_size,
                                       offset, size, num_events_in_wait_list, event_wait_list,
                                       event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueFillBuffer, std::move(paramBuffer));
}

CallCapture CaptureEnqueueFillImage(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem image,
                                    const void *fill_color,
                                    const size_t *origin,
                                    const size_t *region,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("image", ParamType::Tcl_mem, image);

    if (isCallValid)
    {
        ParamCapture fill_colorParam("fill_color", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, fill_color, &fill_colorParam.value);
        CaptureEnqueueFillImage_fill_color(isCallValid, command_queue, image, fill_color, origin,
                                           region, num_events_in_wait_list, event_wait_list, event,
                                           &fill_colorParam);
        paramBuffer.addParam(std::move(fill_colorParam));
    }
    else
    {
        ParamCapture fill_colorParam("fill_color", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &fill_colorParam.value);
        paramBuffer.addParam(std::move(fill_colorParam));
    }

    if (isCallValid)
    {
        ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, origin, &originParam.value);
        CaptureEnqueueFillImage_origin(isCallValid, command_queue, image, fill_color, origin,
                                       region, num_events_in_wait_list, event_wait_list, event,
                                       &originParam);
        paramBuffer.addParam(std::move(originParam));
    }
    else
    {
        ParamCapture originParam("origin", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &originParam.value);
        paramBuffer.addParam(std::move(originParam));
    }

    if (isCallValid)
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, region, &regionParam.value);
        CaptureEnqueueFillImage_region(isCallValid, command_queue, image, fill_color, origin,
                                       region, num_events_in_wait_list, event_wait_list, event,
                                       &regionParam);
        paramBuffer.addParam(std::move(regionParam));
    }
    else
    {
        ParamCapture regionParam("region", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &regionParam.value);
        paramBuffer.addParam(std::move(regionParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueFillImage_event_wait_list(isCallValid, command_queue, image, fill_color,
                                                origin, region, num_events_in_wait_list,
                                                event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueFillImage_event(isCallValid, command_queue, image, fill_color, origin, region,
                                      num_events_in_wait_list, event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueFillImage, std::move(paramBuffer));
}

CallCapture CaptureEnqueueMigrateMemObjects(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_uint num_mem_objects,
                                            const cl_mem *mem_objects,
                                            MemMigrationFlags flagsPacked,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_mem_objects", ParamType::Tcl_uint, num_mem_objects);

    if (isCallValid)
    {
        ParamCapture mem_objectsParam("mem_objects", ParamType::Tcl_memConstPointer);
        InitParamValue(ParamType::Tcl_memConstPointer, mem_objects, &mem_objectsParam.value);
        CaptureEnqueueMigrateMemObjects_mem_objects(
            isCallValid, command_queue, num_mem_objects, mem_objects, flagsPacked,
            num_events_in_wait_list, event_wait_list, event, &mem_objectsParam);
        paramBuffer.addParam(std::move(mem_objectsParam));
    }
    else
    {
        ParamCapture mem_objectsParam("mem_objects", ParamType::Tcl_memConstPointer);
        InitParamValue(ParamType::Tcl_memConstPointer, static_cast<const cl_mem *>(nullptr),
                       &mem_objectsParam.value);
        paramBuffer.addParam(std::move(mem_objectsParam));
    }

    paramBuffer.addValueParam("flagsPacked", ParamType::TMemMigrationFlags, flagsPacked);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueMigrateMemObjects_event_wait_list(
            isCallValid, command_queue, num_mem_objects, mem_objects, flagsPacked,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueMigrateMemObjects_event(isCallValid, command_queue, num_mem_objects,
                                              mem_objects, flagsPacked, num_events_in_wait_list,
                                              event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueMigrateMemObjects, std::move(paramBuffer));
}

CallCapture CaptureEnqueueMarkerWithWaitList(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueMarkerWithWaitList_event_wait_list(isCallValid, command_queue,
                                                         num_events_in_wait_list, event_wait_list,
                                                         event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueMarkerWithWaitList_event(isCallValid, command_queue, num_events_in_wait_list,
                                               event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueMarkerWithWaitList, std::move(paramBuffer));
}

CallCapture CaptureEnqueueBarrierWithWaitList(bool isCallValid,
                                              cl_command_queue command_queue,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueBarrierWithWaitList_event_wait_list(isCallValid, command_queue,
                                                          num_events_in_wait_list, event_wait_list,
                                                          event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueBarrierWithWaitList_event(isCallValid, command_queue, num_events_in_wait_list,
                                                event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueBarrierWithWaitList, std::move(paramBuffer));
}

CallCapture CaptureGetExtensionFunctionAddressForPlatform(bool isCallValid,
                                                          cl_platform_id platform,
                                                          const char *func_name,
                                                          void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::Tcl_platform_id, platform);

    if (isCallValid)
    {
        ParamCapture func_nameParam("func_name", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, func_name, &func_nameParam.value);
        CaptureGetExtensionFunctionAddressForPlatform_func_name(isCallValid, platform, func_name,
                                                                &func_nameParam);
        paramBuffer.addParam(std::move(func_nameParam));
    }
    else
    {
        ParamCapture func_nameParam("func_name", ParamType::TcharConstPointer);
        InitParamValue(ParamType::TcharConstPointer, static_cast<const char *>(nullptr),
                       &func_nameParam.value);
        paramBuffer.addParam(std::move(func_nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetExtensionFunctionAddressForPlatform,
                       std::move(paramBuffer));
}

// CL 2.0
CallCapture CaptureCreateCommandQueueWithProperties(bool isCallValid,
                                                    cl_context context,
                                                    cl_device_id device,
                                                    const cl_queue_properties *properties,
                                                    cl_int *errcode_ret,
                                                    cl_command_queue returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);

    if (isCallValid)
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_queue_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_queue_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateCommandQueueWithProperties_properties(isCallValid, context, device, properties,
                                                           errcode_ret, &propertiesParam);
        paramBuffer.addParam(std::move(propertiesParam));
    }
    else
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_queue_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_queue_propertiesConstPointer,
                       static_cast<const cl_queue_properties *>(nullptr), &propertiesParam.value);
        paramBuffer.addParam(std::move(propertiesParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateCommandQueueWithProperties_errcode_ret(
            isCallValid, context, device, properties, errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_command_queue);
    InitParamValue(ParamType::Tcl_command_queue, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateCommandQueueWithProperties,
                       std::move(paramBuffer));
}

CallCapture CaptureCreatePipe(bool isCallValid,
                              cl_context context,
                              MemFlags flagsPacked,
                              cl_uint pipe_packet_size,
                              cl_uint pipe_max_packets,
                              const cl_pipe_properties *properties,
                              cl_int *errcode_ret,
                              cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);
    paramBuffer.addValueParam("pipe_packet_size", ParamType::Tcl_uint, pipe_packet_size);
    paramBuffer.addValueParam("pipe_max_packets", ParamType::Tcl_uint, pipe_max_packets);

    if (isCallValid)
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_pipe_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_pipe_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreatePipe_properties(isCallValid, context, flagsPacked, pipe_packet_size,
                                     pipe_max_packets, properties, errcode_ret, &propertiesParam);
        paramBuffer.addParam(std::move(propertiesParam));
    }
    else
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_pipe_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_pipe_propertiesConstPointer,
                       static_cast<const cl_pipe_properties *>(nullptr), &propertiesParam.value);
        paramBuffer.addParam(std::move(propertiesParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreatePipe_errcode_ret(isCallValid, context, flagsPacked, pipe_packet_size,
                                      pipe_max_packets, properties, errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreatePipe, std::move(paramBuffer));
}

CallCapture CaptureGetPipeInfo(bool isCallValid,
                               cl_mem pipe,
                               PipeInfo param_namePacked,
                               size_t param_value_size,
                               void *param_value,
                               size_t *param_value_size_ret,
                               cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipe", ParamType::Tcl_mem, pipe);
    paramBuffer.addValueParam("param_namePacked", ParamType::TPipeInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetPipeInfo_param_value(isCallValid, pipe, param_namePacked, param_value_size,
                                       param_value, param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetPipeInfo_param_value_size_ret(isCallValid, pipe, param_namePacked,
                                                param_value_size, param_value, param_value_size_ret,
                                                &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetPipeInfo, std::move(paramBuffer));
}

CallCapture CaptureSVMAlloc(bool isCallValid,
                            cl_context context,
                            SVM_MemFlags flagsPacked,
                            size_t size,
                            cl_uint alignment,
                            void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("flagsPacked", ParamType::TSVM_MemFlags, flagsPacked);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("alignment", ParamType::Tcl_uint, alignment);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSVMAlloc, std::move(paramBuffer));
}

CallCapture CaptureSVMFree(bool isCallValid, cl_context context, void *svm_pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    if (isCallValid)
    {
        ParamCapture svm_pointerParam("svm_pointer", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, svm_pointer, &svm_pointerParam.value);
        CaptureSVMFree_svm_pointer(isCallValid, context, svm_pointer, &svm_pointerParam);
        paramBuffer.addParam(std::move(svm_pointerParam));
    }
    else
    {
        ParamCapture svm_pointerParam("svm_pointer", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &svm_pointerParam.value);
        paramBuffer.addParam(std::move(svm_pointerParam));
    }

    return CallCapture(angle::EntryPoint::CLSVMFree, std::move(paramBuffer));
}

CallCapture CaptureCreateSamplerWithProperties(bool isCallValid,
                                               cl_context context,
                                               const cl_sampler_properties *sampler_properties,
                                               cl_int *errcode_ret,
                                               cl_sampler returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    if (isCallValid)
    {
        ParamCapture sampler_propertiesParam("sampler_properties",
                                             ParamType::Tcl_sampler_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_sampler_propertiesConstPointer, sampler_properties,
                       &sampler_propertiesParam.value);
        CaptureCreateSamplerWithProperties_sampler_properties(
            isCallValid, context, sampler_properties, errcode_ret, &sampler_propertiesParam);
        paramBuffer.addParam(std::move(sampler_propertiesParam));
    }
    else
    {
        ParamCapture sampler_propertiesParam("sampler_properties",
                                             ParamType::Tcl_sampler_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_sampler_propertiesConstPointer,
                       static_cast<const cl_sampler_properties *>(nullptr),
                       &sampler_propertiesParam.value);
        paramBuffer.addParam(std::move(sampler_propertiesParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateSamplerWithProperties_errcode_ret(isCallValid, context, sampler_properties,
                                                       errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_sampler);
    InitParamValue(ParamType::Tcl_sampler, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateSamplerWithProperties, std::move(paramBuffer));
}

CallCapture CaptureSetKernelArgSVMPointer(bool isCallValid,
                                          cl_kernel kernel,
                                          cl_uint arg_index,
                                          const void *arg_value,
                                          cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("arg_index", ParamType::Tcl_uint, arg_index);

    if (isCallValid)
    {
        ParamCapture arg_valueParam("arg_value", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, arg_value, &arg_valueParam.value);
        CaptureSetKernelArgSVMPointer_arg_value(isCallValid, kernel, arg_index, arg_value,
                                                &arg_valueParam);
        paramBuffer.addParam(std::move(arg_valueParam));
    }
    else
    {
        ParamCapture arg_valueParam("arg_value", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &arg_valueParam.value);
        paramBuffer.addParam(std::move(arg_valueParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetKernelArgSVMPointer, std::move(paramBuffer));
}

CallCapture CaptureSetKernelExecInfo(bool isCallValid,
                                     cl_kernel kernel,
                                     KernelExecInfo param_namePacked,
                                     size_t param_value_size,
                                     const void *param_value,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("param_namePacked", ParamType::TKernelExecInfo, param_namePacked);
    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, param_value, &param_valueParam.value);
        CaptureSetKernelExecInfo_param_value(isCallValid, kernel, param_namePacked,
                                             param_value_size, param_value, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetKernelExecInfo, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMFree(bool isCallValid,
                                  cl_command_queue command_queue,
                                  cl_uint num_svm_pointers,
                                  void *svm_pointers[],
                                  void(CL_CALLBACK *pfn_free_func)(cl_command_queue queue,
                                                                   cl_uint num_svm_pointers,
                                                                   void *svm_pointers[],
                                                                   void *user_data),
                                  void *user_data,
                                  cl_uint num_events_in_wait_list,
                                  const cl_event *event_wait_list,
                                  cl_event *event,
                                  cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_svm_pointers", ParamType::Tcl_uint, num_svm_pointers);

    if (isCallValid)
    {
        ParamCapture svm_pointersParam("svm_pointers", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, svm_pointers, &svm_pointersParam.value);
        CaptureEnqueueSVMFree_svm_pointers(
            isCallValid, command_queue, num_svm_pointers, svm_pointers, pfn_free_func, user_data,
            num_events_in_wait_list, event_wait_list, event, &svm_pointersParam);
        paramBuffer.addParam(std::move(svm_pointersParam));
    }
    else
    {
        ParamCapture svm_pointersParam("svm_pointers", ParamType::TvoidPointerPointer);
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &svm_pointersParam.value);
        paramBuffer.addParam(std::move(svm_pointersParam));
    }

    if (isCallValid)
    {
        ParamCapture pfn_free_funcParam("pfn_free_func",
                                        ParamType::Tcl_svm_free_callback_func_type);
        InitParamValue(ParamType::Tcl_svm_free_callback_func_type, pfn_free_func,
                       &pfn_free_funcParam.value);
        CaptureEnqueueSVMFree_pfn_free_func(
            isCallValid, command_queue, num_svm_pointers, svm_pointers, pfn_free_func, user_data,
            num_events_in_wait_list, event_wait_list, event, &pfn_free_funcParam);
        paramBuffer.addParam(std::move(pfn_free_funcParam));
    }
    else
    {
        ParamCapture pfn_free_funcParam("pfn_free_func",
                                        ParamType::Tcl_svm_free_callback_func_type);
        InitParamValue(
            ParamType::Tcl_svm_free_callback_func_type,
            static_cast<void(CL_CALLBACK *)(cl_command_queue queue, cl_uint num_svm_pointers,
                                            void *svm_pointers[], void *user_data)>(nullptr),
            &pfn_free_funcParam.value);
        paramBuffer.addParam(std::move(pfn_free_funcParam));
    }

    if (isCallValid)
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureEnqueueSVMFree_user_data(isCallValid, command_queue, num_svm_pointers, svm_pointers,
                                        pfn_free_func, user_data, num_events_in_wait_list,
                                        event_wait_list, event, &user_dataParam);
        paramBuffer.addParam(std::move(user_dataParam));
    }
    else
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
        paramBuffer.addParam(std::move(user_dataParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMFree_event_wait_list(
            isCallValid, command_queue, num_svm_pointers, svm_pointers, pfn_free_func, user_data,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMFree_event(isCallValid, command_queue, num_svm_pointers, svm_pointers,
                                    pfn_free_func, user_data, num_events_in_wait_list,
                                    event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMFree, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMMemcpy(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_bool blocking_copy,
                                    void *dst_ptr,
                                    const void *src_ptr,
                                    size_t size,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("blocking_copy", ParamType::Tcl_bool, blocking_copy);

    if (isCallValid)
    {
        ParamCapture dst_ptrParam("dst_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, dst_ptr, &dst_ptrParam.value);
        CaptureEnqueueSVMMemcpy_dst_ptr(isCallValid, command_queue, blocking_copy, dst_ptr, src_ptr,
                                        size, num_events_in_wait_list, event_wait_list, event,
                                        &dst_ptrParam);
        paramBuffer.addParam(std::move(dst_ptrParam));
    }
    else
    {
        ParamCapture dst_ptrParam("dst_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &dst_ptrParam.value);
        paramBuffer.addParam(std::move(dst_ptrParam));
    }

    if (isCallValid)
    {
        ParamCapture src_ptrParam("src_ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, src_ptr, &src_ptrParam.value);
        CaptureEnqueueSVMMemcpy_src_ptr(isCallValid, command_queue, blocking_copy, dst_ptr, src_ptr,
                                        size, num_events_in_wait_list, event_wait_list, event,
                                        &src_ptrParam);
        paramBuffer.addParam(std::move(src_ptrParam));
    }
    else
    {
        ParamCapture src_ptrParam("src_ptr", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &src_ptrParam.value);
        paramBuffer.addParam(std::move(src_ptrParam));
    }

    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMMemcpy_event_wait_list(isCallValid, command_queue, blocking_copy, dst_ptr,
                                                src_ptr, size, num_events_in_wait_list,
                                                event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMMemcpy_event(isCallValid, command_queue, blocking_copy, dst_ptr, src_ptr,
                                      size, num_events_in_wait_list, event_wait_list, event,
                                      &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMMemcpy, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMMemFill(bool isCallValid,
                                     cl_command_queue command_queue,
                                     void *svm_ptr,
                                     const void *pattern,
                                     size_t pattern_size,
                                     size_t size,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    if (isCallValid)
    {
        ParamCapture svm_ptrParam("svm_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, svm_ptr, &svm_ptrParam.value);
        CaptureEnqueueSVMMemFill_svm_ptr(isCallValid, command_queue, svm_ptr, pattern, pattern_size,
                                         size, num_events_in_wait_list, event_wait_list, event,
                                         &svm_ptrParam);
        paramBuffer.addParam(std::move(svm_ptrParam));
    }
    else
    {
        ParamCapture svm_ptrParam("svm_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &svm_ptrParam.value);
        paramBuffer.addParam(std::move(svm_ptrParam));
    }

    if (isCallValid)
    {
        ParamCapture patternParam("pattern", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, pattern, &patternParam.value);
        CaptureEnqueueSVMMemFill_pattern(isCallValid, command_queue, svm_ptr, pattern, pattern_size,
                                         size, num_events_in_wait_list, event_wait_list, event,
                                         &patternParam);
        paramBuffer.addParam(std::move(patternParam));
    }
    else
    {
        ParamCapture patternParam("pattern", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &patternParam.value);
        paramBuffer.addParam(std::move(patternParam));
    }

    paramBuffer.addValueParam("pattern_size", ParamType::Tsize_t, pattern_size);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMMemFill_event_wait_list(isCallValid, command_queue, svm_ptr, pattern,
                                                 pattern_size, size, num_events_in_wait_list,
                                                 event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMMemFill_event(isCallValid, command_queue, svm_ptr, pattern, pattern_size,
                                       size, num_events_in_wait_list, event_wait_list, event,
                                       &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMMemFill, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMMap(bool isCallValid,
                                 cl_command_queue command_queue,
                                 cl_bool blocking_map,
                                 MapFlags flagsPacked,
                                 void *svm_ptr,
                                 size_t size,
                                 cl_uint num_events_in_wait_list,
                                 const cl_event *event_wait_list,
                                 cl_event *event,
                                 cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("blocking_map", ParamType::Tcl_bool, blocking_map);
    paramBuffer.addValueParam("flagsPacked", ParamType::TMapFlags, flagsPacked);

    if (isCallValid)
    {
        ParamCapture svm_ptrParam("svm_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, svm_ptr, &svm_ptrParam.value);
        CaptureEnqueueSVMMap_svm_ptr(isCallValid, command_queue, blocking_map, flagsPacked, svm_ptr,
                                     size, num_events_in_wait_list, event_wait_list, event,
                                     &svm_ptrParam);
        paramBuffer.addParam(std::move(svm_ptrParam));
    }
    else
    {
        ParamCapture svm_ptrParam("svm_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &svm_ptrParam.value);
        paramBuffer.addParam(std::move(svm_ptrParam));
    }

    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMMap_event_wait_list(isCallValid, command_queue, blocking_map, flagsPacked,
                                             svm_ptr, size, num_events_in_wait_list,
                                             event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMMap_event(isCallValid, command_queue, blocking_map, flagsPacked, svm_ptr,
                                   size, num_events_in_wait_list, event_wait_list, event,
                                   &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMMap, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMUnmap(bool isCallValid,
                                   cl_command_queue command_queue,
                                   void *svm_ptr,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    if (isCallValid)
    {
        ParamCapture svm_ptrParam("svm_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, svm_ptr, &svm_ptrParam.value);
        CaptureEnqueueSVMUnmap_svm_ptr(isCallValid, command_queue, svm_ptr, num_events_in_wait_list,
                                       event_wait_list, event, &svm_ptrParam);
        paramBuffer.addParam(std::move(svm_ptrParam));
    }
    else
    {
        ParamCapture svm_ptrParam("svm_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &svm_ptrParam.value);
        paramBuffer.addParam(std::move(svm_ptrParam));
    }

    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMUnmap_event_wait_list(isCallValid, command_queue, svm_ptr,
                                               num_events_in_wait_list, event_wait_list, event,
                                               &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMUnmap_event(isCallValid, command_queue, svm_ptr, num_events_in_wait_list,
                                     event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMUnmap, std::move(paramBuffer));
}

// CL 2.1
CallCapture CaptureSetDefaultDeviceCommandQueue(bool isCallValid,
                                                cl_context context,
                                                cl_device_id device,
                                                cl_command_queue command_queue,
                                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetDefaultDeviceCommandQueue, std::move(paramBuffer));
}

CallCapture CaptureGetDeviceAndHostTimer(bool isCallValid,
                                         cl_device_id device,
                                         cl_ulong *device_timestamp,
                                         cl_ulong *host_timestamp,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);

    if (isCallValid)
    {
        ParamCapture device_timestampParam("device_timestamp", ParamType::Tcl_ulongPointer);
        InitParamValue(ParamType::Tcl_ulongPointer, device_timestamp, &device_timestampParam.value);
        CaptureGetDeviceAndHostTimer_device_timestamp(isCallValid, device, device_timestamp,
                                                      host_timestamp, &device_timestampParam);
        paramBuffer.addParam(std::move(device_timestampParam));
    }
    else
    {
        ParamCapture device_timestampParam("device_timestamp", ParamType::Tcl_ulongPointer);
        InitParamValue(ParamType::Tcl_ulongPointer, static_cast<cl_ulong *>(nullptr),
                       &device_timestampParam.value);
        paramBuffer.addParam(std::move(device_timestampParam));
    }

    if (isCallValid)
    {
        ParamCapture host_timestampParam("host_timestamp", ParamType::Tcl_ulongPointer);
        InitParamValue(ParamType::Tcl_ulongPointer, host_timestamp, &host_timestampParam.value);
        CaptureGetDeviceAndHostTimer_host_timestamp(isCallValid, device, device_timestamp,
                                                    host_timestamp, &host_timestampParam);
        paramBuffer.addParam(std::move(host_timestampParam));
    }
    else
    {
        ParamCapture host_timestampParam("host_timestamp", ParamType::Tcl_ulongPointer);
        InitParamValue(ParamType::Tcl_ulongPointer, static_cast<cl_ulong *>(nullptr),
                       &host_timestampParam.value);
        paramBuffer.addParam(std::move(host_timestampParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetDeviceAndHostTimer, std::move(paramBuffer));
}

CallCapture CaptureGetHostTimer(bool isCallValid,
                                cl_device_id device,
                                cl_ulong *host_timestamp,
                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);

    if (isCallValid)
    {
        ParamCapture host_timestampParam("host_timestamp", ParamType::Tcl_ulongPointer);
        InitParamValue(ParamType::Tcl_ulongPointer, host_timestamp, &host_timestampParam.value);
        CaptureGetHostTimer_host_timestamp(isCallValid, device, host_timestamp,
                                           &host_timestampParam);
        paramBuffer.addParam(std::move(host_timestampParam));
    }
    else
    {
        ParamCapture host_timestampParam("host_timestamp", ParamType::Tcl_ulongPointer);
        InitParamValue(ParamType::Tcl_ulongPointer, static_cast<cl_ulong *>(nullptr),
                       &host_timestampParam.value);
        paramBuffer.addParam(std::move(host_timestampParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetHostTimer, std::move(paramBuffer));
}

CallCapture CaptureCreateProgramWithIL(bool isCallValid,
                                       cl_context context,
                                       const void *il,
                                       size_t length,
                                       cl_int *errcode_ret,
                                       cl_program returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    if (isCallValid)
    {
        ParamCapture ilParam("il", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, il, &ilParam.value);
        CaptureCreateProgramWithIL_il(isCallValid, context, il, length, errcode_ret, &ilParam);
        paramBuffer.addParam(std::move(ilParam));
    }
    else
    {
        ParamCapture ilParam("il", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &ilParam.value);
        paramBuffer.addParam(std::move(ilParam));
    }

    paramBuffer.addValueParam("length", ParamType::Tsize_t, length);

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateProgramWithIL_errcode_ret(isCallValid, context, il, length, errcode_ret,
                                               &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_program);
    InitParamValue(ParamType::Tcl_program, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateProgramWithIL, std::move(paramBuffer));
}

CallCapture CaptureCloneKernel(bool isCallValid,
                               cl_kernel source_kernel,
                               cl_int *errcode_ret,
                               cl_kernel returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("source_kernel", ParamType::Tcl_kernel, source_kernel);

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCloneKernel_errcode_ret(isCallValid, source_kernel, errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_kernel);
    InitParamValue(ParamType::Tcl_kernel, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCloneKernel, std::move(paramBuffer));
}

CallCapture CaptureGetKernelSubGroupInfo(bool isCallValid,
                                         cl_kernel kernel,
                                         cl_device_id device,
                                         KernelSubGroupInfo param_namePacked,
                                         size_t input_value_size,
                                         const void *input_value,
                                         size_t param_value_size,
                                         void *param_value,
                                         size_t *param_value_size_ret,
                                         cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("kernel", ParamType::Tcl_kernel, kernel);
    paramBuffer.addValueParam("device", ParamType::Tcl_device_id, device);
    paramBuffer.addValueParam("param_namePacked", ParamType::TKernelSubGroupInfo, param_namePacked);
    paramBuffer.addValueParam("input_value_size", ParamType::Tsize_t, input_value_size);

    if (isCallValid)
    {
        ParamCapture input_valueParam("input_value", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, input_value, &input_valueParam.value);
        CaptureGetKernelSubGroupInfo_input_value(
            isCallValid, kernel, device, param_namePacked, input_value_size, input_value,
            param_value_size, param_value, param_value_size_ret, &input_valueParam);
        paramBuffer.addParam(std::move(input_valueParam));
    }
    else
    {
        ParamCapture input_valueParam("input_value", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &input_valueParam.value);
        paramBuffer.addParam(std::move(input_valueParam));
    }

    paramBuffer.addValueParam("param_value_size", ParamType::Tsize_t, param_value_size);

    if (isCallValid)
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, param_value, &param_valueParam.value);
        CaptureGetKernelSubGroupInfo_param_value(
            isCallValid, kernel, device, param_namePacked, input_value_size, input_value,
            param_value_size, param_value, param_value_size_ret, &param_valueParam);
        paramBuffer.addParam(std::move(param_valueParam));
    }
    else
    {
        ParamCapture param_valueParam("param_value", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &param_valueParam.value);
        paramBuffer.addParam(std::move(param_valueParam));
    }

    if (isCallValid)
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, param_value_size_ret,
                       &param_value_size_retParam.value);
        CaptureGetKernelSubGroupInfo_param_value_size_ret(
            isCallValid, kernel, device, param_namePacked, input_value_size, input_value,
            param_value_size, param_value, param_value_size_ret, &param_value_size_retParam);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }
    else
    {
        ParamCapture param_value_size_retParam("param_value_size_ret", ParamType::Tsize_tPointer);
        InitParamValue(ParamType::Tsize_tPointer, static_cast<size_t *>(nullptr),
                       &param_value_size_retParam.value);
        paramBuffer.addParam(std::move(param_value_size_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLGetKernelSubGroupInfo, std::move(paramBuffer));
}

CallCapture CaptureEnqueueSVMMigrateMem(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_uint num_svm_pointers,
                                        const void **svm_pointers,
                                        const size_t *sizes,
                                        MemMigrationFlags flagsPacked,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("command_queue", ParamType::Tcl_command_queue, command_queue);
    paramBuffer.addValueParam("num_svm_pointers", ParamType::Tcl_uint, num_svm_pointers);

    if (isCallValid)
    {
        ParamCapture svm_pointersParam("svm_pointers", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, svm_pointers, &svm_pointersParam.value);
        CaptureEnqueueSVMMigrateMem_svm_pointers(
            isCallValid, command_queue, num_svm_pointers, svm_pointers, sizes, flagsPacked,
            num_events_in_wait_list, event_wait_list, event, &svm_pointersParam);
        paramBuffer.addParam(std::move(svm_pointersParam));
    }
    else
    {
        ParamCapture svm_pointersParam("svm_pointers", ParamType::TvoidConstPointerPointer);
        InitParamValue(ParamType::TvoidConstPointerPointer, static_cast<const void **>(nullptr),
                       &svm_pointersParam.value);
        paramBuffer.addParam(std::move(svm_pointersParam));
    }

    if (isCallValid)
    {
        ParamCapture sizesParam("sizes", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, sizes, &sizesParam.value);
        CaptureEnqueueSVMMigrateMem_sizes(isCallValid, command_queue, num_svm_pointers,
                                          svm_pointers, sizes, flagsPacked, num_events_in_wait_list,
                                          event_wait_list, event, &sizesParam);
        paramBuffer.addParam(std::move(sizesParam));
    }
    else
    {
        ParamCapture sizesParam("sizes", ParamType::Tsize_tConstPointer);
        InitParamValue(ParamType::Tsize_tConstPointer, static_cast<const size_t *>(nullptr),
                       &sizesParam.value);
        paramBuffer.addParam(std::move(sizesParam));
    }

    paramBuffer.addValueParam("flagsPacked", ParamType::TMemMigrationFlags, flagsPacked);
    paramBuffer.addValueParam("num_events_in_wait_list", ParamType::Tcl_uint,
                              num_events_in_wait_list);

    if (isCallValid)
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, event_wait_list,
                       &event_wait_listParam.value);
        CaptureEnqueueSVMMigrateMem_event_wait_list(
            isCallValid, command_queue, num_svm_pointers, svm_pointers, sizes, flagsPacked,
            num_events_in_wait_list, event_wait_list, event, &event_wait_listParam);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }
    else
    {
        ParamCapture event_wait_listParam("event_wait_list", ParamType::Tcl_eventConstPointer);
        InitParamValue(ParamType::Tcl_eventConstPointer, static_cast<const cl_event *>(nullptr),
                       &event_wait_listParam.value);
        paramBuffer.addParam(std::move(event_wait_listParam));
    }

    if (isCallValid)
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, event, &eventParam.value);
        CaptureEnqueueSVMMigrateMem_event(isCallValid, command_queue, num_svm_pointers,
                                          svm_pointers, sizes, flagsPacked, num_events_in_wait_list,
                                          event_wait_list, event, &eventParam);
        paramBuffer.addParam(std::move(eventParam));
    }
    else
    {
        ParamCapture eventParam("event", ParamType::Tcl_eventPointer);
        InitParamValue(ParamType::Tcl_eventPointer, static_cast<cl_event *>(nullptr),
                       &eventParam.value);
        paramBuffer.addParam(std::move(eventParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLEnqueueSVMMigrateMem, std::move(paramBuffer));
}

// CL 2.2
CallCapture CaptureSetProgramReleaseCallback(bool isCallValid,
                                             cl_program program,
                                             void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                           void *user_data),
                                             void *user_data,
                                             cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);

    if (isCallValid)
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
        InitParamValue(ParamType::Tcl_program_func_type, pfn_notify, &pfn_notifyParam.value);
        CaptureSetProgramReleaseCallback_pfn_notify(isCallValid, program, pfn_notify, user_data,
                                                    &pfn_notifyParam);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }
    else
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_program_func_type);
        InitParamValue(
            ParamType::Tcl_program_func_type,
            static_cast<void(CL_CALLBACK *)(cl_program program, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }

    if (isCallValid)
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureSetProgramReleaseCallback_user_data(isCallValid, program, pfn_notify, user_data,
                                                   &user_dataParam);
        paramBuffer.addParam(std::move(user_dataParam));
    }
    else
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
        paramBuffer.addParam(std::move(user_dataParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetProgramReleaseCallback, std::move(paramBuffer));
}

CallCapture CaptureSetProgramSpecializationConstant(bool isCallValid,
                                                    cl_program program,
                                                    cl_uint spec_id,
                                                    size_t spec_size,
                                                    const void *spec_value,
                                                    cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("program", ParamType::Tcl_program, program);
    paramBuffer.addValueParam("spec_id", ParamType::Tcl_uint, spec_id);
    paramBuffer.addValueParam("spec_size", ParamType::Tsize_t, spec_size);

    if (isCallValid)
    {
        ParamCapture spec_valueParam("spec_value", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, spec_value, &spec_valueParam.value);
        CaptureSetProgramSpecializationConstant_spec_value(isCallValid, program, spec_id, spec_size,
                                                           spec_value, &spec_valueParam);
        paramBuffer.addParam(std::move(spec_valueParam));
    }
    else
    {
        ParamCapture spec_valueParam("spec_value", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &spec_valueParam.value);
        paramBuffer.addParam(std::move(spec_valueParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetProgramSpecializationConstant,
                       std::move(paramBuffer));
}

// CL 3.0
CallCapture CaptureSetContextDestructorCallback(bool isCallValid,
                                                cl_context context,
                                                void(CL_CALLBACK *pfn_notify)(cl_context context,
                                                                              void *user_data),
                                                void *user_data,
                                                cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    if (isCallValid)
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_context_destructor_func_type);
        InitParamValue(ParamType::Tcl_context_destructor_func_type, pfn_notify,
                       &pfn_notifyParam.value);
        CaptureSetContextDestructorCallback_pfn_notify(isCallValid, context, pfn_notify, user_data,
                                                       &pfn_notifyParam);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }
    else
    {
        ParamCapture pfn_notifyParam("pfn_notify", ParamType::Tcl_context_destructor_func_type);
        InitParamValue(
            ParamType::Tcl_context_destructor_func_type,
            static_cast<void(CL_CALLBACK *)(cl_context context, void *user_data)>(nullptr),
            &pfn_notifyParam.value);
        paramBuffer.addParam(std::move(pfn_notifyParam));
    }

    if (isCallValid)
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, user_data, &user_dataParam.value);
        CaptureSetContextDestructorCallback_user_data(isCallValid, context, pfn_notify, user_data,
                                                      &user_dataParam);
        paramBuffer.addParam(std::move(user_dataParam));
    }
    else
    {
        ParamCapture user_dataParam("user_data", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr),
                       &user_dataParam.value);
        paramBuffer.addParam(std::move(user_dataParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLSetContextDestructorCallback, std::move(paramBuffer));
}

CallCapture CaptureCreateBufferWithProperties(bool isCallValid,
                                              cl_context context,
                                              const cl_mem_properties *properties,
                                              MemFlags flagsPacked,
                                              size_t size,
                                              void *host_ptr,
                                              cl_int *errcode_ret,
                                              cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    if (isCallValid)
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_mem_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_mem_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateBufferWithProperties_properties(isCallValid, context, properties, flagsPacked,
                                                     size, host_ptr, errcode_ret, &propertiesParam);
        paramBuffer.addParam(std::move(propertiesParam));
    }
    else
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_mem_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_mem_propertiesConstPointer,
                       static_cast<const cl_mem_properties *>(nullptr), &propertiesParam.value);
        paramBuffer.addParam(std::move(propertiesParam));
    }

    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);
    paramBuffer.addValueParam("size", ParamType::Tsize_t, size);

    if (isCallValid)
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateBufferWithProperties_host_ptr(isCallValid, context, properties, flagsPacked,
                                                   size, host_ptr, errcode_ret, &host_ptrParam);
        paramBuffer.addParam(std::move(host_ptrParam));
    }
    else
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
        paramBuffer.addParam(std::move(host_ptrParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateBufferWithProperties_errcode_ret(isCallValid, context, properties, flagsPacked,
                                                      size, host_ptr, errcode_ret,
                                                      &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateBufferWithProperties, std::move(paramBuffer));
}

CallCapture CaptureCreateImageWithProperties(bool isCallValid,
                                             cl_context context,
                                             const cl_mem_properties *properties,
                                             MemFlags flagsPacked,
                                             const cl_image_format *image_format,
                                             const cl_image_desc *image_desc,
                                             void *host_ptr,
                                             cl_int *errcode_ret,
                                             cl_mem returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("context", ParamType::Tcl_context, context);

    if (isCallValid)
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_mem_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_mem_propertiesConstPointer, properties,
                       &propertiesParam.value);
        CaptureCreateImageWithProperties_properties(isCallValid, context, properties, flagsPacked,
                                                    image_format, image_desc, host_ptr, errcode_ret,
                                                    &propertiesParam);
        paramBuffer.addParam(std::move(propertiesParam));
    }
    else
    {
        ParamCapture propertiesParam("properties", ParamType::Tcl_mem_propertiesConstPointer);
        InitParamValue(ParamType::Tcl_mem_propertiesConstPointer,
                       static_cast<const cl_mem_properties *>(nullptr), &propertiesParam.value);
        paramBuffer.addParam(std::move(propertiesParam));
    }

    paramBuffer.addValueParam("flagsPacked", ParamType::TMemFlags, flagsPacked);

    if (isCallValid)
    {
        ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
        InitParamValue(ParamType::Tcl_image_formatConstPointer, image_format,
                       &image_formatParam.value);
        CaptureCreateImageWithProperties_image_format(isCallValid, context, properties, flagsPacked,
                                                      image_format, image_desc, host_ptr,
                                                      errcode_ret, &image_formatParam);
        paramBuffer.addParam(std::move(image_formatParam));
    }
    else
    {
        ParamCapture image_formatParam("image_format", ParamType::Tcl_image_formatConstPointer);
        InitParamValue(ParamType::Tcl_image_formatConstPointer,
                       static_cast<const cl_image_format *>(nullptr), &image_formatParam.value);
        paramBuffer.addParam(std::move(image_formatParam));
    }

    if (isCallValid)
    {
        ParamCapture image_descParam("image_desc", ParamType::Tcl_image_descConstPointer);
        InitParamValue(ParamType::Tcl_image_descConstPointer, image_desc, &image_descParam.value);
        CaptureCreateImageWithProperties_image_desc(isCallValid, context, properties, flagsPacked,
                                                    image_format, image_desc, host_ptr, errcode_ret,
                                                    &image_descParam);
        paramBuffer.addParam(std::move(image_descParam));
    }
    else
    {
        ParamCapture image_descParam("image_desc", ParamType::Tcl_image_descConstPointer);
        InitParamValue(ParamType::Tcl_image_descConstPointer,
                       static_cast<const cl_image_desc *>(nullptr), &image_descParam.value);
        paramBuffer.addParam(std::move(image_descParam));
    }

    if (isCallValid)
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, host_ptr, &host_ptrParam.value);
        CaptureCreateImageWithProperties_host_ptr(isCallValid, context, properties, flagsPacked,
                                                  image_format, image_desc, host_ptr, errcode_ret,
                                                  &host_ptrParam);
        paramBuffer.addParam(std::move(host_ptrParam));
    }
    else
    {
        ParamCapture host_ptrParam("host_ptr", ParamType::TvoidPointer);
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &host_ptrParam.value);
        paramBuffer.addParam(std::move(host_ptrParam));
    }

    if (isCallValid)
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, errcode_ret, &errcode_retParam.value);
        CaptureCreateImageWithProperties_errcode_ret(isCallValid, context, properties, flagsPacked,
                                                     image_format, image_desc, host_ptr,
                                                     errcode_ret, &errcode_retParam);
        paramBuffer.addParam(std::move(errcode_retParam));
    }
    else
    {
        ParamCapture errcode_retParam("errcode_ret", ParamType::Tcl_intPointer);
        InitParamValue(ParamType::Tcl_intPointer, static_cast<cl_int *>(nullptr),
                       &errcode_retParam.value);
        paramBuffer.addParam(std::move(errcode_retParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_mem);
    InitParamValue(ParamType::Tcl_mem, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLCreateImageWithProperties, std::move(paramBuffer));
}

// cl_khr_icd
CallCapture CaptureIcdGetPlatformIDsKHR(bool isCallValid,
                                        cl_uint num_entries,
                                        cl_platform_id *platforms,
                                        cl_uint *num_platforms,
                                        cl_int returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("num_entries", ParamType::Tcl_uint, num_entries);

    if (isCallValid)
    {
        ParamCapture platformsParam("platforms", ParamType::Tcl_platform_idPointer);
        InitParamValue(ParamType::Tcl_platform_idPointer, platforms, &platformsParam.value);
        CaptureIcdGetPlatformIDsKHR_platforms(isCallValid, num_entries, platforms, num_platforms,
                                              &platformsParam);
        paramBuffer.addParam(std::move(platformsParam));
    }
    else
    {
        ParamCapture platformsParam("platforms", ParamType::Tcl_platform_idPointer);
        InitParamValue(ParamType::Tcl_platform_idPointer, static_cast<cl_platform_id *>(nullptr),
                       &platformsParam.value);
        paramBuffer.addParam(std::move(platformsParam));
    }

    if (isCallValid)
    {
        ParamCapture num_platformsParam("num_platforms", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, num_platforms, &num_platformsParam.value);
        CaptureIcdGetPlatformIDsKHR_num_platforms(isCallValid, num_entries, platforms,
                                                  num_platforms, &num_platformsParam);
        paramBuffer.addParam(std::move(num_platformsParam));
    }
    else
    {
        ParamCapture num_platformsParam("num_platforms", ParamType::Tcl_uintPointer);
        InitParamValue(ParamType::Tcl_uintPointer, static_cast<cl_uint *>(nullptr),
                       &num_platformsParam.value);
        paramBuffer.addParam(std::move(num_platformsParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::Tcl_int);
    InitParamValue(ParamType::Tcl_int, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::CLIcdGetPlatformIDsKHR, std::move(paramBuffer));
}

}  // namespace cl
