use wolfssl::wolfcrypt::prf::*;

#[test]
fn test_kdf_prf() {
    let secret = [0x10u8, 0xbc, 0xb4, 0xa2, 0xe8, 0xdc, 0xf1, 0x9b, 0x4c,
        0x51, 0x9c, 0xed, 0x31, 0x1b, 0x51, 0x57, 0x02, 0x3f,
        0xa1, 0x7d, 0xfb, 0x0e, 0xf3, 0x4e, 0x8f, 0x6f, 0x71,
        0xa3, 0x67, 0x76, 0x6b, 0xfa, 0x5d, 0x46, 0x4a, 0xe8,
        0x61, 0x18, 0x81, 0xc4, 0x66, 0xcc, 0x6f, 0x09, 0x99,
        0x9d, 0xfc, 0x47];

    let seed = [0x73u8, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x66, 0x69,
        0x6e, 0x69, 0x73, 0x68, 0x65, 0x64, 0x0b, 0x46, 0xba,
        0x56, 0xbf, 0x1f, 0x5d, 0x99, 0xff, 0xe9, 0xbb, 0x43,
        0x01, 0xe7, 0xca, 0x2c, 0x00, 0xdf, 0x9a, 0x39, 0x6e,
        0xcf, 0x6d, 0x15, 0x27, 0x4d, 0xf2, 0x93, 0x96, 0x4a,
        0x91, 0xde, 0x5c, 0xc0, 0x47, 0x7c, 0xa8, 0xae, 0xcf,
        0x5d, 0x93, 0x5f, 0x4c, 0x92, 0xcc, 0x98, 0x5b, 0x43];

    let expected = [0xeeu8, 0xcb, 0xb1, 0x30, 0xf2, 0xcd, 0xb3, 0x4a,
        0xbe, 0xda, 0xc1, 0xf6];

    let mut out = [0u8; 12];

    prf(&secret, &seed, PRF_HASH_SHA384, &mut out).expect("Error with prf()");

    assert_eq!(out, expected);
}
