# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIDotNetComponentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dot_net_components_list(self, resource_group):
        response = self.client.dot_net_components.list(
            resource_group_name=resource_group.name,
            environment_name="str",
            api_version="2025-02-02-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dot_net_components_get(self, resource_group):
        response = self.client.dot_net_components.get(
            resource_group_name=resource_group.name,
            environment_name="str",
            name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dot_net_components_begin_create_or_update(self, resource_group):
        response = self.client.dot_net_components.begin_create_or_update(
            resource_group_name=resource_group.name,
            environment_name="str",
            name="str",
            dot_net_component_envelope={
                "componentType": "str",
                "configurations": [{"propertyName": "str", "value": "str"}],
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "serviceBinds": [{"name": "str", "serviceId": "str"}],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-02-02-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dot_net_components_begin_update(self, resource_group):
        response = self.client.dot_net_components.begin_update(
            resource_group_name=resource_group.name,
            environment_name="str",
            name="str",
            dot_net_component_envelope={
                "componentType": "str",
                "configurations": [{"propertyName": "str", "value": "str"}],
                "id": "str",
                "name": "str",
                "provisioningState": "str",
                "serviceBinds": [{"name": "str", "serviceId": "str"}],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-02-02-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dot_net_components_begin_delete(self, resource_group):
        response = self.client.dot_net_components.begin_delete(
            resource_group_name=resource_group.name,
            environment_name="str",
            name="str",
            api_version="2025-02-02-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
