#!/bin/sh

set -e

LOGS=$1

# Prevent looping in case of failure
if [ -e /run/user/$UID/libc6-restarted ]; then
    exit 1;
fi
touch /run/user/$UID/libc6-restarted

DEBIAN_FRONTEND=noninteractive apt-get reinstall -y libc6 > $LOGS 2>&1

# Let time pass to be sure that the systemd job queue has the time to
# interrupt us before we mark the test as successful.
sleep 60
touch /run/user/$UID/libc6-restarted

