#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2015 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Infinity Engine games:
# - Baldur's Gate
# - Baldur's Gate 2
# - Icewind Dale
# - Icewind Dale 2
# - Planescape: Torment
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251112.5

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID_BG1='baldurs-gate-1'
GAME_NAME_BG1='Baldurʼs Gate'

GAME_ID_BG2='baldurs-gate-2'
GAME_NAME_BG2='Baldurʼs Gate II'

GAME_ID_IWD1='icewind-dale-1'
GAME_NAME_IWD1='Icewind Dale'

GAME_ID_IWD2='icewind-dale-2'
GAME_NAME_IWD2='Icewind Dale II'

GAME_ID_PST='planescape-torment'
GAME_NAME_PST='Planescape: Torment'

## Baldur's Gate

ARCHIVE_BASE_BG1_DE_1_NAME='baldur_s_gate_the_original_saga_german_gog_3_23532.sh'
ARCHIVE_BASE_BG1_DE_1_MD5='0d81f1e8b62828e8a253df032b7f24f3'
ARCHIVE_BASE_BG1_DE_1_VERSION='1.3.5521-gog23532'
ARCHIVE_BASE_BG1_DE_1_SIZE='3369373'
ARCHIVE_BASE_BG1_DE_1_URL='https://www.gog.com/game/baldurs_gate_enhanced_edition'

ARCHIVE_BASE_BG1_FR_1_NAME='baldur_s_gate_the_original_saga_french_gog_3_23532.sh'
ARCHIVE_BASE_BG1_FR_1_MD5='09073e75602383c2c90d7c82436a8d91'
ARCHIVE_BASE_BG1_FR_1_VERSION='1.3.5521-gog23532'
ARCHIVE_BASE_BG1_FR_1_SIZE='3369868'
ARCHIVE_BASE_BG1_FR_1_URL='https://www.gog.com/game/baldurs_gate_enhanced_edition'

ARCHIVE_BASE_BG1_PL_1_NAME='baldur_s_gate_the_original_saga_polish_gog_3_23532.sh'
ARCHIVE_BASE_BG1_PL_1_MD5='9db5d4dd953e4bc7b42fbb6d0680437a'
ARCHIVE_BASE_BG1_PL_1_SIZE='3367441'
ARCHIVE_BASE_BG1_PL_1_VERSION='1.3.5521-gog23532'
ARCHIVE_BASE_BG1_PL_1_URL='https://www.gog.com/game/baldurs_gate_enhanced_edition'

ARCHIVE_BASE_BG1_EN_1_NAME='baldur_s_gate_the_original_saga_gog_3_23532.sh'
ARCHIVE_BASE_BG1_EN_1_MD5='f1750a05b52a5c8bb4810f0dbdb92091'
ARCHIVE_BASE_BG1_EN_1_SIZE='3342753'
ARCHIVE_BASE_BG1_EN_1_VERSION='1.3.5521-gog23532'
ARCHIVE_BASE_BG1_EN_1_URL='https://www.gog.com/game/baldurs_gate_enhanced_edition'

ARCHIVE_BASE_BG1_EN_0_NAME='gog_baldur_s_gate_the_original_saga_2.1.0.10.sh'
ARCHIVE_BASE_BG1_EN_0_MD5='6810388ef67960dded254db5750f9aa5'
ARCHIVE_BASE_BG1_EN_0_SIZE='3100000'
ARCHIVE_BASE_BG1_EN_0_VERSION='1.3.5521-gog2.1.0.10'

ARCHIVE_BASE_BG1_FR_0_NAME='gog_baldur_s_gate_the_original_saga_french_2.1.0.10.sh'
ARCHIVE_BASE_BG1_FR_0_MD5='87ed67decb79e497b8c0ce9e0b16ac4c'
ARCHIVE_BASE_BG1_FR_0_SIZE='3100000'
ARCHIVE_BASE_BG1_FR_0_VERSION='1.3.5521-gog2.1.0.10'

## Baldur's Gate 2

ARCHIVE_BASE_BG2_DE_1_NAME='baldur_s_gate_2_complete_german_gog_3_23651.sh'
ARCHIVE_BASE_BG2_DE_1_MD5='466b79a4dedd5ab142c7baa3e7554d89'
ARCHIVE_BASE_BG2_DE_1_SIZE='3365425'
ARCHIVE_BASE_BG2_DE_1_VERSION='2.5.26498-gog23651'
ARCHIVE_BASE_BG2_DE_1_URL='https://www.gog.com/game/baldurs_gate_2_enhanced_edition'

ARCHIVE_BASE_BG2_FR_1_NAME='baldur_s_gate_2_complete_french_gog_3_23651.sh'
ARCHIVE_BASE_BG2_FR_1_MD5='c72eb1b9bae7109de6a7005b3dc44e2c'
ARCHIVE_BASE_BG2_FR_1_SIZE='3295642'
ARCHIVE_BASE_BG2_FR_1_VERSION='2.5.26498-gog23651'
ARCHIVE_BASE_BG2_FR_1_URL='https://www.gog.com/game/baldurs_gate_2_enhanced_edition'

ARCHIVE_BASE_BG2_EN_1_NAME='baldur_s_gate_2_complete_gog_3_23651.sh'
ARCHIVE_BASE_BG2_EN_1_MD5='030a61ce961ac88cd9506f1fd42135d6'
ARCHIVE_BASE_BG2_EN_1_SIZE='3305036'
ARCHIVE_BASE_BG2_EN_1_VERSION='2.5.26498-gog23651'
ARCHIVE_BASE_BG2_EN_1_URL='https://www.gog.com/game/baldurs_gate_2_enhanced_edition'

ARCHIVE_BASE_BG2_FR_0_NAME='gog_baldur_s_gate_2_complete_french_2.1.0.7.sh'
ARCHIVE_BASE_BG2_FR_0_MD5='6551bda3d8c7330b7ad66842ac1d4ed4'
ARCHIVE_BASE_BG2_FR_0_SIZE='3000000'
ARCHIVE_BASE_BG2_FR_0_VERSION='2.5.26498-gog2.1.0.7'

ARCHIVE_BASE_BG2_EN_0_NAME='gog_baldur_s_gate_2_complete_2.1.0.7.sh'
ARCHIVE_BASE_BG2_EN_0_MD5='e92161d7fc0a2eea234b2c93760c9cdb'
ARCHIVE_BASE_BG2_EN_0_SIZE='3000000'
ARCHIVE_BASE_BG2_EN_0_VERSION='2.5.26498-gog2.1.0.7'

## Icewind Dale

ARCHIVE_BASE_IWD1_DE_0_NAME='setup_icewind_dale_complete_german_2.0.0.11.exe'
ARCHIVE_BASE_IWD1_DE_0_MD5='a43f9dc153f56de8f5891dcb8ccb4f46'
ARCHIVE_BASE_IWD1_DE_0_TYPE='innosetup'
ARCHIVE_BASE_IWD1_DE_0_SIZE='2115009'
ARCHIVE_BASE_IWD1_DE_0_VERSION='1.42.062714-gog2.0.0.11'
ARCHIVE_BASE_IWD1_DE_0_URL='https://www.gog.com/game/icewind_dale_enhanced_edition'

ARCHIVE_BASE_IWD1_EN_0_NAME='setup_icewind_dale_complete_2.0.0.11.exe'
ARCHIVE_BASE_IWD1_EN_0_MD5='b1395109232aac8d7f8455dad418b084'
ARCHIVE_BASE_IWD1_EN_0_TYPE='innosetup'
ARCHIVE_BASE_IWD1_EN_0_SIZE='2088514'
ARCHIVE_BASE_IWD1_EN_0_VERSION='1.42.062714-gog2.0.0.11'
ARCHIVE_BASE_IWD1_EN_0_URL='https://www.gog.com/game/icewind_dale_enhanced_edition'

## Icewind Dale 2

ARCHIVE_BASE_IWD2_DE_1_NAME='setup_icewind_dale_2_2.01_fixes_(german)_(77030).exe'
ARCHIVE_BASE_IWD2_DE_1_MD5='0421b0482f9cd8a7cbeb846c0c3628a0'
ARCHIVE_BASE_IWD2_DE_1_TYPE='innosetup'
ARCHIVE_BASE_IWD2_DE_1_PART1_NAME='setup_icewind_dale_2_2.01_fixes_(german)_(77030)-1.bin'
ARCHIVE_BASE_IWD2_DE_1_PART1_MD5='a6d2c460bfa37df5935a7ee0e92a2728'
ARCHIVE_BASE_IWD2_DE_1_SIZE='1582269'
ARCHIVE_BASE_IWD2_DE_1_VERSION='2.01.101615-gog77030'
ARCHIVE_BASE_IWD2_DE_1_URL='https://www.gog.com/game/icewind_dale_2'

ARCHIVE_BASE_IWD2_FR_1_NAME='setup_icewind_dale_2_2.01_fixes_(french)_(77030).exe'
ARCHIVE_BASE_IWD2_FR_1_MD5='8b25fcc3e12641efd79d6c2780f3cc03'
ARCHIVE_BASE_IWD2_FR_1_TYPE='innosetup'
ARCHIVE_BASE_IWD2_FR_1_PART1_NAME='setup_icewind_dale_2_2.01_fixes_(french)_(77030)-1.bin'
ARCHIVE_BASE_IWD2_FR_1_PART1_MD5='0d25ffba9a37471185327d0beedd7aaf'
ARCHIVE_BASE_IWD2_FR_1_SIZE='1552369'
ARCHIVE_BASE_IWD2_FR_1_VERSION='2.01.101615-gog77030'
ARCHIVE_BASE_IWD2_FR_1_URL='https://www.gog.com/game/icewind_dale_2'

ARCHIVE_BASE_IWD2_EN_1_NAME='setup_icewind_dale_2_2.01_fixes_(77030).exe'
ARCHIVE_BASE_IWD2_EN_1_MD5='7579f564757a6d9261a29b599a11f335'
ARCHIVE_BASE_IWD2_EN_1_TYPE='innosetup'
ARCHIVE_BASE_IWD2_EN_1_PART1_NAME='setup_icewind_dale_2_2.01_fixes_(77030)-1.bin'
ARCHIVE_BASE_IWD2_EN_1_PART1_MD5='79a7e58ea11380bbbf7329a97d522e3f'
ARCHIVE_BASE_IWD2_EN_1_SIZE='1555964'
ARCHIVE_BASE_IWD2_EN_1_VERSION='2.01.101615-gog77030'
ARCHIVE_BASE_IWD2_EN_1_URL='https://www.gog.com/game/icewind_dale_2'

ARCHIVE_BASE_IWD2_FR_0_NAME='setup_icewind_dale2_french_2.1.0.13.exe'
ARCHIVE_BASE_IWD2_FR_0_MD5='04f25433d405671a8975be6540dd55fa'
ARCHIVE_BASE_IWD2_FR_0_TYPE='innosetup'
ARCHIVE_BASE_IWD2_FR_0_SIZE='1500000'
ARCHIVE_BASE_IWD2_FR_0_VERSION='2.01.101615-gog2.1.0.13'

ARCHIVE_BASE_IWD2_EN_0_NAME='setup_icewind_dale2_2.1.0.13.exe'
ARCHIVE_BASE_IWD2_EN_0_MD5='9a68fdabdaff58bebc67092d47d4174e'
ARCHIVE_BASE_IWD2_EN_0_TYPE='innosetup'
ARCHIVE_BASE_IWD2_EN_0_SIZE='1500000'
ARCHIVE_BASE_IWD2_EN_0_VERSION='2.01.101615-gog2.1.0.13'

## Planescape: Torment

ARCHIVE_BASE_PST_DE_1_NAME='planescape_torment_german_gog_3_23483.sh'
ARCHIVE_BASE_PST_DE_1_MD5='fce317b1b81b903181f8e18c3dd967d6'
ARCHIVE_BASE_PST_DE_1_SIZE='2630297'
ARCHIVE_BASE_PST_DE_1_VERSION='1.1-gog23483'
ARCHIVE_BASE_PST_DE_1_URL='https://www.gog.com/game/planescape_torment_enhanced_edition'

ARCHIVE_BASE_PST_FR_1_NAME='planescape_torment_french_gog_3_23483.sh'
ARCHIVE_BASE_PST_FR_1_MD5='3374385ab6c5ca8aa489ee8de6161637'
ARCHIVE_BASE_PST_FR_1_SIZE='2625754'
ARCHIVE_BASE_PST_FR_1_VERSION='1.1-gog23483'
ARCHIVE_BASE_PST_FR_1_URL='https://www.gog.com/game/planescape_torment_enhanced_edition'

ARCHIVE_BASE_PST_RU_1_NAME='planescape_torment_russian_gog_3_23483.sh'
ARCHIVE_BASE_PST_RU_1_MD5='6f6744e90691126c884dccf925423e2d'
ARCHIVE_BASE_PST_RU_1_SIZE='2635240'
ARCHIVE_BASE_PST_RU_1_VERSION='1.1-gog23483'
ARCHIVE_BASE_PST_RU_1_URL='https://www.gog.com/game/planescape_torment_enhanced_edition'

ARCHIVE_BASE_PST_EN_1_NAME='planescape_torment_gog_3_23483.sh'
ARCHIVE_BASE_PST_EN_1_MD5='3eb98c2c34d628b7da6e4e914ac8e622'
ARCHIVE_BASE_PST_EN_1_SIZE='2635378'
ARCHIVE_BASE_PST_EN_1_VERSION='1.1-gog23483'
ARCHIVE_BASE_PST_EN_1_URL='https://www.gog.com/game/planescape_torment_enhanced_edition'

ARCHIVE_BASE_PST_FR_0_NAME='gog_planescape_torment_french_2.1.0.9.sh'
ARCHIVE_BASE_PST_FR_0_MD5='c3af554300a90297d4fca0b591d9c3fd'
ARCHIVE_BASE_PST_FR_0_SIZE='2400000'
ARCHIVE_BASE_PST_FR_0_VERSION='1.1-gog2.1.0.9'

ARCHIVE_BASE_PST_RU_0_NAME='gog_planescape_torment_russian_2.2.0.10.sh'
ARCHIVE_BASE_PST_RU_0_MD5='d6fd52fe9946bcc067eed441945127f1'
ARCHIVE_BASE_PST_RU_0_SIZE='2400000'
ARCHIVE_BASE_PST_RU_0_VERSION='1.1-gog2.2.0.10'

ARCHIVE_BASE_PST_EN_0_NAME='gog_planescape_torment_2.1.0.9.sh'
ARCHIVE_BASE_PST_EN_0_MD5='a48bb772f60da3b5b2cac804b6e92670'
ARCHIVE_BASE_PST_EN_0_SIZE='2400000'
ARCHIVE_BASE_PST_EN_0_VERSION='1.1-gog2.1.0.9'

## Baldur's Gate

CONTENT_PATH_DEFAULT_BG1_DE="data/noarch/prefix/drive_c/GOG Games/Baldur's Gate (German)"
CONTENT_PATH_DEFAULT_BG1_FR="data/noarch/prefix/drive_c/GOG Games/Baldur's Gate (French)"
CONTENT_PATH_DEFAULT_BG1_PL="data/noarch/prefix/drive_c/GOG Games/Baldur's Gate (Polish)"
CONTENT_PATH_DEFAULT_BG1_EN="data/noarch/prefix/drive_c/GOG Games/Baldur's Gate"
CONTENT_GAME_BIN_FILES_BG1='
luaauto.cfg
bgmain2.exe
bgmain.exe
mconvert.exe
keymap.ini'
## The following configuration file is generated by the current game script,
## the shipped version is ignored.
CONTENT_GAME0_BIN_FILES_BG1='
baldur.ini'
CONTENT_GAME_L10N_FILES_BG1='
characters
override
movies
mpsave
save
sounds
baldur.exe
config.exe
chitin.key
dialog.tlk
dialogf.tlk
data/areas.bif
data/guimos.bif
data/objanim.bif
data/scripts.bif
data/*sound*.bif'
CONTENT_GAME_DATA_FILES_BG1='
data
music
scripts'
CONTENT_DOC_L10N_PATH_BG1_DE='data/noarch/docs/german'
CONTENT_DOC_L10N_PATH_BG1_FR='data/noarch/docs/french'
CONTENT_DOC_L10N_PATH_BG1_PL='data/noarch/docs/polish'
CONTENT_DOC_L10N_PATH_BG1_EN='data/noarch/docs/english'
CONTENT_DOC_L10N_PATH_BG1_FR_0='data/noarch/docs'
CONTENT_DOC_L10N_PATH_BG1_EN_0='data/noarch/docs'
CONTENT_DOC_L10N_FILES_BG1='
*.pdf
*.txt'

## Baldur's Gate 2

CONTENT_PATH_DEFAULT_BG2_DE="data/noarch/prefix/drive_c/GOG Games/Baldur's Gate 2 (German)"
CONTENT_PATH_DEFAULT_BG2_FR="data/noarch/prefix/drive_c/GOG Games/Baldur's Gate 2 (French)"
CONTENT_PATH_DEFAULT_BG2_EN="data/noarch/prefix/drive_c/GOG Games/Baldur's Gate 2"
CONTENT_GAME_BIN_FILES_BG2='
script compiler
bgdxtest.exe
bggltest.exe
bgmain.exe
charview.exe'
## The following configuration file is generated by the current game script,
## the shipped version is ignored.
CONTENT_GAME0_BIN_FILES_BG2='
baldur.ini'
CONTENT_GAME_L10N_FILES_BG2='
characters
override
sounds
baldur.exe
bgconfig.exe
keymap.ini
chitin.key
dialog.tlk
dialogf.tlk
language.txt
data/movies
data/25npcso.bif
data/areas.bif
data/guimosc.bif
data/npchd0so.bif
data/objanim.bif
data/scripts.bif
data/npcsocd?.bif
data/*sound*.bif'
CONTENT_GAME_DATA_FILES_BG2='
data
music
scripts
bgate2.mpi'
CONTENT_DOC_L10N_PATH_BG2_DE='data/noarch/docs/german'
CONTENT_DOC_L10N_PATH_BG2_FR='data/noarch/docs/french'
CONTENT_DOC_L10N_PATH_BG2_EN='data/noarch/docs/english'
CONTENT_DOC_L10N_PATH_BG2_FR_0='data/noarch/docs'
CONTENT_DOC_L10N_PATH_BG2_EN_0='data/noarch/docs'
CONTENT_DOC_L10N_FILES_BG2='
*.pdf
*.txt'

## Icewind Dale

CONTENT_PATH_DEFAULT_IWD1='app'
CONTENT_GAME_BIN_FILES_IWD1='
config.exe
glsetup.exe
idmain.exe
keymap.ini'
## The following configuration file is generated by the current game script,
## the shipped version is ignored.
CONTENT_GAME0_BIN_FILES_IWD1='
icewind.ini'
CONTENT_GAME_L10N_FILES_IWD1='
characters
override
mpsave
scripts
sounds
language.ini
chitin.key
dialog.tlk
data/esfxvoh.bif
data/sndvo.bif
cd2/data/mvefile1.bif
cd2/data/sndvo.bif
cd3/data/emov1.bif
cd3/data/emov2.bif
cd3/data/esfxvo.bif'
CONTENT_GAME_DATA_FILES_IWD1='
cd2
cd3
data
music'
CONTENT_DOC_L10N_FILES_IWD1='
manual.pdf
patch_addon.txt
patch_addon2.txt
readme.txt
readme_addon.txt
readme_addon2.txt
readme_eng.txt'

## Icewind Dale 2

CONTENT_PATH_DEFAULT_IWD2='.'
CONTENT_PATH_DEFAULT_IWD2_FR_0='app'
CONTENT_PATH_DEFAULT_IWD2_EN_0='app'
## The following library is required to play videos.
CONTENT_LIBS_BIN_FILES_IWD2='
binkw32.dll'
CONTENT_GAME_BIN_FILES_IWD2='
config.exe
iwd2.exe
keymap.ini'
## The following configuration file is generated by the current game script,
## the shipped version is ignored.
CONTENT_GAME0_BIN_FILES_IWD2='
icewind2.ini'
CONTENT_GAME1_BIN_RELATIVE_PATH_IWD2='__support/app'
CONTENT_GAME1_BIN_FILES_IWD2='
iwd2.exe
keymap.ini'
CONTENT_GAME_L10N_FILES_IWD2='
characters
override
sounds
language.ini
party.ini
chitin.key
dialog.tlk
dialogf.tlk
cd2/data/sndvo.bif
cd2/data/*.mve'
CONTENT_GAME0_L10N_RELATIVE_PATH_IWD2='__support/app'
CONTENT_GAME0_L10N_FILES_IWD2='
party.ini'
CONTENT_GAME_DATA_FILES_IWD2='
cd2
data
music
scripts'
CONTENT_DOC_L10N_FILES_IWD2='
readme.htm
manual.pdf
patch.txt'

## Planescape: Torment

CONTENT_PATH_DEFAULT_PST_DE='data/noarch/prefix/drive_c/GOG Games/Planescape Torment (German)'
CONTENT_PATH_DEFAULT_PST_FR='data/noarch/prefix/drive_c/GOG Games/Planescape Torment (French)'
CONTENT_PATH_DEFAULT_PST_RU='data/noarch/prefix/drive_c/GOG Games/Planescape Torment (Russian)'
CONTENT_PATH_DEFAULT_PST_EN='data/noarch/prefix/drive_c/GOG Games/Planescape Torment'
CONTENT_GAME_BIN_FILES_PST='
torment.exe
autonote.ini
beast.ini
keymap.ini
layout.ini
quests.ini'
## The following configuration file is generated by the current game script,
## the shipped version is ignored.
CONTENT_GAME0_BIN_FILES_PST='
torment.ini'
CONTENT_GAME_L10N_FILES_PST='
override
cachemos.bif
crefiles.bif
cs_0404.bif
interface.bif
sound.bif
voice.bif
chitin.key
dialog.tlk
dialogf.tlk
data/genmova.bif
data/movies?.bif'
CONTENT_GAME_DATA_FILES_PST='
data
music
var.var
*.bif'
CONTENT_DOC_L10N_PATH_PST_DE='data/noarch/docs/german'
CONTENT_DOC_L10N_PATH_PST_FR='data/noarch/docs/french'
CONTENT_DOC_L10N_PATH_PST_RU='data/noarch/docs/russian'
CONTENT_DOC_L10N_PATH_PST_EN='data/noarch/docs/english'
CONTENT_DOC_L10N_PATH_PST_FR_0='data/noarch/docs'
CONTENT_DOC_L10N_PATH_PST_RU_0='data/noarch/docs'
CONTENT_DOC_L10N_PATH_PST_EN_0='data/noarch/docs'
CONTENT_DOC_L10N_FILES_PST='
*.pdf
*.txt'

USER_PERSISTENT_FILES='
*.ini'
USER_PERSISTENT_DIRECTORIES='
characters
mpsave
save'

APPLICATIONS_LIST='APP_MAIN APP_CONFIG'
APPLICATIONS_LIST_PST='APP_MAIN'

APP_MAIN_EXE_BG1='bgmain2.exe'
APP_MAIN_EXE_BG2='bgmain.exe'
APP_MAIN_EXE_IWD1='idmain.exe'
APP_MAIN_EXE_IWD2='iwd2.exe'
APP_MAIN_EXE_PST='torment.exe'
APP_MAIN_ICON_BG1='baldur.exe'
APP_MAIN_ICON_BG2='baldur.exe'
APP_MAIN_ICON_IWD2='__support/app/iwd2.exe'
APP_MAIN_ICON_IWD2_FR_0='iwd2.exe'
APP_MAIN_ICON_IWD2_EN_0='iwd2.exe'

APP_CONFIG_ID_BG1="${GAME_ID_BG1}-config"
APP_CONFIG_ID_BG2="${GAME_ID_BG2}-config"
APP_CONFIG_ID_IWD1="${GAME_ID_IWD1}-config"
APP_CONFIG_ID_IWD2="${GAME_ID_IWD2}-config"
APP_CONFIG_NAME_BG1="$GAME_NAME_BG1 - configuration"
APP_CONFIG_NAME_BG2="$GAME_NAME_BG2 - configuration"
APP_CONFIG_NAME_IWD1="$GAME_NAME_IWD1 - configuration"
APP_CONFIG_NAME_IWD2="$GAME_NAME_IWD2 - configuration"
APP_CONFIG_EXE_BG1='config.exe'
APP_CONFIG_EXE_BG2='bgconfig.exe'
APP_CONFIG_EXE_IWD1='config.exe'
APP_CONFIG_EXE_IWD2='config.exe'
APP_CONFIG_CAT='Settings'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'

PKG_L10N_BASE_ID_BG1="${GAME_ID_BG1}-l10n"
PKG_L10N_BASE_ID_BG2="${GAME_ID_BG2}-l10n"
PKG_L10N_BASE_ID_IWD1="${GAME_ID_IWD1}-l10n"
PKG_L10N_BASE_ID_IWD2="${GAME_ID_IWD2}-l10n"
PKG_L10N_BASE_ID_PST="${GAME_ID_PST}-l10n"
PKG_L10N_ID_BG1_DE="${PKG_L10N_BASE_ID_BG1}-de"
PKG_L10N_ID_BG1_FR="${PKG_L10N_BASE_ID_BG1}-fr"
PKG_L10N_ID_BG1_PL="${PKG_L10N_BASE_ID_BG1}-pl"
PKG_L10N_ID_BG1_EN="${PKG_L10N_BASE_ID_BG1}-en"
PKG_L10N_ID_BG2_DE="${PKG_L10N_BASE_ID_BG2}-de"
PKG_L10N_ID_BG2_FR="${PKG_L10N_BASE_ID_BG2}-fr"
PKG_L10N_ID_BG2_EN="${PKG_L10N_BASE_ID_BG2}-en"
PKG_L10N_ID_IWD1_DE="${PKG_L10N_BASE_ID_IWD1}-de"
PKG_L10N_ID_IWD1_EN="${PKG_L10N_BASE_ID_IWD1}-en"
PKG_L10N_ID_IWD2_DE="${PKG_L10N_BASE_ID_IWD2}-de"
PKG_L10N_ID_IWD2_EN="${PKG_L10N_BASE_ID_IWD2}-en"
PKG_L10N_ID_IWD2_FR="${PKG_L10N_BASE_ID_IWD2}-fr"
PKG_L10N_ID_PST_DE="${PKG_L10N_BASE_ID_PST}-de"
PKG_L10N_ID_PST_FR="${PKG_L10N_BASE_ID_PST}-fr"
PKG_L10N_ID_PST_RU="${PKG_L10N_BASE_ID_PST}-ru"
PKG_L10N_ID_PST_EN="${PKG_L10N_BASE_ID_PST}-en"
PKG_L10N_PROVIDES_BG1="
$PKG_L10N_BASE_ID_BG1"
PKG_L10N_PROVIDES_BG2="
$PKG_L10N_BASE_ID_BG2"
PKG_L10N_PROVIDES_IWD1="
$PKG_L10N_BASE_ID_IWD1"
PKG_L10N_PROVIDES_IWD2="
$PKG_L10N_BASE_ID_IWD2"
PKG_L10N_PROVIDES_PST="
$PKG_L10N_BASE_ID_PST"
PKG_L10N_DESCRIPTION_BG1_DE='German localisation'
PKG_L10N_DESCRIPTION_BG1_FR='French localisation'
PKG_L10N_DESCRIPTION_BG1_PL='Polish localisation'
PKG_L10N_DESCRIPTION_BG1_EN='English localisation'
PKG_L10N_DESCRIPTION_BG2_DE='German localisation'
PKG_L10N_DESCRIPTION_BG2_FR='French localisation'
PKG_L10N_DESCRIPTION_BG2_EN='English localisation'
PKG_L10N_DESCRIPTION_IWD1_DE='German localisation'
PKG_L10N_DESCRIPTION_IWD1_EN='English localisation'
PKG_L10N_DESCRIPTION_IWD2_DE='German localisation'
PKG_L10N_DESCRIPTION_IWD2_FR='French localisation'
PKG_L10N_DESCRIPTION_IWD2_EN='English localisation'
PKG_L10N_DESCRIPTION_PST_DE='German localisation'
PKG_L10N_DESCRIPTION_PST_FR='French localisation'
PKG_L10N_DESCRIPTION_PST_RU='Russian localisation'
PKG_L10N_DESCRIPTION_PST_EN='English localisation'

PKG_DATA_ID_BG1="${GAME_ID_BG1}-data"
PKG_DATA_ID_BG2="${GAME_ID_BG2}-data"
PKG_DATA_ID_IWD1="${GAME_ID_IWD1}-data"
PKG_DATA_ID_IWD2="${GAME_ID_IWD2}-data"
PKG_DATA_ID_PST="${GAME_ID_PST}-data"
PKG_DATA_DESCRIPTION='data'

# convmv is used to convert file paths to lower case.

REQUIREMENTS_LIST_BG1='
convmv'
REQUIREMENTS_LIST_BG2='
convmv'
REQUIREMENTS_LIST_PST='
convmv'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
## Mojosetup installers - Convert all file names to lowercase
if [ "$(archive_type "$(current_archive)")" = 'mojosetup' ]; then
	tolower "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
fi
## Baldur's Gate 2
case "$(current_archive)" in
	('ARCHIVE_BASE_BG2_'*)
		# Delete broken symbolic links.
		## TODO: Check if this is still required.
		rm --force --recursive \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/mpsave" \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/temp"
		# Drop duplicated files.
		rm \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/data/data/cd3crean.bif" \
			"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/data/data/cd4crea3.bif"
		if [ -e "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/data/data/cdcreani.bif" ]; then
			mv \
				"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/data/data/cdcreani.bif" \
				"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/data/cdcreani.bif"
		fi
	;;
esac

# Generate a minimal configuration file.

case "$(current_archive)" in
	('ARCHIVE_BASE_BG1_'*)
		config_name='baldur.ini'
	;;
	('ARCHIVE_BASE_BG2_'*)
		config_name='baldur.ini'
	;;
	('ARCHIVE_BASE_IWD1_'*)
		config_name='icewind.ini'
	;;
	('ARCHIVE_BASE_IWD2_'*)
		config_name='icewind2.ini'
	;;
	('ARCHIVE_BASE_PST_'*)
		config_name='torment.ini'
	;;
esac
config_file="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/${config_name}"
game_path="C:\\$(game_id)"
case "$(current_archive)" in
	('ARCHIVE_BASE_BG1_'*)
		cat > "$config_file" <<- EOF
		[Alias]
		HD0:=${game_path}\\
		CD1:=${game_path}\\data\\
		CD2:=${game_path}\\data\\
		CD3:=${game_path}\\data\\
		CD4:=${game_path}\\data\\
		CD5:=${game_path}\\data\\
		CD6:=${game_path}\\data\\
		EOF
	;;
	('ARCHIVE_BASE_BG2_'*)
		cat > "$config_file" <<- EOF
		[Alias]
		HD0:=${game_path}\\
		CD1:=${game_path}\\data\\
		CD2:=${game_path}\\data\\
		CD3:=${game_path}\\data\\
		CD4:=${game_path}\\data\\
		CD5:=${game_path}\\data\\
		CD6:=${game_path}\\data\\
		EOF
	;;
	('ARCHIVE_BASE_IWD1_'*)
		cat > "$config_file" <<- EOF
		[Alias]
		HD0:=${game_path}\\
		CD1:=${game_path}\\
		CD2:=${game_path}\\cd2\\
		CD3:=${game_path}\\cd3\\
		EOF
	;;
	('ARCHIVE_BASE_IWD2_'*)
		cat > "$config_file" <<- EOF
		[Alias]
		HD0:=${game_path}\\
		CD1:=${game_path}\\data\\
		CD2:=${game_path}\\cd2\\
		[Movies]
		INTRO=1
		EOF
	;;
	('ARCHIVE_BASE_PST_'*)
		cat > "$config_file" <<- EOF
		[Alias]
		HD0:=${game_path}\\
		CD1:=${game_path}\\data\\
		CD2:=${game_path}\\data\\
		CD3:=${game_path}\\data\\
		CD4:=${game_path}\\data\\
		CD5:=${game_path}\\data\\
		EOF
	;;
esac
## The native windowed mode is used instead of a WINE virtual desktop, as using a WINE virtual desktop would cause cursor flickering.
## cf. https://bugs.winehq.org/show_bug.cgi?id=56986
## At least with Baldur's Gate 2, the cursor flickering can be avoided by enabling 3D acceleration.
## The lack of a WINE virtual desktop can cause loss of display and input on loss of focus, but only when the game is running in fullscreen.
## (WINE 9.13).
cat >> "$config_file" <<- EOF
[Program Options]
Full Screen=0
EOF

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Icewind Dale 2 - Install shipped libraries.
case "$(current_archive)" in
	('ARCHIVE_BASE_IWD2_'*)
		wineprefix_init_custom() {
			cat <<- EOF
			# Install shipped libraries.
			PATH_LIBRARIES_SYSTEM='$(path_libraries)'
			EOF
			cat <<- 'EOF'
			find "$PATH_LIBRARIES_SYSTEM" -iname '*.dll' | while read -r dll_source; do
				dll_destination="${PATH_PREFIX}${dll_source#"${PATH_LIBRARIES_SYSTEM}"}"
			    mkdir --parents "$(dirname "$dll_destination")"
			    ln --symbolic "$dll_source" "$dll_destination"
			done
			EOF
		}
	;;
esac

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
